/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.DVExitListener;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvClassDetailsDisplay;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvConstants;
import com.ibm.jvm.dump.format.DvFormatAs;
import com.ibm.jvm.dump.format.DvJavaFrame;
import com.ibm.jvm.dump.format.DvMenu;
import com.ibm.jvm.dump.format.DvMenuItem;
import com.ibm.jvm.dump.format.DvMouseListener;
import com.ibm.jvm.dump.format.DvNativeFrame;
import com.ibm.jvm.dump.format.DvNativeStack;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvRegister;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.Dvifm;
import com.ibm.jvm.dump.format.DvifmFrame;
import com.ibm.jvm.dump.format.SwingWorker;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.CommandPluginResponse;
import com.ibm.jvm.dump.plugins.DvBaseCommands;
import com.ibm.jvm.dump.plugins.DvBaseCommandsGui;
import com.ibm.jvm.dump.plugins.DvObjectsCommands;
import com.ibm.jvm.dump.plugins.DvObjectsCommandsGui;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;

public class Dumpviewer
extends JFrame
implements Observer,
Printable {
    public static Vector objectStats = new Vector();
    public static String heapTraverseQuestion = "In order to execute this command the heaps must be\ntraversed. This can take a long time and will be done\nas a standalone event. When heap traversal is completed\n you should redo your command\n              Continue?";
    public static JMenuItem savedSetFF;
    public static JMenuItem savedWorkDir;
    public static boolean heapsTraversed;
    public static boolean waitingOnConsoleCommand;
    public static DvBaseCommands savedDvbc;
    public static Vector savedConsoleOutput;
    static boolean bWindowManagerIsGo;
    public static Dvifm theIFM;
    public static JDesktopPane desktop;
    public static JCheckBoxMenuItem wm;
    public static JCheckBoxMenuItem systemErrTrace;
    public static JMenuItem help_menu;
    public static DVExitListener exitListener;
    public static JInternalFrame wm_frame;
    static JTree wm_tree;
    static JInternalFrame status_frame;
    static JLabel status;
    static JInternalFrame message_frame;
    static JTextArea msg_text;
    public static String theFileName;
    static Vector consoleInitOutput;
    public static boolean is32BitDump;
    public static boolean is64BitDump;
    public static boolean isBigEndDump;
    public static boolean isLittleEndDump;
    public static int currentAS;
    public static DvConsole dvConsole;
    public static Dumpviewer selfRef;
    Object mainHS = null;
    Object mainHB = null;
    static boolean bHelpInitialised;
    static final String helpsetName = "com/ibm/jvm/dump/format/DvHelp.hs";
    static final String helpsetLabel = "Dumpviewer - Help";
    static boolean file_chosen;
    public static JMenuBar mainmenubar;
    private static DvMenuItem[] fullMenuItems;
    private static DvMenu[] fullMenu;
    private static DvMenu[] left_menus;
    private static DvMenu[] right_menus;
    private static String thisName;
    private static DvMenuItem[] left_menuItems;
    private static DvMenuItem[] right_menuItems;

    public static void main(String[] stringArray) {
        Dumpviewer dumpviewer = new Dumpviewer(false, null);
        dumpviewer.setVisible(true);
        if (null != consoleInitOutput) {
            message_frame = theIFM.createNewFrame("Message", theIFM.getDefaultProperties() - 2, 0);
            Dumpviewer.addIFrameToDesktop(message_frame, 200, 400, 5, selfRef.getHeight() - 330);
            msg_text = new JTextArea("", 8, 25);
            msg_text.setEditable(false);
            theIFM.addContentToFrame(message_frame, msg_text);
            String string = "";
            for (int i = 0; i < consoleInitOutput.size(); ++i) {
                string = string + (String)consoleInitOutput.get(i);
                string = string + "\n";
            }
            Dumpviewer.showMessage(string, false);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("\nInterruptedException");
            }
            try {
                message_frame.setIcon(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public Dumpviewer(boolean bl, String string) {
        super("Dumpviewer");
        String string2 = DvUtils.getDvProperty("Version");
        this.setTitle(string2);
        selfRef = this;
        String string3 = DvUtils.getDvProperty("ConsoleTrace");
        if (null != string3 && string3.equals("Y")) {
            DvUtils.enableConsoleTrace(true);
        }
        String string4 = null;
        string4 = true == bl ? "Y" : DvUtils.getDvProperty("EarlyTrace");
        DvComponentListener dvComponentListener = new DvComponentListener();
        this.addComponentListener(dvComponentListener);
        dvConsole = new DvConsole(true, this, consoleInitOutput);
        desktop = new JDesktopPane();
        this.setupDesk(desktop);
        this.setContentPane(desktop);
        Dumpviewer.initHelp("dummy");
        theIFM = new Dvifm();
        theIFM.addPluginMenuItem(dvConsole);
        DvUtils.setTheIFM(theIFM);
        if (null != string4 && string4.equals("Y")) {
            DvConsole.bSystemErrTrace = true;
            systemErrTrace.setSelected(true);
        }
        DvUtils.writetoTrace("DeskTop height/width is " + selfRef.getHeight() + "/" + selfRef.getWidth());
        this.addStatusLine();
        wm.setSelected(true);
        theFileName = string;
        if (theFileName == null) {
            Dumpviewer.setStatusLine("Awaiting dump identification....");
        } else {
            Dumpviewer.setStatusLine("Validating dump: " + theFileName);
            DvBaseCommandsGui.selfRef.loadFile(theFileName);
        }
    }

    private void addStatusLine() {
        status_frame = theIFM.createNewFrame("Status Line", 0, 4);
        Dumpviewer.addIFrameToDesktop(status_frame, 30, this.getWidth() - 10, 0, this.getHeight() - 80);
        status = new JLabel("Initializing....");
        status_frame.setBackground(Color.lightGray);
        status_frame.setBorder(BorderFactory.createLoweredBevelBorder());
        status_frame.getContentPane().add("West", status);
    }

    public static void setupWMFrame() {
        DvUtils.writetoTrace("setting up Window Manager");
        wm_frame = theIFM.createNewFrame("Window Manager", theIFM.getDefaultProperties() - 2 - 8, 3);
        Dumpviewer.addIFrameToDesktop(wm_frame, 200, 200, selfRef.getWidth() - 210, selfRef.getHeight() - 280);
        wm_tree = Dumpviewer.fillWMTree(wm_frame);
        theIFM.addContentToFrame(wm_frame, wm_tree);
    }

    public static JTree fillWMTree(JInternalFrame jInternalFrame) {
        Serializable serializable;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Windows");
        boolean bl = false;
        int n = -1;
        int n2 = 0;
        Enumeration enumeration = theIFM.getIFrameElements();
        while (enumeration.hasMoreElements()) {
            serializable = new DefaultMutableTreeNode(((DvifmFrame)enumeration.nextElement()).iframeTitle);
            defaultMutableTreeNode.insert((MutableTreeNode)((Object)serializable), n2);
            ++n2;
        }
        serializable = new JTree(defaultMutableTreeNode);
        ((JTree)serializable).getSelectionModel().setSelectionMode(1);
        Icon icon = null;
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(icon);
        defaultTreeCellRenderer.setClosedIcon(icon);
        defaultTreeCellRenderer.setOpenIcon(icon);
        ((JTree)serializable).setCellRenderer(defaultTreeCellRenderer);
        WMMouseListener wMMouseListener = new WMMouseListener();
        wMMouseListener.whatIframe = jInternalFrame;
        ((Component)serializable).addMouseListener(wMMouseListener);
        return serializable;
    }

    public static JTree createASIDTree() {
        DvAddressSpace dvAddressSpace;
        JTree jTree = null;
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Asid->Process->Threads");
        int n = 0;
        vector.add(defaultMutableTreeNode);
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
        DvAddressSpace[] dvAddressSpaceArray = DvConsole.theDump.getAddressSpaces();
        if (null == dvAddressSpaceArray) {
            DvUtils.writetoTrace(" No address spaces found");
        } else {
            dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
            dvAddressSpaceArray[0].getMemRanges();
            int n2 = dvAddressSpaceArray.length;
            for (int i = 0; i < n2; ++i) {
                DvProcess[] dvProcessArray = null;
                n = 1;
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)vector.get(n - 1);
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Address Space " + dvAddressSpaceArray[i].id());
                if (vector.size() <= n) {
                    vector.add(defaultMutableTreeNode3);
                } else {
                    vector.set(n, defaultMutableTreeNode3);
                }
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                dvProcessArray = dvAddressSpaceArray[i].getProcesses();
                for (int j = 0; j < dvProcessArray.length; ++j) {
                    n = 2;
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)vector.get(n - 1);
                    defaultMutableTreeNode3 = new DefaultMutableTreeNode("Process " + dvProcessArray[j].id());
                    if (vector.size() <= n) {
                        vector.add(defaultMutableTreeNode3);
                    } else {
                        vector.set(n, defaultMutableTreeNode3);
                    }
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    DvThread[] dvThreadArray = dvProcessArray[j].getThreads();
                    for (int k = 0; k < dvThreadArray.length; ++k) {
                        Object object;
                        int n3;
                        String[] stringArray;
                        n = 3;
                        defaultMutableTreeNode2 = (DefaultMutableTreeNode)vector.get(n - 1);
                        defaultMutableTreeNode3 = dvThreadArray[k].isJava() ? new DefaultMutableTreeNode("Thread " + dvThreadArray[k].id() + " (" + DvUtils.getThreadName(dvThreadArray[k], dvAddressSpaceArray[i]) + ")") : new DefaultMutableTreeNode("Thread " + dvThreadArray[k].id() + " (non-java)");
                        if (vector.size() <= n) {
                            vector.add(defaultMutableTreeNode3);
                        } else {
                            vector.set(n, defaultMutableTreeNode3);
                        }
                        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                        if (!dvThreadArray[k].isJava()) continue;
                        defaultMutableTreeNode2 = defaultMutableTreeNode3;
                        n = 4;
                        long l = dvThreadArray[k].eeAddress().getAddressAsLong();
                        String string = Long.toHexString(l);
                        defaultMutableTreeNode3 = new DefaultMutableTreeNode("ee: 0x" + string);
                        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                        long l2 = DvUtils.jvmFromExecenv(dvAddressSpaceArray[i], dvThreadArray[k].eeAddress());
                        String string2 = Long.toHexString(l2);
                        defaultMutableTreeNode3 = new DefaultMutableTreeNode("jvmp: 0x" + string2);
                        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                        DefaultMutableTreeNode defaultMutableTreeNode4 = defaultMutableTreeNode2;
                        DvRegister[] dvRegisterArray = dvThreadArray[k].getRegisters();
                        if (null != dvRegisterArray) {
                            defaultMutableTreeNode3 = new DefaultMutableTreeNode("registers");
                            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                            defaultMutableTreeNode2 = defaultMutableTreeNode3;
                            for (int i2 = 0; i2 < dvRegisterArray.length; ++i2) {
                                stringArray = dvRegisterArray[i2].getStringArray();
                                for (n3 = 0; n3 < stringArray.length; ++n3) {
                                    defaultMutableTreeNode3 = new DefaultMutableTreeNode(stringArray[n3]);
                                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                                }
                            }
                        } else {
                            defaultMutableTreeNode3 = new DefaultMutableTreeNode("registers : Not Available");
                            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                        }
                        defaultMutableTreeNode2 = defaultMutableTreeNode4;
                        DvNativeStack dvNativeStack = dvThreadArray[k].getNativeStack();
                        stringArray = dvThreadArray[k].getJavaStack();
                        if (null != dvNativeStack && dvNativeStack.getNumFrames() > 0L) {
                            defaultMutableTreeNode3 = new DefaultMutableTreeNode("native stack");
                            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                            defaultMutableTreeNode2 = defaultMutableTreeNode3;
                            n3 = 0;
                            while ((long)n3 < dvNativeStack.getNumFrames()) {
                                object = dvNativeStack.getFrame(n3);
                                defaultMutableTreeNode3 = null != object ? new DefaultMutableTreeNode(((DvNativeFrame)object).toString()) : new DefaultMutableTreeNode(" --- Null frame --");
                                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                                ++n3;
                            }
                        } else {
                            defaultMutableTreeNode3 = new DefaultMutableTreeNode("native stack: Not Available");
                            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                        }
                        defaultMutableTreeNode2 = defaultMutableTreeNode4;
                        if (null != stringArray && stringArray.getNumFrames() > 0L) {
                            defaultMutableTreeNode3 = new DefaultMutableTreeNode("java stack");
                            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                            defaultMutableTreeNode2 = defaultMutableTreeNode3;
                            n3 = 0;
                            while ((long)n3 < stringArray.getNumFrames()) {
                                object = stringArray.getFrame(n3);
                                defaultMutableTreeNode3 = null != object && !((DvJavaFrame)object).isPseudo() ? new DefaultMutableTreeNode(((DvJavaFrame)object).toString()) : (null != object && ((DvJavaFrame)object).isPseudo() ? new DefaultMutableTreeNode(" --- Pseudo-frame ---") : new DefaultMutableTreeNode(" --- Null-frame ---"));
                                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                                ++n3;
                            }
                            continue;
                        }
                        defaultMutableTreeNode3 = new DefaultMutableTreeNode("java stack: Not Available");
                        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    }
                }
            }
        }
        jTree = new JTree(defaultMutableTreeNode);
        jTree.getSelectionModel().setSelectionMode(1);
        dvAddressSpace = null;
        jTree.setFont(new Font("Monospaced", 0, 12));
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon((Icon)((Object)dvAddressSpace));
        defaultTreeCellRenderer.setClosedIcon((Icon)((Object)dvAddressSpace));
        defaultTreeCellRenderer.setOpenIcon((Icon)((Object)dvAddressSpace));
        jTree.setCellRenderer(defaultTreeCellRenderer);
        return jTree;
    }

    public static void addIFrameToDesktop(JInternalFrame jInternalFrame) {
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 300, 300, 10, 10);
    }

    public static void addIFrameToDesktop(JInternalFrame jInternalFrame, int n, int n2, int n3, int n4) {
        DvUtils.writetoTrace("Adding frame to desktop h:" + n + " w:" + n2 + " x: " + n3 + " y: " + n4);
        jInternalFrame.setVisible(true);
        jInternalFrame.setLocation(n3, n4);
        jInternalFrame.setSize(n2, n);
        jInternalFrame.setBackground(Color.white);
        desktop.add(jInternalFrame);
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setupStatusLine(JDesktopPane jDesktopPane) {
        status = new JLabel("Status Line");
        status.setBorder(BorderFactory.createLoweredBevelBorder());
        status.setVisible(true);
        jDesktopPane.putClientProperty("JDesktopPane.dragMode", "outline");
        jDesktopPane.add((Component)status, "South");
    }

    public void setupDesk(JDesktopPane jDesktopPane) {
        this.setupMenuBar(jDesktopPane);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = new Dimension((int)(dimension.getWidth() - 40.0), (int)(dimension.getHeight() - 40.0));
        this.setBounds(50, 50, (int)(dimension.getWidth() - 100.0), (int)(dimension.getHeight() - 100.0));
    }

    public void setupMenuBar(JDesktopPane jDesktopPane) {
        int n;
        Object object;
        int n2;
        int n3;
        int n4;
        JMenuBar jMenuBar = this.getJMenuBar();
        boolean bl = false;
        if (null != jMenuBar) {
            int n5;
            bl = true;
            for (int i = n5 = jMenuBar.getMenuCount(); i > 0; --i) {
                JMenu jMenu = jMenuBar.getMenu(i - 1);
                for (n4 = n3 = jMenu.getItemCount(); n4 > 0; --n4) {
                    jMenu.removeAll();
                    jMenu.removeNotify();
                }
                jMenuBar.remove(i - 1);
            }
            jMenuBar.removeNotify();
        }
        mainmenubar = new JMenuBar();
        Vector<DvMenu> vector = new Vector<DvMenu>();
        Vector<DvMenuItem> vector2 = new Vector<DvMenuItem>();
        for (n2 = 0; n2 < left_menus.length; ++n2) {
            vector.add(left_menus[n2]);
        }
        for (n2 = 0; n2 < left_menuItems.length; ++n2) {
            vector2.add(left_menuItems[n2]);
        }
        Vector vector3 = DvConsole.getCommandPluginVector();
        n3 = vector3.size();
        DvUtils.writetoTrace("Asking each command plugin what menus it supports ");
        for (n4 = 0; n4 < n3; ++n4) {
            CommandPlugin commandPlugin = (CommandPlugin)vector3.get(n4);
            object = commandPlugin.guiMenus();
            int n6 = ((Vector)object).size();
            if (0 != n6) {
                for (int i = 0; i < n6; ++i) {
                    Object e = ((Vector)object).get(i);
                    if (e instanceof DvMenu) {
                        vector.add((DvMenu)e);
                    }
                    if (!(e instanceof DvMenuItem)) continue;
                    vector2.add((DvMenuItem)e);
                }
                continue;
            }
            DvUtils.writetoTrace(" Plugin " + commandPlugin.pluginName() + " does not support gui");
        }
        for (n4 = 0; n4 < right_menus.length; ++n4) {
            vector.add(right_menus[n4]);
        }
        for (n4 = 0; n4 < right_menuItems.length; ++n4) {
            vector2.add(right_menuItems[n4]);
        }
        n4 = vector.size();
        fullMenu = new DvMenu[n4];
        for (n = 0; n < n4; ++n) {
            object = vector.get(n);
            if (!(object instanceof DvMenu)) continue;
            mainmenubar.add((DvMenu)object);
            Dumpviewer.fullMenu[n] = (DvMenu)object;
        }
        n4 = vector2.size();
        fullMenuItems = new DvMenuItem[n4];
        for (n = 0; n < n4; ++n) {
            object = vector2.get(n);
            if (!(object instanceof DvMenuItem)) continue;
            Dumpviewer.addItemToMenu((DvMenuItem)object, fullMenu);
            Dumpviewer.fullMenuItems[n] = (DvMenuItem)object;
            if (!(((DvMenuItem)object).theItem instanceof JMenuItem)) continue;
            JMenuItem jMenuItem = (JMenuItem)((DvMenuItem)object).theItem;
            if (jMenuItem.getText().equals("Set FormatFile")) {
                savedSetFF = jMenuItem;
            }
            if (!jMenuItem.getText().equals("Set WorkDir")) continue;
            savedWorkDir = jMenuItem;
        }
        String string = DvBaseCommandsGui.setUpFileHistory("f", bl);
        string = savedSetFF.getText() + " (" + string + ")";
        savedSetFF.setText(string);
        object = DvBaseCommandsGui.setUpFileHistory("w", false);
        DvUtils.setValue("WORKDIR", (String)object);
        object = savedWorkDir.getText() + " (" + (String)object + ")";
        savedWorkDir.setText((String)object);
        this.setJMenuBar(mainmenubar);
    }

    public static String convertArchitecture(int n) {
        int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384};
        int n2 = n;
        boolean bl = false;
        String string = "";
        if (n2 < 32768) {
            for (int i = nArray.length - 1; i > -1; --i) {
                if (n2 < nArray[i]) continue;
                try {
                    string = string + DvConstants.ARCH_DESCRIPTIONS[i];
                    bl = true;
                    if (nArray[i] == 1) {
                        is32BitDump = true;
                    }
                    if (nArray[i] == 2) {
                        is64BitDump = true;
                    }
                    if (nArray[i] == 4) {
                        isBigEndDump = true;
                    }
                    if (nArray[i] == 8) {
                        isLittleEndDump = true;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                n2 -= nArray[i];
            }
        }
        if (bl) {
            return string;
        }
        return "Architecture unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable observable, Object object) {
        Observable observable2 = observable;
        synchronized (observable2) {
            waitingOnConsoleCommand = false;
            Vector vector = savedConsoleOutput;
            synchronized (vector) {
                if (object instanceof Vector) {
                    for (int i = 0; i < ((Vector)object).size(); ++i) {
                        savedConsoleOutput.add(((Vector)object).get(i));
                    }
                } else if (object instanceof String) {
                    savedConsoleOutput.add(new String((String)object));
                } else {
                    savedConsoleOutput.add(object);
                }
            }
        }
    }

    public static void addItemToMenu(DvMenuItem dvMenuItem, DvMenu[] dvMenuArray) {
        for (int i = 0; i < dvMenuArray.length; ++i) {
            if (!dvMenuItem.menu.equals(dvMenuArray[i].name)) continue;
            dvMenuArray[i].add((JMenuItem)dvMenuItem.theItem);
            if (null == dvMenuItem.tooltip) continue;
            ((JMenuItem)dvMenuItem.theItem).setToolTipText(dvMenuItem.tooltip);
        }
    }

    public static Object createGenericListener() {
        return new GenericMMBActionListener();
    }

    public static void actionAllWindows(String string) {
        DvUtils.writetoTrace(" actionAllWindows entry: " + string);
        if (string.startsWith("Icon")) {
            Dvifm.iconifyAll(true);
        }
        if (string.startsWith("DeIcon")) {
            Dvifm.iconifyAll(false);
        }
        if (string.startsWith("Close")) {
            Dvifm.closeAll();
        }
        DvUtils.writetoTrace(" actionAllWindows exit");
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2 = 1;
        DvUtils.writetoTrace(" printing page index:" + n);
        if (n == 0) {
            JInternalFrame jInternalFrame = Dvifm.getCurrentJif();
            graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            graphics.setColor(Color.black);
            jInternalFrame.printComponents(graphics);
            n2 = 0;
        }
        return n2;
    }

    public static void doPrintFrame(String string) {
        DvUtils.writetoTrace(" doPrintFrame entry");
        Thread thread = new Thread(){

            public void run() {
                Dumpviewer.printData();
            }
        };
        thread.start();
        DvUtils.writetoTrace(" doPrintFrame exit");
    }

    public static void printData() {
        DvUtils.writetoTrace(" printData entry");
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(selfRef);
        if (!printerJob.printDialog()) {
            DvUtils.writetoTrace(" printDialog failure");
        } else {
            try {
                printerJob.print();
                JOptionPane.showMessageDialog(selfRef, "Printing completed successfully", "Dumpviewer", 1);
            }
            catch (PrinterException printerException) {
                DvUtils.writetoTrace(" PrinterException caught " + printerException.toString());
                JOptionPane.showMessageDialog(selfRef, "Printing failed " + printerException.toString(), "Dumpviewer", 1);
            }
        }
        DvUtils.writetoTrace(" printData exit");
    }

    public static void initHelp(String string) {
        DvUtils.writetoTrace(" initHelp entry");
        if (!bHelpInitialised) {
            try {
                ClassLoader classLoader = Dumpviewer.class.getClassLoader();
                if (null == classLoader) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                URL uRL = null;
                try {
                    Class<?> clazz = classLoader.loadClass("javax.help.HelpSet");
                    Method method = clazz.getMethod("findHelpSet", ClassLoader.class, String.class);
                    Constructor<?> constructor = clazz.getConstructor(ClassLoader.class, URL.class);
                    uRL = (URL)method.invoke(clazz, classLoader, helpsetName);
                    Dumpviewer.selfRef.mainHS = constructor.newInstance(classLoader, uRL);
                    Method method2 = clazz.getMethod("createHelpBroker", null);
                    Dumpviewer.selfRef.mainHB = method2.invoke(Dumpviewer.selfRef.mainHS, null);
                    Class<?> clazz2 = classLoader.loadClass("javax.help.HelpBroker");
                    Class<?> clazz3 = classLoader.loadClass("javax.help.CSH$DisplayHelpFromSource");
                    constructor = null;
                    constructor = clazz3.getConstructor(clazz2);
                    help_menu.addActionListener((ActionListener)constructor.newInstance(Dumpviewer.selfRef.mainHB));
                    bHelpInitialised = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    DvUtils.writetoTrace("Failure initialising help: " + classNotFoundException.toString());
                }
                catch (Exception exception) {
                    DvUtils.writetoTrace("Failure initialising help: " + exception.toString());
                }
            }
            catch (Exception exception) {
                DvUtils.writetoTrace("Help Set com/ibm/jvm/dump/format/DvHelp.hs not found? " + exception.toString());
            }
        }
        if (!bHelpInitialised) {
            JOptionPane.showMessageDialog(selfRef, new String[]{"Help initialization failed", "Is jhall.jar from JavaHelp on bootclasspath/classpath? ", "######################################################", "Help will be unavailable for this session"}, "Dumpviewer", 1);
            DvUtils.writetoTrace("Help initialization failed (jhall.jar on classpath?) ");
        }
        DvUtils.writetoTrace(" initHelp exit");
    }

    public static void displayAbout(String string) {
        DvUtils.writetoTrace(" displayAbout entry");
        JOptionPane.showMessageDialog(null, "(scaffold) @(#)src/classes/sov/com/ibm/jvm/dump/format/Dumpviewer.java, ras, hs142, 20040917 1.35", "Dumpviewer", 1);
        DvUtils.writetoTrace(" displayAbout exit");
    }

    public static void showMessage(String string, boolean bl) {
        if (null != selfRef) {
            if (bl) {
                // empty if block
            }
            try {
                String string2;
                if (null == msg_text) {
                    msg_text = new JTextArea();
                }
                if ((string2 = msg_text.getText()).length() > 10000) {
                    string2 = string2.substring(5000);
                }
                string2 = string2 + string;
                try {
                    msg_text.setText(string2);
                    message_frame.setIcon(false);
                }
                catch (NullPointerException nullPointerException) {
                    DvUtils.writetoTrace(" NullPointerException trapped and ignored in showMessage !!!");
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public static void enableMenus() {
        for (int i = 0; i < fullMenu.length; ++i) {
            fullMenu[i].setEnabled(true);
        }
    }

    public static DvMenuItem findDvMenuItem(String string) {
        DvMenuItem dvMenuItem = null;
        for (int i = 0; i < fullMenuItems.length; ++i) {
            if (!Dumpviewer.fullMenuItems[i].itemName.equals(string)) continue;
            dvMenuItem = fullMenuItems[i];
            i = fullMenuItems.length;
        }
        return dvMenuItem;
    }

    public static void setStatusLine(String string) {
        status.setText(string);
    }

    public static JInternalFrame getInternalFrame(String string, int n, int n2) {
        return theIFM.createNewFrame(string, n, n2);
    }

    public static JInternalFrame getInternalFrame(String string, int n, int n2, String string2) {
        return theIFM.createNewFrame(string, n, n2, string2);
    }

    public static DvMouseListener addMouseListener(JInternalFrame jInternalFrame, Object object) {
        DvUtils.writetoTrace("Dumpviewer:addMouseListener entry");
        DvMouseListener dvMouseListener = null;
        if (object instanceof Component) {
            DvifmFrame dvifmFrame = Dvifm.findDvifmFrame(jInternalFrame);
            dvMouseListener = dvifmFrame.mouseListener;
            if (null != dvMouseListener) {
                ((Component)object).addMouseListener(dvMouseListener);
            } else {
                DvUtils.writetoTrace("... mouse listener not found (null)");
            }
        }
        DvUtils.writetoTrace("Dumpviewer:addMouseListener exit");
        return dvMouseListener;
    }

    public static boolean heapsTraversedQuery(boolean bl) {
        boolean bl2 = false;
        int n = JOptionPane.showConfirmDialog(selfRef, heapTraverseQuestion, "Dumpviewer", 0);
        if (n == 0) {
            if (bl) {
                SwingWorker swingWorker = new SwingWorker(){
                    Vector response = new Vector();
                    JTextArea jText = new JTextArea("", 8, 25);

                    public Object construct() {
                        Object var1_1 = null;
                        DvObjectsCommands.that.cpr = new CommandPluginResponse(this.response);
                        JInternalFrame jInternalFrame = theIFM.createNewFrame("Heap Traversal", theIFM.getDefaultProperties(), 0);
                        Dumpviewer.addIFrameToDesktop(jInternalFrame, 430, 450, 5, selfRef.getHeight() - 530);
                        this.jText.setEditable(false);
                        theIFM.addContentToFrame(jInternalFrame, this.jText);
                        DvObjectsCommandsGui.displayObjectSummary(objectStats, this.jText);
                        return var1_1;
                    }

                    public void finished() {
                        String string = DvUtils.convertResponse(objectStats, false);
                        this.jText.append(string);
                    }
                };
                swingWorker.start();
            }
            bl2 = true;
        }
        return bl2;
    }

    public static void heapTraversalOngoing() {
        JOptionPane.showMessageDialog(selfRef, "Unable to execute this command until heap traversal finishes", "Dumpviewer", 1);
    }

    public static void genericInfoMessage(String string) {
        JOptionPane.showMessageDialog(selfRef, string, "Dumpviewer", 1);
    }

    public static void doDefaultDoubleClick(String string) {
        Vector vector = new Vector();
        Dumpviewer.savedDvbc.verbModifier = string;
        savedDvbc.whatIs(vector);
        String string2 = DvUtils.convertResponse(vector, false);
        try {
            Object[] objectArray = new Object[]{"Memory @ 0x" + string, "Format 0x" + string, "Display object"};
            Object object = JOptionPane.showInputDialog(null, string2 + "\n\nChoose one", "Input", 1, null, objectArray, objectArray[0]);
            long l = Long.parseLong(string, 16);
            if (((String)object).startsWith("F")) {
                JInternalFrame jInternalFrame = theIFM.createNewFrame("Format As input", theIFM.getDefaultProperties(), 6);
                Dumpviewer.addIFrameToDesktop(jInternalFrame, 270, 320, 350, 200);
                DvFormatAs dvFormatAs = new DvFormatAs(jInternalFrame, dvConsole, string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static void doDefaultDoubleClick(MouseEvent mouseEvent) {
        String string;
        int n;
        Object object = mouseEvent.getSource();
        if (object instanceof String) {
            // empty if block
        }
        if (object instanceof JTree) {
            // empty if block
        }
        if (object instanceof JTable) {
            // empty if block
        }
        if (object instanceof JTextArea && -1 != (n = (string = ((JTextArea)object).getSelectedText()).toUpperCase().indexOf("0X"))) {
            String string2 = string.substring(n + 2);
            Dumpviewer.doDefaultDoubleClick(string2);
        }
    }

    public static int chooseAValue(String[] stringArray, String string) {
        int n = -1;
        Object object = JOptionPane.showInputDialog(null, string, "Input", 1, null, stringArray, stringArray[0]);
        if (null != object) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!((String)object).equals(stringArray[i])) continue;
                return i;
            }
        }
        return n;
    }

    public static void refreshMenuBar() {
        selfRef.setupMenuBar(desktop);
        if (null != DvConsole.theDump) {
            Dumpviewer.enableMenus();
        }
    }

    static {
        heapsTraversed = false;
        waitingOnConsoleCommand = false;
        savedConsoleOutput = new Vector();
        bWindowManagerIsGo = false;
        wm_frame = null;
        status_frame = null;
        message_frame = null;
        msg_text = null;
        consoleInitOutput = new Vector();
        is32BitDump = false;
        is64BitDump = false;
        isBigEndDump = false;
        isLittleEndDump = false;
        currentAS = 0;
        bHelpInitialised = false;
        file_chosen = false;
        left_menus = new DvMenu[]{new DvMenu("File", 70, true), new DvMenu("Edit", 69, true), new DvMenu("System", 83, false), new DvMenu("Windows", 87, true)};
        right_menus = new DvMenu[]{new DvMenu("Help", 72, true)};
        thisName = "com.ibm.jvm.dump.format.Dumpviewer";
        left_menuItems = new DvMenuItem[]{new DvMenuItem("File", "System.err Trace", -1, new CheckBoxListener(), true, null, thisName, null, null, null, null, false, "Tick this to start tracing"), new DvMenuItem("File", "Print Current Frame", 80, null, false, "doPrintFrame", thisName, null, null, null, null, false, "Starts print dialog for currently active frame"), new DvMenuItem("File", "Quit", 81, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                exitListener.doTerminationCode();
            }
        }, false, null, thisName, null, null, null, null, false, "Bye Bye Dumpviewer..."), new DvMenuItem("Windows", "Window Manager", -1, new CheckBoxListener(), true, null, thisName), new DvMenuItem("Windows", "Iconify All", -1, null, false, "actionAllWindows", thisName, null, null, null, null, false, "Helps unclutter your screen"), new DvMenuItem("Windows", "DeIconify All", -1, null, false, "actionAllWindows", thisName, null, null, null, null, false, "All iconified windows will reapear"), new DvMenuItem("Windows", "Close All", -1, null, false, "actionAllWindows", thisName, null, null, null, null, false, "Close all closeable windows")};
        right_menuItems = new DvMenuItem[]{new DvMenuItem("Help", "Help for Dumpviewer", -1, null, false, "initHelp", thisName, null, null, null, null, false, "This depends on JavaHelp being available!"), new DvMenuItem("Help", "About...", -1, null, false, "displayAbout", thisName, null, null, null, null, false, "What build level am I?")};
    }

    static class FormatMouseListener
    implements MouseListener {
        private JInternalFrame whatIframe;
        private JTree whatJTree;

        FormatMouseListener() {
        }

        public void setOwner(JInternalFrame jInternalFrame) {
            this.whatIframe = jInternalFrame;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            boolean bl = false;
            int n = mouseEvent.getClickCount();
            DvUtils.writetoTrace("Mouse click in Format Mouse Listener - count " + n);
            DvUtils.writetoTrace(" Window title is - " + this.whatIframe.getTitle());
            if (this.whatIframe.getTitle().equals("Class Summary")) {
                bl = true;
            }
            if ((mouseEvent.getModifiers() & 4) == 4) {
                DvUtils.writetoTrace(" .... its the right mouse button");
                if (n > 1) {
                    DvUtils.writetoTrace(" .... and a double click");
                    int n2 = this.whatJTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (n2 != -1) {
                        this.whatJTree.setSelectionRow(n2);
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.whatJTree.getLastSelectedPathComponent();
                        Object object = defaultMutableTreeNode.getUserObject();
                        String string = object.toString();
                        if (!bl) {
                            int n3 = string.toUpperCase().indexOf("0X");
                            if (-1 != n3) {
                                String string2 = string.substring(n3 + 2);
                                Dumpviewer.doDefaultDoubleClick(string2);
                            }
                        } else {
                            DvUtils.writetoTrace("Will launch new window for " + string);
                            JInternalFrame jInternalFrame = theIFM.createNewFrame(string + " details", theIFM.getDefaultProperties(), 6);
                            Dumpviewer.addIFrameToDesktop(jInternalFrame, 400, 420, 250, 150);
                            DvUtils.setTheIFM(theIFM);
                            DvClassDetailsDisplay dvClassDetailsDisplay = new DvClassDetailsDisplay(jInternalFrame, dvConsole, string, null);
                        }
                    }
                } else {
                    DvUtils.writetoTrace(" .... just a single click");
                }
            } else {
                DvUtils.writetoTrace(" .... its the left mouse button");
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    static class WMMouseListener
    implements MouseListener {
        private JInternalFrame whatIframe;

        WMMouseListener() {
        }

        public void setOwner(JInternalFrame jInternalFrame) {
            this.whatIframe = jInternalFrame;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getClickCount();
            DvUtils.writetoTrace("Mouse click in the Window Manager - count " + n);
            if (n > 1) {
                try {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)theIFM.findTree(this.whatIframe).getLastSelectedPathComponent();
                    if (defaultMutableTreeNode != null) {
                        Object object = defaultMutableTreeNode.getUserObject();
                        DvifmFrame dvifmFrame = Dvifm.findDvifmFrame((String)object);
                        theIFM.setIFrameSelected(dvifmFrame.iframe);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    private static class GenericMMBActionListener
    implements ActionListener {
        private GenericMMBActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Method method = null;
            if (actionEvent.getSource() instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                String string = jMenuItem.getActionCommand();
                DvUtils.writetoTrace("Menu bar action detected: " + string);
                if (string.startsWith("Set FormatFile")) {
                    string = "Set FormatFile";
                }
                if (string.startsWith("Set WorkDir")) {
                    string = "Set WorkDir";
                }
                boolean bl = false;
                String string2 = null;
                String string3 = null;
                for (int i = 0; i < fullMenuItems.length; ++i) {
                    if (!fullMenuItems[i].itemName.equals(string)) continue;
                    string2 = fullMenuItems[i].methodName;
                    string3 = fullMenuItems[i].className;
                    if (fullMenuItems[i].bOnlyAfterHeapTraversal) {
                        if (!DvObjectsCommands.heapsAlreadyTraversed()) {
                            if (!DvConsole.bHeapTraversalInprogress) {
                                Dumpviewer.heapsTraversedQuery(true);
                            } else {
                                Dumpviewer.heapTraversalOngoing();
                            }
                        } else {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                    i = fullMenuItems.length;
                }
                if (null != string2 && null != string3 && bl) {
                    DvUtils.writetoTrace(" Class/Method to be invoked = " + string3 + ":" + string2 + "(\"" + string + "\")");
                    try {
                        DvUtils.writetoTrace("  Trying to drive: " + string3 + "(" + string2 + ")");
                        Class<?> clazz = Class.forName(string3);
                        method = clazz.getMethod(string2, class$java$lang$String == null ? (class$java$lang$String = Dumpviewer.class$("java.lang.String")) : class$java$lang$String);
                        Object object = method.invoke(null, string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        DvUtils.writetoTrace(" ... ClassNotFoundException for " + string3);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        DvUtils.writetoTrace(" ... NoSuchMethodException for " + string2);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        DvUtils.writetoTrace(" ... IllegalAccessException for " + string2);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        DvUtils.writetoTrace(" ... InvocationTargetException for " + string2);
                        invocationTargetException.getTargetException().printStackTrace();
                    }
                } else {
                    DvUtils.writetoTrace(" Class/Method to be invoked is invalid !!!!!!");
                }
            }
        }
    }

    class DvComponentListener
    implements ComponentListener {
        DvComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (null != status_frame) {
                status_frame.reshape(0, Dumpviewer.this.getHeight() - 80, Dumpviewer.this.getWidth() - 10, 30);
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }
    }

    static class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable;
            boolean bl = true;
            if (itemEvent.getStateChange() == 2) {
                bl = false;
            }
            if ((itemSelectable = itemEvent.getItemSelectable()) == wm) {
                if (!bl) {
                    wm.setSelected(true);
                } else if (!bWindowManagerIsGo) {
                    Dumpviewer.setupWMFrame();
                    bWindowManagerIsGo = true;
                }
            } else if (itemSelectable == systemErrTrace) {
                DvConsole.bSystemErrTrace = bl;
                DvUtils.setVerbose(DvConsole.bSystemErrTrace);
            }
        }
    }

    static class AsidTableModel
    extends AbstractTableModel {
        boolean valsgiven = false;
        long[] col1_vals;
        long[] col2_vals;
        long[] col3_vals;
        String[] columnNames = new String[]{"C1", "C2", "C3", "C4", "C5", "C6"};
        int nRows;
        int nColumns;

        public int getColumnCount() {
            return this.nColumns;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return this.nRows;
        }

        public Object getValueAt(int n, int n2) {
            if (!this.valsgiven) {
                return new Integer(0);
            }
            if (n2 == 0) {
                return new Long(this.col1_vals[n]);
            }
            if (n2 == 1) {
                return new Long(this.col2_vals[n]);
            }
            if (n2 == 2) {
                return new Long(this.col3_vals[n]);
            }
            return new Long(0L);
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        public AsidTableModel(int n, int n2, String[] stringArray) {
            this.nRows = n;
            this.nColumns = n2;
            try {
                this.columnNames[0] = stringArray[0];
                this.columnNames[1] = stringArray[1];
                this.columnNames[2] = stringArray[2];
                this.columnNames[3] = stringArray[3];
                this.columnNames[4] = stringArray[4];
                this.columnNames[5] = stringArray[5];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }

        public AsidTableModel(long[] lArray, long[] lArray2, long[] lArray3, int n, String[] stringArray) {
            this.valsgiven = true;
            this.nRows = n;
            this.nColumns = stringArray.length;
            this.col1_vals = lArray;
            this.col2_vals = lArray2;
            this.col3_vals = lArray3;
            try {
                this.columnNames[0] = stringArray[0];
                this.columnNames[1] = stringArray[1];
                this.columnNames[2] = stringArray[2];
                this.columnNames[3] = stringArray[3];
                this.columnNames[4] = stringArray[4];
                this.columnNames[5] = stringArray[5];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }
}

