/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.ReaderProxy;
import java.io.UnsupportedEncodingException;

public class CTypeObject {
    DvAddress targetAddr;
    ReaderProxy reader;
    long value;
    boolean valueRead;
    byte[] data;
    CType type;
    public static final int spacesPerTab = 2;

    public CType getType() {
        return this.type;
    }

    public long getAddr() {
        return this.targetAddr.getAddressAsLong();
    }

    public long getValue(int n) throws DvAddressException {
        this.value = this.readValue(this.targetAddr, n);
        return this.value;
    }

    public long getValue() throws DvAddressException {
        if (this.type.getSize() > 8) {
            throw new NumberFormatException();
        }
        if (this.valueRead) {
            return this.value;
        }
        this.value = this.readValue(this.targetAddr, this.type.getSize());
        this.valueRead = true;
        return this.value;
    }

    public String getString(String string, int n) throws DvAddressException, UnsupportedEncodingException {
        byte[] byArray = new byte[n];
        byArray = this.reader.readBytes(this.targetAddr, n);
        return new String(byArray, string);
    }

    private long readValue(DvAddress dvAddress, int n) throws DvAddressException {
        long l = n == 1 ? (long)this.reader.readByte(dvAddress) : (n == 2 ? (long)this.reader.readShort(dvAddress) : (n == 4 ? (long)this.reader.readInt(dvAddress) : (n == 8 ? this.reader.readLong(dvAddress) : 0L)));
        return l;
    }

    public CTypeObject(CType cType, DvAddress dvAddress, DvAddressSpace dvAddressSpace) {
        this(cType, dvAddress, new ReaderProxy(dvAddressSpace));
    }

    public CTypeObject(String string, DvAddress dvAddress, ReaderProxy readerProxy) {
        this(CType.find(string).getType(), dvAddress, readerProxy);
    }

    public CTypeObject(String string, DvAddress dvAddress, DvAddressSpace dvAddressSpace) {
        this(string, dvAddress, new ReaderProxy(dvAddressSpace));
    }

    public CTypeObject(CType cType, long l, DvAddressSpace dvAddressSpace) {
        this(cType, l, new ReaderProxy(dvAddressSpace));
    }

    public CTypeObject(CType cType, long l, ReaderProxy readerProxy) {
        this(cType, new DvAddress(l), readerProxy);
    }

    public CTypeObject(String string, long l, DvAddressSpace dvAddressSpace) {
        this(string, l, new ReaderProxy(dvAddressSpace));
    }

    public CTypeObject(String string, long l, ReaderProxy readerProxy) {
        this(string, new DvAddress(l), readerProxy);
    }

    public CTypeObject(CType cType, DvAddress dvAddress, ReaderProxy readerProxy) {
        this.type = cType;
        this.targetAddr = dvAddress;
        this.reader = readerProxy;
        this.valueRead = false;
    }

    public CTypeObject(CType cType, long l) {
        this.type = cType.getType();
        if (this.type.baseType != 1) {
            throw new NumberFormatException();
        }
        this.valueRead = true;
        this.value = l;
    }

    public CTypeObject cast(CType cType) {
        this.type = cType.getType();
        return this;
    }

    public CTypeObject getField(int n) {
        try {
            if (n < this.type.numFields) {
                CType cType = this.type.getFieldType(n).getType();
                DvAddress dvAddress = new DvAddress(this.targetAddr.getAddressAsLong());
                dvAddress.offsetBy(this.type.getFieldOffset(n));
                CTypeObject cTypeObject = new CTypeObject(cType, dvAddress, this.reader);
                return cTypeObject;
            }
        }
        catch (DvAddressException dvAddressException) {
            // empty catch block
        }
        return null;
    }

    private DvAddress getFieldAddr(String string) {
        try {
            DvAddress dvAddress = new DvAddress(this.targetAddr.getAddressAsLong());
            int n = this.type.getFieldOffset(string);
            if (n == -1) {
                return null;
            }
            dvAddress.offsetBy(n);
            return dvAddress;
        }
        catch (DvAddressException dvAddressException) {
            return null;
        }
    }

    public CTypeObject getField(String string) {
        CType cType = this.type.getType();
        if (cType.baseType != 2 && cType.baseType != 3) {
            return null;
        }
        int n = string.indexOf(46);
        int n2 = string.indexOf(45);
        if (n2 == 0) {
            return this.deReference().getField(string.substring(2, string.length()));
        }
        if (n == 0) {
            return this.getField(string.substring(1, string.length()));
        }
        if (n2 > 0 && (n <= 0 || n2 < n)) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 2);
            try {
                long l = this.reader.readPointer(this.getFieldAddr(string2));
                DvAddress dvAddress = new DvAddress(l);
                CTypeObject cTypeObject = new CTypeObject(cType.getFieldType(string2), dvAddress, this.reader).deReference();
                return cTypeObject.getField(string3);
            }
            catch (DvAddressException dvAddressException) {
                return null;
            }
        }
        if (n > 0) {
            String string4 = string.substring(0, n);
            String string5 = string.substring(n + 1);
            DvAddress dvAddress = this.getFieldAddr(string4);
            CTypeObject cTypeObject = new CTypeObject(cType.getFieldType(string4), dvAddress, this.reader);
            return cTypeObject.getField(string5);
        }
        DvAddress dvAddress = this.getFieldAddr(string);
        if (dvAddress == null) {
            return null;
        }
        return new CTypeObject(cType.getFieldType(string), dvAddress, this.reader);
    }

    public CTypeObject getElement(int n) throws DvAddressException {
        DvAddress dvAddress = new DvAddress(this.targetAddr.getAddressAsLong());
        dvAddress.offsetBy(this.type.arrayInfo.type.getSize() * n);
        return new CTypeObject(this.type.arrayInfo.type, dvAddress, this.reader);
    }

    public CTypeObject deReference() {
        if (this.type.derefType != null) {
            try {
                long l = this.reader.readPointer(this.targetAddr);
                if (l == 0L) {
                    return null;
                }
                DvAddress dvAddress = new DvAddress(l);
                return new CTypeObject(this.type.derefType, dvAddress, this.reader);
            }
            catch (DvAddressException dvAddressException) {
                return null;
            }
        }
        return null;
    }

    public CTypeObject deReference(CType cType) {
        if (this.type.derefType != null) {
            try {
                long l = this.reader.readPointer(this.targetAddr);
                if (l == 0L) {
                    return null;
                }
                DvAddress dvAddress = new DvAddress(l);
                return new CTypeObject(cType, dvAddress, this.reader);
            }
            catch (DvAddressException dvAddressException) {
                return null;
            }
        }
        return null;
    }

    public CTypeObject deReference(String string) {
        if (this.type.derefType != null) {
            try {
                long l = this.reader.readPointer(this.targetAddr);
                if (l == 0L) {
                    return null;
                }
                DvAddress dvAddress = new DvAddress(l);
                CType cType = CType.find(string);
                if (cType == null) {
                    return null;
                }
                return new CTypeObject(cType, dvAddress, this.reader);
            }
            catch (DvAddressException dvAddressException) {
                return null;
            }
        }
        return null;
    }

    public String toString() {
        try {
            return this.toString(0);
        }
        catch (Exception exception) {
            return "Cannot print object";
        }
    }

    private String addTabs(String string, int n) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 2; ++j) {
                string = string + " ";
            }
        }
        return string;
    }

    private String cstring(DvAddress dvAddress) throws DvAddressException {
        byte[] byArray;
        StringBuffer stringBuffer = new StringBuffer();
        long l = this.reader.readPointer(dvAddress);
        DvAddress dvAddress2 = new DvAddress(l);
        while ((byArray = this.reader.readBytes(dvAddress2, 1)) != null && byArray[0] != 0) {
            stringBuffer.append((char)byArray[0]);
            dvAddress2.offsetBy(1L);
        }
        return new String(stringBuffer);
    }

    private String addressString(DvAddress dvAddress) {
        if (this.reader.getSpace().pointerSize() == 4) {
            return Integer.toHexString((int)dvAddress.getAddressAsLong());
        }
        return Long.toHexString(dvAddress.getAddressAsLong());
    }

    private String toString(int n) throws DvAddressException {
        if (this.data == null) {
            this.data = this.reader.readBytes(this.targetAddr, this.type.getSize());
        }
        CType cType = this.type;
        String string = "";
        cType = cType.getType();
        string = this.addTabs(string, n);
        if (n == 0) {
            string = string + cType.getName();
        }
        string = string + " @ 0x" + this.addressString(this.targetAddr) + "\n";
        ++n;
        if (cType.baseType < 0) {
            string = this.addTabs(string, n);
            this.getValue();
            string = "value = " + this.value;
            return string;
        }
        if (cType.baseType != 6 && cType.baseType != 5 && cType.baseType != 7 && (cType.baseType == 2 || cType.baseType == 3)) {
            for (int i = 0; i < cType.numFields; ++i) {
                Object object;
                long l = 0L;
                CType cType2 = cType.getFieldType(i).getType();
                DvAddress dvAddress = this.getFieldAddr(cType.getFieldName(i));
                if (cType2.baseType == 2 || cType2.baseType == 3) {
                    object = new CTypeObject(cType.getFieldType(i), dvAddress, this.reader);
                    string = this.addTabs(string, n);
                    string = string + cType.getFieldName(i) + " : ";
                    string = string + super.toString(n);
                    continue;
                }
                if (cType2.baseType == 6) {
                    string = this.addTabs(string, n);
                    string = string + cType.getFieldName(i) + " @ ";
                    string = string + "0x" + this.addressString(dvAddress);
                    string = string + " (array)\n";
                    continue;
                }
                if (cType.getFieldSize(i) <= 8) {
                    object = cType.getFieldType(i).getType();
                    string = this.addTabs(string, n);
                    string = string + cType.getFieldName(i) + " = ";
                    try {
                        if (((CType)object).baseType == 5 && cType2.derefType.name != null && ((CType)object).derefType.name.equals("char")) {
                            string = string + this.cstring(dvAddress);
                        } else {
                            int n2 = cType.getFieldOffset(i);
                            l = this.readValue(dvAddress, cType.getFieldSize(i));
                            string = 8 == cType.getFieldSize(i) ? string + "0x" + Long.toHexString(l) : string + "0x" + this.addressString(new DvAddress(l));
                        }
                    }
                    catch (Exception exception) {
                        string = string + "Invalid address " + this.addressString(dvAddress);
                    }
                    string = string + "\n";
                    continue;
                }
                System.out.println("not printing " + cType.getFieldName(i) + " type " + cType2.baseType + " index " + cType.getFieldType((int)i).typeNum);
            }
        }
        return string;
    }

    public int hashCode() {
        return this.targetAddr.hashCode();
    }

    public boolean equals(Object object) {
        CTypeObject cTypeObject = (CTypeObject)object;
        if (this.targetAddr.equals(cTypeObject.targetAddr)) {
            return this.type.equals(cTypeObject.type);
        }
        return false;
    }
}

