/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.Elf;
import com.ibm.jvm.dump.extract.ElfHeader;
import com.ibm.jvm.dump.sdff.DvFileReader;
import java.io.IOException;

public class ElfSegment {
    long length;
    long offset;
    long address;
    long type;
    long flags;
    long alignment;
    long physicalAddress;
    long fileSize;
    public static final int PT_NULL = 0;
    public static final int PT_LOAD = 1;
    public static final int PT_DYNAMIC = 2;
    public static final int PT_INTERP = 3;
    public static final int PT_NOTE = 4;
    public static final int PT_SHLIB = 5;
    public static final int PT_PHDR = 6;
    public static final int PT_TLS = 7;
    public static final int PT_LOOS = 0x60000000;
    public static final int PT_HIOS = 0x6FFFFFFF;
    public static final int PT_LOPROC = 0x70000000;
    public static final int PT_HIPROC = Integer.MAX_VALUE;

    public ElfSegment(Elf elf) throws IOException {
        DvFileReader dvFileReader = elf.getReader();
        ElfHeader elfHeader = (ElfHeader)elf.getHeader();
        if (dvFileReader.wordLength.size == 8) {
            this.type = dvFileReader.readWord();
            this.flags = dvFileReader.readWord();
            this.offset = dvFileReader.readAddress();
            this.address = dvFileReader.readAddress();
            this.physicalAddress = dvFileReader.readAddress();
            this.fileSize = dvFileReader.readLong();
            this.length = dvFileReader.readLong();
            this.alignment = dvFileReader.readLong();
        } else {
            this.type = dvFileReader.readWord();
            this.offset = dvFileReader.readAddress();
            this.address = dvFileReader.readAddress();
            this.physicalAddress = dvFileReader.readAddress();
            this.fileSize = dvFileReader.readWord();
            this.length = dvFileReader.readWord();
            this.flags = dvFileReader.readWord();
            this.alignment = dvFileReader.readWord();
        }
    }

    private ElfSegment(int n) {
        this.type = n;
    }

    public int getType() {
        return (int)this.type;
    }
}

