/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.AIXCore;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.DvFileReader;
import java.io.IOException;

class AIXUserx {
    private static final int S64BIT = 1;
    long pi_pid;
    long pi_ppid;
    long pi_sid;
    long pi_pgrp;
    long pi_uid;
    long pi_suid;
    long pi_ttyp;
    long pi_ttyd;
    long pi_ttympx;
    long pi_nice;
    long pi_state;
    long pi_flags;
    long pi_flags2;
    long pi_thcount;
    long pi_cpu;
    long pi_pri;
    long pi_adspace;
    long pi_majflt;
    long pi_minflt;
    long pi_repage;
    long pi_size;
    long pi_r1;
    long pi_utime;
    long pi_r2;
    long pi_stime;
    long cr_ref;
    long cr_ruid;
    long cr_uid;
    long cr_suid;
    long cr_luid;
    long cr_acctid;
    long cr_gid;
    long cr_rgid;
    long cr_sgid;
    long cr_ngrps;
    long cr_caps;
    long[] un_groups = new long[32];
    long[] cr_mpriv = new long[2];
    long[] cr_ipriv = new long[2];
    long[] cr_epriv = new long[2];
    long[] cr_bpriv = new long[2];
    long cr_pag;
    long pi_ru_utime_sec;
    long pi_ru_utime_usec;
    long pi_ru_stime_sec;
    long pi_ru_stime_usec;
    long pi_ru_maxrss;
    long pi_ru_ixrss;
    long pi_ru_idrss;
    long pi_ru_isrss;
    long pi_ru_minflt;
    long pi_ru_majflt;
    long pi_ru_nswap;
    long pi_ru_inblock;
    long pi_ru_oublock;
    long pi_ru_msgsnd;
    long pi_ru_msgrcv;
    long pi_ru_nsignals;
    long pi_ru_nvcsw;
    long pi_ru_nivcsw;
    long pi_cru_utime_sec;
    long pi_cru_utime_usec;
    long pi_cru_stime_sec;
    long pi_cru_stime_usec;
    long pi_cru_maxrss;
    long pi_cru_ixrss;
    long pi_cru_idrss;
    long pi_cru_isrss;
    long pi_cru_minflt;
    long pi_cru_majflt;
    long pi_cru_nswap;
    long pi_cru_inblock;
    long pi_cru_oublock;
    long pi_cru_msgsnd;
    long pi_cru_msgrcv;
    long pi_cru_nsignals;
    long pi_cru_nvcsw;
    long pi_cru_nivcsw;
    long pi_ioch;
    long pi_irss;
    long pi_start;
    long[] rlim_cur = new long[8];
    long[] rlim_max = new long[8];
    long pi_cmask;
    long pi_cdir;
    long pi_rdir;
    long pi_maxofile;
    byte[] pi_comm = new byte[33];
    byte[] pi_pad = new byte[7];
    long pi_drss;
    long pi_trss;
    long pi_dvm;
    long pi_prm;
    long pi_tsize;
    long pi_dsize;
    long pi_sdsize;
    long[] pi_signal = new long[64];
    long[] pi_sigflags = new long[64];
    long[] pi_signal64 = new long[256];
    long[] pi_sigflags64 = new long[256];
    long[] pi_ss64 = new long[4];
    long pi_sig_loset;
    long pi_sig_highset;
    long[] pi_resvd = new long[8];
    long pi_chk_utime;
    long pi_chk_stime;

    AIXUserx(AIXCore aIXCore) throws IOException {
        DvFileReader dvFileReader = aIXCore.getReader();
        if (dvFileReader.wordLength.size == 4) {
            this.populate32Bit(dvFileReader);
        } else {
            this.populate64Bit(dvFileReader);
        }
    }

    private void populate32Bit(DvFileReader dvFileReader) throws IOException {
        int n;
        this.pi_pid = dvFileReader.readWord();
        this.pi_ppid = dvFileReader.readWord();
        this.pi_sid = dvFileReader.readWord();
        this.pi_pgrp = dvFileReader.readWord();
        this.pi_uid = dvFileReader.readWord();
        this.pi_suid = dvFileReader.readWord();
        this.pi_ttyp = dvFileReader.readWord();
        this.pi_ttyd = dvFileReader.readWord();
        this.pi_ttympx = dvFileReader.readWord();
        this.pi_nice = dvFileReader.readWord();
        this.pi_state = dvFileReader.readWord();
        this.pi_flags = dvFileReader.readWord();
        this.pi_flags2 = dvFileReader.readWord();
        this.pi_thcount = dvFileReader.readWord();
        this.pi_cpu = dvFileReader.readWord();
        this.pi_pri = dvFileReader.readWord();
        this.pi_adspace = dvFileReader.readWord();
        dvFileReader.readBytes(4);
        this.pi_majflt = dvFileReader.readLong();
        this.pi_minflt = dvFileReader.readLong();
        this.pi_repage = dvFileReader.readLong();
        this.pi_size = dvFileReader.readLong();
        this.pi_r1 = dvFileReader.readWord();
        this.pi_utime = dvFileReader.readWord();
        this.pi_r2 = dvFileReader.readWord();
        this.pi_stime = dvFileReader.readWord();
        this.cr_ref = dvFileReader.readWord();
        this.cr_ruid = dvFileReader.readWord();
        this.cr_uid = dvFileReader.readWord();
        this.cr_suid = dvFileReader.readWord();
        this.cr_luid = dvFileReader.readWord();
        this.cr_acctid = dvFileReader.readWord();
        this.cr_gid = dvFileReader.readWord();
        this.cr_rgid = dvFileReader.readWord();
        this.cr_sgid = dvFileReader.readWord();
        this.cr_ngrps = dvFileReader.readHalf();
        this.cr_caps = dvFileReader.readHalf();
        for (n = 0; n < this.un_groups.length; ++n) {
            this.un_groups[n] = dvFileReader.readWord();
        }
        for (n = 0; n < this.cr_mpriv.length; ++n) {
            this.cr_mpriv[n] = dvFileReader.readWord();
        }
        for (n = 0; n < this.cr_ipriv.length; ++n) {
            this.cr_ipriv[n] = dvFileReader.readWord();
        }
        for (n = 0; n < this.cr_epriv.length; ++n) {
            this.cr_epriv[n] = dvFileReader.readWord();
        }
        for (n = 0; n < this.cr_bpriv.length; ++n) {
            this.cr_bpriv[n] = dvFileReader.readWord();
        }
        this.cr_pag = dvFileReader.readWord();
        dvFileReader.readBytes(4);
        this.pi_ru_utime_sec = dvFileReader.readWord();
        this.pi_ru_utime_usec = dvFileReader.readWord();
        this.pi_ru_stime_sec = dvFileReader.readWord();
        this.pi_ru_stime_usec = dvFileReader.readWord();
        this.pi_ru_maxrss = dvFileReader.readLong();
        this.pi_ru_ixrss = dvFileReader.readLong();
        this.pi_ru_isrss = dvFileReader.readLong();
        this.pi_ru_minflt = dvFileReader.readLong();
        this.pi_ru_majflt = dvFileReader.readLong();
        this.pi_ru_nswap = dvFileReader.readLong();
        this.pi_ru_inblock = dvFileReader.readLong();
        this.pi_ru_oublock = dvFileReader.readLong();
        this.pi_ru_msgsnd = dvFileReader.readLong();
        this.pi_ru_msgrcv = dvFileReader.readLong();
        this.pi_ru_nsignals = dvFileReader.readLong();
        this.pi_ru_nvcsw = dvFileReader.readLong();
        this.pi_ru_nivcsw = dvFileReader.readLong();
        this.pi_cru_utime_sec = dvFileReader.readWord();
        this.pi_cru_utime_usec = dvFileReader.readWord();
        this.pi_cru_stime_sec = dvFileReader.readWord();
        this.pi_cru_stime_usec = dvFileReader.readWord();
        this.pi_cru_maxrss = dvFileReader.readLong();
        this.pi_cru_ixrss = dvFileReader.readLong();
        this.pi_cru_idrss = dvFileReader.readLong();
        this.pi_cru_isrss = dvFileReader.readLong();
        this.pi_cru_minflt = dvFileReader.readLong();
        this.pi_cru_majflt = dvFileReader.readLong();
        this.pi_cru_nswap = dvFileReader.readLong();
        this.pi_cru_inblock = dvFileReader.readLong();
        this.pi_cru_oublock = dvFileReader.readLong();
        this.pi_cru_msgsnd = dvFileReader.readLong();
        this.pi_cru_msgrcv = dvFileReader.readLong();
        this.pi_cru_nsignals = dvFileReader.readLong();
        this.pi_cru_nvcsw = dvFileReader.readLong();
        this.pi_cru_nivcsw = dvFileReader.readLong();
        this.pi_ioch = dvFileReader.readLong();
        this.pi_irss = dvFileReader.readLong();
        this.pi_start = dvFileReader.readLong();
        for (n = 0; n < 8; ++n) {
            this.rlim_cur[n] = dvFileReader.readLong();
            this.rlim_max[n] = dvFileReader.readLong();
        }
        this.pi_cmask = dvFileReader.readHalf();
        dvFileReader.readBytes(2);
        this.pi_cdir = dvFileReader.readWord();
        this.pi_rdir = dvFileReader.readWord();
        this.pi_maxofile = dvFileReader.readWord();
        dvFileReader.read(this.pi_comm);
        dvFileReader.read(this.pi_pad);
        this.pi_drss = dvFileReader.readLong();
        this.pi_trss = dvFileReader.readLong();
        this.pi_dvm = dvFileReader.readLong();
        this.pi_prm = dvFileReader.readLong();
        this.pi_tsize = dvFileReader.readLong();
        this.pi_dsize = dvFileReader.readLong();
        this.pi_sdsize = dvFileReader.readLong();
        for (n = 0; n < 64; ++n) {
            this.pi_signal[n] = dvFileReader.readLong();
        }
        for (n = 0; n < 64; ++n) {
            this.pi_sigflags[n] = dvFileReader.readByte();
        }
        this.pi_sig_loset = dvFileReader.readWord();
        this.pi_sig_highset = dvFileReader.readWord();
        dvFileReader.read(new byte[72]);
        for (n = 0; n < this.pi_resvd.length; ++n) {
            this.pi_resvd[n] = dvFileReader.readWord();
        }
    }

    void populate64Bit(DvFileReader dvFileReader) throws IOException {
        int n;
        this.pi_pid = dvFileReader.readWord();
        this.pi_ppid = dvFileReader.readWord();
        this.pi_sid = dvFileReader.readWord();
        this.pi_pgrp = dvFileReader.readWord();
        this.pi_uid = dvFileReader.readWord();
        this.pi_suid = dvFileReader.readWord();
        this.pi_ttyp = dvFileReader.readWord();
        dvFileReader.readWord();
        this.pi_ttyd = dvFileReader.readLong();
        this.pi_ttympx = dvFileReader.readLong();
        this.pi_nice = dvFileReader.readWord();
        this.pi_state = dvFileReader.readWord();
        this.pi_flags = dvFileReader.readWord();
        this.pi_flags2 = dvFileReader.readWord();
        this.pi_thcount = dvFileReader.readWord();
        this.pi_cpu = dvFileReader.readWord();
        this.pi_pri = dvFileReader.readWord();
        this.pi_maxofile = dvFileReader.readWord();
        this.pi_cdir = dvFileReader.readLong();
        this.pi_rdir = dvFileReader.readLong();
        this.pi_cmask = dvFileReader.readHalf();
        dvFileReader.readHalf();
        dvFileReader.read(this.pi_comm);
        this.pi_adspace = dvFileReader.readLong();
        this.pi_majflt = dvFileReader.readLong();
        this.pi_minflt = dvFileReader.readLong();
        this.pi_repage = dvFileReader.readLong();
        this.pi_size = dvFileReader.readLong();
        this.pi_utime = dvFileReader.readLong();
        this.pi_stime = dvFileReader.readLong();
        dvFileReader.read(new byte[1024]);
        this.pi_ru_utime_sec = dvFileReader.readLong();
        this.pi_ru_utime_usec = dvFileReader.readWord();
        dvFileReader.readWord();
        this.pi_ru_stime_sec = dvFileReader.readLong();
        this.pi_ru_stime_usec = dvFileReader.readWord();
        dvFileReader.readWord();
        this.pi_ru_maxrss = dvFileReader.readLong();
        this.pi_ru_ixrss = dvFileReader.readLong();
        this.pi_ru_idrss = dvFileReader.readLong();
        this.pi_ru_isrss = dvFileReader.readLong();
        this.pi_ru_minflt = dvFileReader.readLong();
        this.pi_ru_majflt = dvFileReader.readLong();
        this.pi_ru_nswap = dvFileReader.readLong();
        this.pi_ru_inblock = dvFileReader.readLong();
        this.pi_ru_oublock = dvFileReader.readLong();
        this.pi_ru_msgsnd = dvFileReader.readLong();
        this.pi_ru_msgrcv = dvFileReader.readLong();
        this.pi_ru_nsignals = dvFileReader.readLong();
        this.pi_ru_nvcsw = dvFileReader.readLong();
        this.pi_ru_nivcsw = dvFileReader.readLong();
        this.pi_cru_utime_sec = dvFileReader.readLong();
        this.pi_cru_utime_usec = dvFileReader.readWord();
        dvFileReader.readWord();
        this.pi_cru_stime_sec = dvFileReader.readLong();
        this.pi_cru_stime_usec = dvFileReader.readWord();
        dvFileReader.readWord();
        this.pi_cru_maxrss = dvFileReader.readLong();
        this.pi_cru_ixrss = dvFileReader.readLong();
        this.pi_cru_idrss = dvFileReader.readLong();
        this.pi_cru_isrss = dvFileReader.readLong();
        this.pi_cru_minflt = dvFileReader.readLong();
        this.pi_cru_majflt = dvFileReader.readLong();
        this.pi_cru_nswap = dvFileReader.readLong();
        this.pi_cru_inblock = dvFileReader.readLong();
        this.pi_cru_oublock = dvFileReader.readLong();
        this.pi_cru_msgsnd = dvFileReader.readLong();
        this.pi_cru_msgrcv = dvFileReader.readLong();
        this.pi_cru_nsignals = dvFileReader.readLong();
        this.pi_cru_nvcsw = dvFileReader.readLong();
        this.pi_cru_nivcsw = dvFileReader.readLong();
        this.pi_ioch = dvFileReader.readLong();
        this.pi_irss = dvFileReader.readLong();
        this.pi_start = dvFileReader.readLong();
        for (n = 0; n < 8; ++n) {
            this.rlim_cur[n] = dvFileReader.readLong();
            this.rlim_max[n] = dvFileReader.readLong();
        }
        this.pi_drss = dvFileReader.readLong();
        this.pi_trss = dvFileReader.readLong();
        this.pi_dvm = dvFileReader.readLong();
        this.pi_prm = dvFileReader.readLong();
        this.pi_tsize = dvFileReader.readLong();
        this.pi_dsize = dvFileReader.readLong();
        this.pi_sdsize = dvFileReader.readLong();
        for (n = 0; n < 256; ++n) {
            this.pi_signal64[n] = dvFileReader.readLong();
        }
        for (n = 0; n < 256; ++n) {
            this.pi_sigflags64[n] = dvFileReader.readWord();
        }
        for (n = 0; n < 4; ++n) {
            this.pi_ss64[n] = dvFileReader.readLong();
        }
        dvFileReader.read(new byte[72]);
        this.pi_chk_utime = dvFileReader.readWord();
        this.pi_chk_stime = dvFileReader.readWord();
        this.pi_resvd[4] = dvFileReader.readWord();
    }

    void dump() {
        int n;
        DvUtils.trace("pi_pid = 0x" + Long.toHexString(this.pi_pid), 2, false);
        DvUtils.trace("pi_ppid = 0x" + Long.toHexString(this.pi_ppid), 2, false);
        DvUtils.trace("pi_sid = 0x" + Long.toHexString(this.pi_sid), 2, false);
        DvUtils.trace("pi_pgrp = 0x" + Long.toHexString(this.pi_pgrp), 2, false);
        DvUtils.trace("pi_uid = 0x" + Long.toHexString(this.pi_uid), 2, false);
        DvUtils.trace("pi_suid = 0x" + Long.toHexString(this.pi_suid), 2, false);
        DvUtils.trace("pi_ttyp = 0x" + Long.toHexString(this.pi_ttyp), 2, false);
        DvUtils.trace("pi_ttyd = 0x" + Long.toHexString(this.pi_ttyd), 2, false);
        DvUtils.trace("pi_ttympx = 0x" + Long.toHexString(this.pi_ttympx), 2, false);
        DvUtils.trace("pi_nice = 0x" + Long.toHexString(this.pi_nice), 2, false);
        DvUtils.trace("pi_state = 0x" + Long.toHexString(this.pi_state), 2, false);
        DvUtils.trace("pi_flags = 0x" + Long.toHexString(this.pi_flags), 2, false);
        DvUtils.trace("pi_flags2 = 0x" + Long.toHexString(this.pi_flags2), 2, false);
        if ((this.pi_flags2 & 1L) != 0L) {
            DvUtils.trace("64-bit process", 2, false);
        } else {
            DvUtils.trace("32-bit process", 2, false);
        }
        DvUtils.trace("pi_thcount = 0x" + Long.toHexString(this.pi_thcount), 2, false);
        DvUtils.trace("pi_cpu = 0x" + Long.toHexString(this.pi_cpu), 2, false);
        DvUtils.trace("pi_pri = 0x" + Long.toHexString(this.pi_pri), 2, false);
        DvUtils.trace("pi_adspace = 0x" + Long.toHexString(this.pi_adspace), 2, false);
        DvUtils.trace("pi_majflt = 0x" + Long.toHexString(this.pi_majflt), 2, false);
        DvUtils.trace("pi_minflt = 0x" + Long.toHexString(this.pi_minflt), 2, false);
        DvUtils.trace("pi_repage = 0x" + Long.toHexString(this.pi_repage), 2, false);
        DvUtils.trace("pi_size = 0x" + Long.toHexString(this.pi_size), 2, false);
        DvUtils.trace("pi_r1 = 0x" + Long.toHexString(this.pi_r1), 2, false);
        DvUtils.trace("pi_utime = 0x" + Long.toHexString(this.pi_utime), 2, false);
        DvUtils.trace("pi_r2 = 0x" + Long.toHexString(this.pi_r2), 2, false);
        DvUtils.trace("pi_stime = 0x" + Long.toHexString(this.pi_stime), 2, false);
        DvUtils.trace("cr_ref = 0x" + Long.toHexString(this.cr_ref), 2, false);
        DvUtils.trace("cr_ruid = 0x" + Long.toHexString(this.cr_ruid), 2, false);
        DvUtils.trace("cr_uid = 0x" + Long.toHexString(this.cr_uid), 2, false);
        DvUtils.trace("cr_suid = 0x" + Long.toHexString(this.cr_suid), 2, false);
        DvUtils.trace("cr_luid = 0x" + Long.toHexString(this.cr_luid), 2, false);
        DvUtils.trace("cr_acctid = 0x" + Long.toHexString(this.cr_acctid), 2, false);
        DvUtils.trace("cr_gid = 0x" + Long.toHexString(this.cr_gid), 2, false);
        DvUtils.trace("cr_rgid = 0x" + Long.toHexString(this.cr_rgid), 2, false);
        DvUtils.trace("cr_sgid = 0x" + Long.toHexString(this.cr_sgid), 2, false);
        DvUtils.trace("cr_ngrps = 0x" + Long.toHexString(this.cr_ngrps), 2, false);
        DvUtils.trace("cr_caps = 0x" + Long.toHexString(this.cr_caps), 2, false);
        for (n = 0; n < this.un_groups.length; ++n) {
            DvUtils.trace("un_groups[" + n + "] = 0x" + Long.toHexString(this.un_groups[n]), 2, false);
        }
        for (n = 0; n < this.cr_mpriv.length; ++n) {
            DvUtils.trace("cr_mpriv[" + n + "] = 0x" + Long.toHexString(this.cr_mpriv[n]), 2, false);
        }
        for (n = 0; n < this.cr_ipriv.length; ++n) {
            DvUtils.trace("cr_ipriv[" + n + "]= 0x" + Long.toHexString(this.cr_ipriv[n]), 2, false);
        }
        for (n = 0; n < this.cr_epriv.length; ++n) {
            DvUtils.trace("cr_epriv[" + n + "]= 0x" + Long.toHexString(this.cr_epriv[n]), 2, false);
        }
        for (n = 0; n < this.cr_bpriv.length; ++n) {
            DvUtils.trace("cr_bpriv[" + n + "]= 0x" + Long.toHexString(this.cr_bpriv[n]), 2, false);
        }
        DvUtils.trace("cr_pag = 0x" + Long.toHexString(this.cr_pag), 2, false);
        DvUtils.trace("pi_ru_utime_sec = 0x" + Long.toHexString(this.pi_ru_utime_sec), 2, false);
        DvUtils.trace("pi_ru_utime_usec = 0x" + Long.toHexString(this.pi_ru_utime_usec), 2, false);
        DvUtils.trace("pi_ru_stime_sec = 0x" + Long.toHexString(this.pi_ru_stime_sec), 2, false);
        DvUtils.trace("pi_ru_stime_usec = 0x" + Long.toHexString(this.pi_ru_stime_usec), 2, false);
        DvUtils.trace("pi_ru_maxrss = 0x" + Long.toHexString(this.pi_ru_maxrss), 2, false);
        DvUtils.trace("pi_ru_ixrss = 0x" + Long.toHexString(this.pi_ru_ixrss), 2, false);
        DvUtils.trace("pi_ru_idrss = 0x" + Long.toHexString(this.pi_ru_idrss), 2, false);
        DvUtils.trace("pi_ru_isrss = 0x" + Long.toHexString(this.pi_ru_isrss), 2, false);
        DvUtils.trace("pi_ru_minflt = 0x" + Long.toHexString(this.pi_ru_minflt), 2, false);
        DvUtils.trace("pi_ru_majflt = 0x" + Long.toHexString(this.pi_ru_majflt), 2, false);
        DvUtils.trace("pi_ru_nswap = 0x" + Long.toHexString(this.pi_ru_nswap), 2, false);
        DvUtils.trace("pi_ru_inblock = 0x" + Long.toHexString(this.pi_ru_inblock), 2, false);
        DvUtils.trace("pi_ru_oublock = 0x" + Long.toHexString(this.pi_ru_oublock), 2, false);
        DvUtils.trace("pi_ru_msgsnd = 0x" + Long.toHexString(this.pi_ru_msgsnd), 2, false);
        DvUtils.trace("pi_ru_msgrcv = 0x" + Long.toHexString(this.pi_ru_msgrcv), 2, false);
        DvUtils.trace("pi_ru_nsignals = 0x" + Long.toHexString(this.pi_ru_nsignals), 2, false);
        DvUtils.trace("pi_ru_nvcsw = 0x" + Long.toHexString(this.pi_ru_nvcsw), 2, false);
        DvUtils.trace("pi_ru_nivcsw = 0x" + Long.toHexString(this.pi_ru_nivcsw), 2, false);
        DvUtils.trace("pi_cru_utime_sec = 0x" + Long.toHexString(this.pi_cru_utime_sec), 2, false);
        DvUtils.trace("pi_cru_utime_usec = 0x" + Long.toHexString(this.pi_cru_utime_usec), 2, false);
        DvUtils.trace("pi_cru_stime_sec = 0x" + Long.toHexString(this.pi_cru_stime_sec), 2, false);
        DvUtils.trace("pi_cru_stime_usec = 0x" + Long.toHexString(this.pi_cru_stime_usec), 2, false);
        DvUtils.trace("pi_cru_maxrss = 0x" + Long.toHexString(this.pi_cru_maxrss), 2, false);
        DvUtils.trace("pi_cru_ixrss = 0x" + Long.toHexString(this.pi_cru_ixrss), 2, false);
        DvUtils.trace("pi_cru_idrss = 0x" + Long.toHexString(this.pi_cru_idrss), 2, false);
        DvUtils.trace("pi_cru_isrss = 0x" + Long.toHexString(this.pi_cru_isrss), 2, false);
        DvUtils.trace("pi_cru_minflt = 0x" + Long.toHexString(this.pi_cru_minflt), 2, false);
        DvUtils.trace("pi_cru_majflt = 0x" + Long.toHexString(this.pi_cru_majflt), 2, false);
        DvUtils.trace("pi_cru_nswap = 0x" + Long.toHexString(this.pi_cru_nswap), 2, false);
        DvUtils.trace("pi_cru_inblock = 0x" + Long.toHexString(this.pi_cru_inblock), 2, false);
        DvUtils.trace("pi_cru_oublock = 0x" + Long.toHexString(this.pi_cru_oublock), 2, false);
        DvUtils.trace("pi_cru_msgsnd = 0x" + Long.toHexString(this.pi_cru_msgsnd), 2, false);
        DvUtils.trace("pi_cru_msgrcv = 0x" + Long.toHexString(this.pi_cru_msgrcv), 2, false);
        DvUtils.trace("pi_cru_nsignals = 0x" + Long.toHexString(this.pi_cru_nsignals), 2, false);
        DvUtils.trace("pi_cru_nvcsw = 0x" + Long.toHexString(this.pi_cru_nvcsw), 2, false);
        DvUtils.trace("pi_cru_nivcsw = 0x" + Long.toHexString(this.pi_cru_nivcsw), 2, false);
        DvUtils.trace("pi_ioch = 0x" + Long.toHexString(this.pi_ioch), 2, false);
        DvUtils.trace("pi_irss = 0x" + Long.toHexString(this.pi_irss), 2, false);
        DvUtils.trace("pi_start = 0x" + Long.toHexString(this.pi_start), 2, false);
        for (n = 0; n < 8; ++n) {
            DvUtils.trace("rlim_cur[" + n + "] = " + Long.toString(this.rlim_cur[n]) + " 0x" + Long.toHexString(this.rlim_cur[n]), 2, false);
            DvUtils.trace("rlim_max[" + n + "] = " + Long.toString(this.rlim_max[n]) + " 0x" + Long.toHexString(this.rlim_max[n]), 2, false);
        }
        DvUtils.trace("pi_cmask = 0" + Long.toOctalString(this.pi_cmask), 2, false);
        DvUtils.trace("pi_cdir = 0x" + Long.toHexString(this.pi_cdir), 2, false);
        DvUtils.trace("pi_rdir = 0x" + Long.toHexString(this.pi_rdir), 2, false);
        DvUtils.trace("pi_maxofile = 0x" + Long.toHexString(this.pi_maxofile), 2, false);
        DvUtils.trace("pi_comm = " + new String(this.pi_comm), 2, false);
        DvUtils.trace("pi_drss = 0x" + Long.toHexString(this.pi_drss), 2, false);
        DvUtils.trace("pi_trss = 0x" + Long.toHexString(this.pi_trss), 2, false);
        DvUtils.trace("pi_dvm = 0x" + Long.toHexString(this.pi_dvm), 2, false);
        DvUtils.trace("pi_prm = 0x" + Long.toHexString(this.pi_prm), 2, false);
        DvUtils.trace("pi_tsize = 0x" + Long.toHexString(this.pi_tsize), 2, false);
        DvUtils.trace("pi_dsize = 0x" + Long.toHexString(this.pi_dsize), 2, false);
        DvUtils.trace("pi_sdsize = 0x" + Long.toHexString(this.pi_sdsize), 2, false);
        for (n = 0; n < 64; ++n) {
            DvUtils.trace("pi_signal[" + n + "] = 0x" + Long.toHexString(this.pi_signal[n]), 2, false);
            DvUtils.trace("pi_sigflags[" + n + "] = 0x" + Long.toHexString(this.pi_sigflags[n]), 2, false);
        }
        DvUtils.trace("pi_sig_loset = 0x" + Long.toHexString(this.pi_sig_loset), 2, false);
        DvUtils.trace("pi_sig_highset = 0x" + Long.toHexString(this.pi_sig_highset), 2, false);
    }
}

