#!/usr/bin/perl -w

#  Purpose of the script is to call snaadmin status_lu62 and display
#  the LU 6.2 state of all local LUs on all servers in a domain
#

use strict;

 my ( $srv_index, $srvcnt, $luname, $aliasname, $sysname, $descript,  
      @servername, @data, @status );

#  Initialize for scalar declaration
$srvcnt = 0;
$luname = " ";

@status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node_all`;             # Get detailed Link Station information

foreach(@status) {
   chomp;
   if (/^query_node_all/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }
 
  #  Skip headers
   next if (/^------/);
   next if (/^list_option/);

   next if (/^\n/);

   @data = split(/=/,$_);   #Break parameter = value

   next if (@data == 0);        # on blank line, skip

   if ($data[0]=~m/^node_name/) {       # get link station name  
     $servername[$srvcnt]=$data[1];
     $servername[$srvcnt]=~s/ //g;
#     printf("   Server %1d  %8s \n", $srvcnt+1, $servername[$srvcnt]);
     $srvcnt++;
     next;                                
   }
   
}
# print "\n------------------------------------------------\n";
   
#
#  Process the Status LU62 information
#

#  Initialize for scalar declaration
$srv_index = 0;

while ($srv_index < $srvcnt) 
{

    @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $servername[$srv_index] status_lu62` or die "Node $servername[$srv_index] not recognized $!\n";

#   Print header line
  printf("\n      Server: %s\n", $servername[$srv_index]);

   foreach(@status) {
      chomp;
     if (/^query_local_lu/) {
       print " Cannot process node $servername[$srv_index]\n";
       exit -1;
     }

  #  Skip headers
     next if (/^list_option/);

     next if (/^\n/);

     printf ("%s\n",$_);   

     next;
     
  }
  $srv_index++;
  
}


