#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2018 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use strict;

my ($arg, $action, $stname,$rtname, $time, @result, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config Manage LU 6.2 Session Timeout Results: $time</b>";
print "<font face=\"Courier, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of LU 6.2 Session Timeout management!";
} else {
     $arg=param('linkslist');
     ($action,$rtname,$stname) = (split(/-/,$arg) )[0,1,2];
     if ($action=~m/^remove/) {
	if ($rtname eq "GLOBAL_TIMEOUT"){
        @result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin delete_lu62_timeout,resource_type=$rtname `;
	print "/opt/ibm/sna/bin/snaadmin delete_lu62_timeout,resource_type=$rtname";
        } else {
        @result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin delete_lu62_timeout,resource_type=$rtname,resource_name=$stname`;
        print "/opt/ibm/sna/bin/snaadmin delete_lu62_timeout,resource_type=$rtname,resource_name=$stname";
	}
	}else{
         print " Invalid action on LU 6.2 Session Timeout management!";
         exit 1;
     }       
}
print "<b>";
foreach(@result) {
   chomp;
   next if (/^------/);
   print "<br>$_"; 
}
print "</b>";



print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

