#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2018 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use strict;

my ($arg, $action,$caname,$cpname,$llname,$extra,$time, @result, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config Manage TN Redirector Results: $time</b>";
print "<font face=\"Courier, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of TN Redirector management!";
} else {
     $arg=param('linkslist');
     ($action,$cpname,$caname,$llname) = (split(/_/,$arg) )[0,1,2,3];
     
     if ($action=~m/^remove/) {

	if ($caname eq "<DEFAULT>"){
     	  
	    if ($llname eq ""){
        	@result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin delete_tn_redirect,default_record=yes, client_port=$cpname`;
		print "Debug: sudo -u snauser /opt/ibm/sna/bin/snaadmin delete_tn_redirect,default_record=yes,client_port=$cpname";
     	   } else{

		@result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin delete_tn_redirect,default_record=yes, client_port=$cpname,listen_local_address=$llname`;
        	print "Debug: sudo -u snauser /opt/ibm/sna/bin/snaadmin delete_tn_redirect,default_record=yes,client_port=$cpname;listen_local_address=$llname"; }	

	} else {

	   if ($llname eq ""){
		@result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin delete_tn_redirect,default_record=no,client_address=$caname,client_port=$cpname`;
        	print "Debug: sudo -u snauser /opt/ibm/sna/bin/snaadmin delete_tn_redirect,default_record=no,client_address=$caname,client_port=$cpname";   

           } else{
                @result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin delete_tn_redirect,default_record=no,client_address=$caname,client_port=$cpname,listen_local_address=$llname`;
                print "Debug: sudo -u snauser /opt/ibm/sna/bin/snaadmin delete_tn_redirect,default_record=no,client_address=$caname,client_port=$cpname;listen_local_address=$llname"; }
     }
} 
    else {
         print " Invalid action on TN Redirector management!";
         exit 1;
     }       
}
print "<b>";
foreach(@result) {
   chomp;
   next if (/^------/);
   print "<br>$_"; 
}
print "</b>";



print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

