#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2004 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:all);
use strict;

#
#  Write header of page for admin
#
sub print_top {

   my (@contents);

open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);
}


#
#  Write header of page for admin
#
sub print_bottom {

   my (@contents);

open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);
}


#
#  Begin of main section
#

my ($time, $linecount, $halfcount, $i, @linkname, @linktype, 
    @linkcpname, $line, $outputline, $saveline, @links);

print header;

# output top of template page
print_top();

$linecount=0;
$time=localtime;

$ENV{LD_LIBRARY_PATH}='/opt/ibm/sna/lib:/usr/lib';
$ENV{SNATBLG}='/opt/ibm/sna/samples/luatblg.dat';
#! Get CSLINKS output
@links=`../cscbin/cslinks.pl`;

print "<font face=\"Courier, Helvetica\">";
print "<form action= \"/cscbin/actlinksform.cgi\" method=\"post\">\n";
print "<br><b> Link Status: $time</b>";
print "<p>\n";
#
# display current link status and get link information
#
foreach $line (@links) {
   $saveline = $line;
#  On none active lines, print end of list in html format
   $line=~s/ /&nbsp;/g;
   print $line."<br>\n";
   if ($saveline=~m/ACTIVE/) {     # get active or Inactive links names
      $saveline=(substr($saveline, 2));    # remove the first 3 characters to help make fit
#  extract link name from first and cp name from third output
      ($linkname[$linecount], $linkcpname[$linecount]) = (split(/\s+/,$saveline) )[1,3]; 
      if ($saveline=~m/INACTIVE/) {    #  If the link is not active, set link type to start
         $linktype[$linecount] = "Start";
      } elsif ($saveline=~m/ACTIVE/) {     # get active links to stop
         $linktype[$linecount] = "Stop ";
      } 
      $linecount++;
   }
}
#
#   Process lines read for action to set up
#
if ($linecount == 0) {    # No links to start or stop
   print_bottom();
   exit 0;
} elsif ($linecount == 1) {    # Print only one line
   if ($linktype[$i]=~m/^Start/) {    #  If the link is not active
      $outputline = "<b>Start</b><input type=\"radio\" name=\"linkslist\" value=\"start_$linkname[$i]\"/>";
   } elsif ($linktype[$i]=~m/^Stop/) {     # list active links to stop
      $outputline = "<b>Stop </b><input type=\"radio\" name=\"linkslist\" value=\"stop_$linkname[$i]\"/>";
   } 
   $outputline.= " $linkname[$i]  -  $linkcpname[$i] <br>";
   print "&nbsp;$outputline<br>\n";
} else  { # linecount is 2 or greater
#
#  Build table (2 columns) of link execution radio buttons
#
   print "</p><table><tr><td> <strong> Select A Link To Start Or Stop: </strong></td><tr>\n";
   print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n";
   print "<tbody><tr><td nowrap=\"nowrap\" colspan=\"2\" valign=\"top\"><br>\n";
   if (($linecount % 2) == 1) { # if odd, add one to get proper split point
        $halfcount = ($linecount + 1) /2;
   } else {
        $halfcount = $linecount/2;
   }
   for ($i=0; $i < $halfcount; $i++) {
      if ($linktype[$i]=~m/^Start/) {    #  If the link is not active
         $outputline = "<b>Start</b><input type=\"radio\" name=\"linkslist\" value=\"start_$linkname[$i]\"/>";
      } elsif ($linktype[$i]=~m/^Stop/) {     # list active links to stop
         $outputline = "<b>Stop </b><input type=\"radio\" name=\"linkslist\" value=\"stop_$linkname[$i]\"/>";
      } 
      $outputline.= " $linkname[$i]  -  $linkcpname[$i] <br>";
      print "&nbsp;$outputline<br>\n";
   }
   print "</td><td nowrap=\"nowrap\" colspan=\"2\" valign=\"top\"><br>\n";
   for ($i=$halfcount; $i < $linecount; $i++) {
      if ($linktype[$i]=~m/^Start/) {    #  If the link is not active
         $outputline = "<b> | Start</b><input type=\"radio\" name=\"linkslist\" value=\"start_$linkname[$i]\"/>";
      } elsif ($linktype[$i]=~m/^Stop/) {     # list active links to stop
         $outputline = "<b> | Stop </b><input type=\"radio\" name=\"linkslist\" value=\"stop_$linkname[$i]\"/>";
      } 
      $outputline.= " $linkname[$i]  -  $linkcpname[$i] <br>";
      print "&nbsp;$outputline<br>\n";
   }
   print "</td></tr></tbody></table></table>";
   print "<br>";
}
print "<input type=\"submit\" name=\"action\" value=\"Submit\"/>";

print "</p></form></font>";

#   output the bottom of the template
print_bottom();
