#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_default_record, $arg_client_address, $arg_client_port, $arg_listen_local_address, $arg_description, $arg_host_address, $arg_host_port, $arg_host_ssl_enabled, $arg_serv_conn_security_level, $arg_cli_ssl_enabled, $arg_cli_conn_security_levell, $client_address, $listen_local_address, $description, $time, $line, @data, @contents);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_client_port=param('client_port_unique');

if ($arg_client_port eq "") {
    
    $arg_default_record="YES";
    $arg_client_address="";
    $arg_client_port="";
    $arg_listen_local_address="";
    $arg_host_address="";
    $arg_host_port="";
    $arg_cli_ssl_enabled="NO";
    $arg_cli_conn_security_levell="SSL_AUTHENTICATE_MIN";
    $arg_host_ssl_enabled="NO";
    $arg_serv_conn_security_level="SSL_AUTHENTICATE_MIN";
    $arg_description="";

    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    
    #   Allow access to all TN clients?
    print "<tr> <td>Allow access to all TN clients ? </td> <td><select name=\"default_record\"  class=\"rightAligned\" value=\"$arg_default_record\" >  ";
    print "<option value=\"NO\">NO</option> ";
    print "<option value=\"YES\" selected=\"selected\">YES</option> </select></td></tr>";
    
    print "<tr> <td>If NO, </td> </tr>";
    
    #    Client address or name
   print "<tr> <td> Client address or name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"client_address\"  maxlength=\"255\" value=\"$arg_client_address\" /></td></tr>";
    
    #   * Client port number
   print "<tr> <td>* Client port number : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"client_port_unique\"  maxlength=\"5\" value=\"$arg_client_port\" oninput=\"value=value.replace(/[^\\d]/g,'')\" required=\"required\" /></td></tr>";
    
    #   Local listen address
    print "<tr> <td> Local listen address : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"listen_local_address\"  maxlength=\"45\" value=\"$arg_listen_local_address\" >  ";
   
    #    * Host address or name
    print "<tr> <td>* Host address or name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"host_address\"  maxlength=\"255\" value=\"$arg_host_address\" required=\"required\" /></td></tr>";
    
    #   * Host port number
    print "<tr> <td>* Host port number : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"host_port\"  maxlength=\"5\" value=\"$arg_host_port\" oninput=\"value=value.replace(/[^\\d]/g,'')\" required=\"required\" /></td></tr>";
    
    #   SSL enabled on client connection?
    print "<tr><td>SSL enabled on client connection ?  </td> <td><select name=\"cli_ssl_enabled\"  class=\"rightAligned\" value=\"$arg_cli_ssl_enabled\" >  ";
    print "<option value=\"NO\" selected=\"selected\">NO</option> ";
    print "<option value=\"YES\">YES</option> ";
    print "<option value=\"YES_WITH_CLI_AUTH\">YES_WITH_CLI_AUTH</option> </select></td></tr>";
    
    print "<tr> <td> If YES or YES_WITH_CLI_AUTH, </td> </tr>";
    
    #   Security level on client connection
    print "<tr><td>Security level on client connection : </td> <td><select name=\"cli_conn_security_levell\"  class=\"rightAligned\" value=\"$arg_cli_conn_security_levell\" >  ";
    print "<option value=\"SSL_AUTHENTICATE_MIN\" selected=\"selected\">SSL_AUTHENTICATE_MIN</option> ";
    print "<option value=\"SSL_AUTHENTICATE_ONLY\">SSL_AUTHENTICATE_ONLY</option> ";
    print "<option value=\"SSL_40_BIT_MIN\">SSL_40_BIT_MIN</option> ";
    print "<option value=\"SSL_56_BIT_MIN\">SSL_56_BIT_MIN</option> ";
    print "<option value=\"SSL_128_BIT_MIN\">SSL_128_BIT_MIN</option> ";
    print "<option value=\"SSL_168_BIT_MIN\">SSL_168_BIT_MIN</option> ";
    print "<option value=\"SSL_256_BIT_MIN\">SSL_256_BIT_MIN</option> </select></td></tr>";
    
    # SSL enabled on host connection?
    print "<tr><td>SSL enabled on host connection ? </td> <td><select name=\"host_ssl_enabled\"  class=\"rightAligned\" value=\"$arg_host_ssl_enabled\" >  ";
    print "<option value=\"NO\" selected=\"selected\">NO</option> ";
    print "<option value=\"YES\" >YES</option> </select></td></tr>";
    
    print "<tr> <td> If YES, </td> </tr>";
    #   Security level on host connection
    print "<tr><td>Security level on host connection : </td> <td><select name=\"serv_conn_security_level\"  class=\"rightAligned\" value=\"$arg_serv_conn_security_level\" >  ";
    print "<option value=\"SSL_AUTHENTICATE_MIN\" selected=\"selected\">SSL_AUTHENTICATE_MIN</option> ";
    print "<option value=\"SSL_AUTHENTICATE_ONLY\">SSL_AUTHENTICATE_ONLY</option> ";
    print "<option value=\"SSL_40_BIT_MIN\">SSL_40_BIT_MIN</option> ";
    print "<option value=\"SSL_56_BIT_MIN\">SSL_56_BIT_MIN</option> ";
    print "<option value=\"SSL_128_BIT_MIN\">SSL_128_BIT_MIN</option> ";
    print "<option value=\"SSL_168_BIT_MIN\">SSL_168_BIT_MIN</option> ";
    print "<option value=\"SSL_256_BIT_MIN\">SSL_256_BIT_MIN</option> </select></td></tr>";
    
    #    Description
    print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
} else {
    $arg_default_record=param('default_record');
    $arg_client_address=param('client_address');
    $arg_client_port=param('client_port_unique');
    $arg_listen_local_address=param('listen_local_address');
    $arg_host_port=param('host_port');
    $arg_host_address=param('host_address');
    $arg_host_ssl_enabled=param('host_ssl_enabled');
    $arg_serv_conn_security_level=param('serv_conn_security_level');
    $arg_cli_ssl_enabled=param('cli_ssl_enabled');
    $arg_cli_conn_security_levell=param('cli_conn_security_levell');
    $arg_description=param('description');
    
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    if ($arg_client_address eq "") {
        $client_address="";
    }else
    {
        $client_address=",client_address=$arg_client_address";
    }
    
    if ($arg_listen_local_address eq "") {
        $listen_local_address="";
    }else
    {
        $listen_local_address=",listen_local_address=$arg_listen_local_address";
    }

    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tn_redirect, default_record=$arg_default_record,  client_port=$arg_client_port, host_address=$arg_host_address, host_port=$arg_host_port,  host_ssl_enabled=$arg_host_ssl_enabled, serv_conn_security_level=$arg_serv_conn_security_level, cli_ssl_enabled=$arg_cli_ssl_enabled, cli_conn_security_level=$arg_cli_conn_security_levell $client_address $listen_local_address $description`;
    
    print "Debug: sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tn_redirect, default_record=$arg_default_record,  client_port=$arg_client_port, host_address=$arg_host_address, host_port=$arg_host_port,  host_ssl_enabled=$arg_host_ssl_enabled, serv_conn_security_level=$arg_serv_conn_security_level, cli_ssl_enabled=$arg_cli_ssl_enabled, cli_conn_security_level=$arg_cli_conn_security_levell $client_address $listen_local_address $description";
   

   print "<br> Display Output from Add TN Redirector Access:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

exit 0; 

