#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_dcas_server, $arg_dcas_port, $arg_enabled, $dcas_port,
    $time, $line, @data, @contents);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_dcas_server=param('dcas_server_unique');
if ($arg_dcas_server eq "") {
    $arg_dcas_port="8990";
    $arg_enabled="YES";
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_tn3270_express_logon`;
    
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        
        if ($line=~m/dcas_server/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;
            $arg_dcas_server = $data[1];
            next;
        } elsif ($line=~m/dcas_port/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;
            $arg_dcas_port = $data[1];
            next;
        } elsif ($line=~m/enabled/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;
            $arg_enabled = $data[1];
            next;
        } else {
            next;
        }
        
    }
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    
    #   * DCAS Server Address or Name
    print "<tr> <td>* DCAS Server Address or Name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"dcas_server_unique\"  maxlength=\"255\" value=\"$arg_dcas_server\" required=\"required\" /></td></tr>";
    
    #    DCAS Server Port number
    print "<tr> <td>DCAS Server Port number(1-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"dcas_port\"  maxlength=\"5\" value=\"$arg_dcas_port\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    #   Enable Express Logon?
    print "<tr> <td>Enable Express Logon ? </td> <td><select name=\"enabled\"  class=\"rightAligned\" value=\"$arg_enabled\" >  ";
    print "<option value=\"YES\" selected=\"selected\">YES</option> ";
    print "<option value=\"NO\">NO</option> </select></td></tr>";
    
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
} else {
  
    $arg_dcas_server=param('dcas_server_unique');
    $arg_dcas_port=param('dcas_port');
    $arg_enabled=param('enabled');
    
    if ($arg_dcas_port eq "") {
        $dcas_port="";
    }else
    {
        $dcas_port=",dcas_port=$arg_dcas_port";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tn3270_express_logon, dcas_server=$arg_dcas_server, enabled=$arg_enabled $dcas_port`;
    
    print "Debug: sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tn3270_express_logon, dcas_server=$arg_dcas_server, enabled=$arg_enabled $dcas_port";
   
# Display output of snaadmin query_node
   print "<br> Display Output from Add TN3270 Express Logon:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

exit 0; 

