#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_ms_category, $arg_description, $arg_fp_fqcp_name, $arg_ms_appl_name, $description, $ms_appl_name, $fp_fqcp_name, $time, $line, @data, @contents);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_ms_category=param('ms_category_unique');
if ($arg_ms_category eq "") {
    $arg_description="";
    $arg_fp_fqcp_name="";
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    
    #   Fully qualified control point name
    print "<tr> <td>Fully qualified control point name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"fp_fqcp_name\"  maxlength=\"17\" value=\"$arg_fp_fqcp_name\" /></td></tr>";
    
    #    Description
    print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    #   * Management Services category
    print "<tr> <td>* Management Services category :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"ms_category_unique\"  maxlength=\"8\" value=\"$arg_ms_category\" required=\"required\" /></td></tr>";
    
    # Focal point application name
    print "<tr> <td>Focal point application name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"ms_appl_name\"  maxlength=\"8\" value=\"$arg_ms_appl_name\" /></td></tr>";
    
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
} else {
  
   $arg_description=param('description');
   $arg_ms_category=param('ms_category_unique');
   $arg_fp_fqcp_name=param('fp_fqcp_name');
   $arg_ms_appl_name=param('ms_appl_name');
    
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    if ($arg_fp_fqcp_name eq "") {
        $fp_fqcp_name="";
    }else
    {
        $fp_fqcp_name=",fp_fqcp_name=$arg_fp_fqcp_name";
    }
    
    if ($arg_ms_appl_name eq "") {
        $ms_appl_name="";
    }else
    {
        $ms_appl_name=",ms_appl_name=$arg_ms_appl_name";
    }
    
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_focal_point, ms_category=$arg_ms_category  $fp_fqcp_name $description $ms_appl_name`;
    
    print "Debug: sudo -u snauser /opt/ibm/sna/bin/snaadmin define_focal_point, ms_category=$arg_ms_category  $fp_fqcp_name $description $ms_appl_name";
   
   print "<br> Display Output from Add Focal Point:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "$line";
   }
}
#

exit 0; 

