#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_eth_port_name, $arg_description, $arg_port_number,$arg_dlc_name, $arg_initially_active, $arg_lsap_address, $arg_implicit_hpr_support, $arg_implicit_link_lvl_error, $arg_implicit_uplink_to_en, $arg_max_rcv_btu_size, $arg_tot_link_act_lim,$arg_implicit_dspu_template, $arg_max_ifrm_rcvd, $arg_xid_timer_retry, $description, $dlc_name, $len,$port_number, $lsap_address,$max_rcv_btu_size, $tot_link_act_lim,$implicit_dspu_template, $max_ifrm_rcvd, $xid_timer_retry, $time, $line, @data, @contents, @dlclist, @dspulist);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "Failed to access the node. \n";
        exit -1;
    }
}

$arg_eth_port_name=param('ethportname_unique');

if ($arg_eth_port_name eq "") {
    
    $arg_description="";
    $arg_port_number="";
    $arg_dlc_name="";
    $arg_initially_active="YES";
    $arg_lsap_address="04";
    $arg_implicit_hpr_support="YES";
    $arg_implicit_link_lvl_error="NO";
    $arg_implicit_uplink_to_en="NO";
    $arg_max_rcv_btu_size="1033";
    $arg_tot_link_act_lim="64";
    $arg_implicit_dspu_template="";
    $arg_max_ifrm_rcvd="7";
    $arg_xid_timer_retry="5";
    
   @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_dlc`;
   foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        
        if ($line=~m/dlc_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            $dlc_name= $data[1];
            next;
        }elsif ($line=~m/dlc_type/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            if ($data[1]=~m/ETHERNET/) {
                 push @dlclist, $dlc_name;
            }
            next;
        }
   }
    
   $len=@dlclist;
    if($len eq 0){
        print "<br> Ethernet DLC should be defined before define Ethernet Port. ";
        exit 1;
    }
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_dspu_template`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        
        if ($line=~m/template_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @dspulist, $data[1];
            next;
        }
    }
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    #  Port name
    print "<tr> <td>* Port name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"ethportname_unique\"  maxlength=\"8\" value=\"$arg_eth_port_name\" required=\"required\" /></td></tr>";
    
    #  Description
    print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\" maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    #  Port number
    print "<tr> <td>Port number : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"port_number\"  maxlength=\"8\" value=\"$arg_port_number\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   DLC Name
   print "<tr> <td>DLC Name : </td> <td><select name=\"dlc_name\"  class=\"rightAligned\" value=\"$arg_dlc_name\" /> ";
   foreach $line (@dlclist) {
       print "<option value=\"$line\">$line</option> ";
    }
   print "</select></td></tr>";
    
    #  Local SAP address
   print "<tr> <td>Local SAP address(0x04-0xEC) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"lsap_address\"  maxlength=\"2\" value=\"$arg_lsap_address\"  oninput=\"value=value.replace(/[^0-9a-fA-F]/g,'')\" /></td></tr>";

    #  Initially active?
   print "<tr> <td>Initially active ? </td> <td><select name=\"initially_active\"  class=\"rightAligned\" value=\"$arg_initially_active\" > ";
   print "<option value=\"YES\" selected=\"selected\">YES</option> ";
   print "<option value=\"NO\">NO</option> </select> </td></tr>";
    
    #   Use HPR on implicit links?
    print "<tr> <td>Use HPR on implicit links ? </td> <td><select name=\"implicit_hpr_support\"  class=\"rightAligned\" value=\"$arg_implicit_hpr_support\" >  ";
    print "<option value=\"YES\" selected=\"selected\">YES</option> ";
    print "<option value=\"NO\">NO</option> </select></td></tr>";
    
    #   Use HPR link level error recovery?
    print "<tr> <td>Use HPR link level error recovery ? </td> <td><select name=\"implicit_link_lvl_error\"  class=\"rightAligned\" value=\"$arg_implicit_link_lvl_error\" >  ";
    print "<option value=\"YES\">YES</option> ";
    print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";
    
    #   Implicit links to end nodes are uplinks?
    print "<tr> <td>Implicit links to end nodes are uplinks ? </td> <td><select name=\"implicit_uplink_to_en\"  class=\"rightAligned\" value=\"$arg_implicit_uplink_to_en\" >  ";
    print "<option value=\"YES\">YES</option> ";
    print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";
    
    #   Maximum BTU size allowed
    print "<tr> <td>Maximum BTU size allowed(265-7689) :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_rcv_btu_size\"  maxlength=\"5\" value=\"$arg_max_rcv_btu_size\"  oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   Maximum number of active links allowed
    print "<tr> <td>Maximum number of active links allowed(0-65535) :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"tot_link_act_lim\"  maxlength=\"5\" value=\"$arg_tot_link_act_lim\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    #  Implicit DSPU template
    print "<tr> <td>Implicit DSPU template : </td> <td><select name=\"implicit_dspu_template\"  class=\"rightAligned\" value=\"$arg_implicit_dspu_template\" />  ";
    foreach $line (@dspulist) {
        print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";
    #   Maximum number of I-frames outstanding
    print "<tr> <td>Maximum number of I-frames outstanding(1-127) :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_ifrm_rcvd\"  maxlength=\"3\"  value=\"$arg_max_ifrm_rcvd\"  oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    #  XID retry count
    print "<tr> <td>XID timer retry count(0-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"xid_timer_retry\"  maxlength=\"5\" value=\"$arg_xid_timer_retry\"  oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
    
} else {
   $arg_eth_port_name=param('ethportname_unique');   # get ethernet port name
   $arg_description=param('description');  # get Description
   $arg_port_number=param('port_number');  # get port number
   $arg_dlc_name=param('dlc_name');
   $arg_initially_active=param('initially_active');
   $arg_lsap_address=param('lsap_address');
   $arg_implicit_hpr_support=param('implicit_hpr_support');
   $arg_implicit_link_lvl_error=param('implicit_link_lvl_error');
   $arg_implicit_uplink_to_en=param('implicit_uplink_to_en');
   $arg_max_rcv_btu_size=param('max_rcv_btu_size');
   $arg_tot_link_act_lim=param('tot_link_act_lim');
   $arg_implicit_dspu_template=param('implicit_dspu_template');
   $arg_max_ifrm_rcvd=param('max_ifrm_rcvd');
   $arg_xid_timer_retry=param('xid_timer_retry');
   
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    if ($arg_port_number eq "") {
        $port_number="";
    }else
    {
        $port_number=",port_number=$arg_port_number";
    }
    
    if ($arg_lsap_address eq "") {
        $lsap_address="";
    }else
    {
        $lsap_address=",lsap_address=0x$arg_lsap_address";
    }
    
    if ($arg_max_rcv_btu_size eq "") {
        $max_rcv_btu_size="";
    }else
    {
        $max_rcv_btu_size=",max_rcv_btu_size=$arg_max_rcv_btu_size";
    }
    
    if ($arg_tot_link_act_lim eq "") {
        $tot_link_act_lim="";
    }else
    {
        $tot_link_act_lim=",tot_link_act_lim=$arg_tot_link_act_lim";
    }
    
    if ($arg_implicit_dspu_template eq "") {
        $implicit_dspu_template="";
    }else
    {
        $implicit_dspu_template=",implicit_dspu_template=$arg_implicit_dspu_template";
    }
    
    if ($arg_max_ifrm_rcvd eq "") {
        $max_ifrm_rcvd="";
    }else
    {
        $max_ifrm_rcvd=",max_ifrm_rcvd=$arg_max_ifrm_rcvd";
    }
    
    if ($arg_xid_timer_retry eq "") {
        $xid_timer_retry="";
    }else
    {
        $xid_timer_retry=",xid_timer_retry=$arg_xid_timer_retry";
    }

    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_ethernet_port,port_name= $arg_eth_port_name, dlc_name=$arg_dlc_name  , initially_active=$arg_initially_active  , implicit_hpr_support=$arg_implicit_hpr_support  , implicit_link_lvl_error=$arg_implicit_link_lvl_error  , implicit_uplink_to_en=$arg_implicit_uplink_to_en  $port_number $lsap_address  $max_rcv_btu_size $tot_link_act_lim $implicit_dspu_template $max_ifrm_rcvd  $xid_timer_retry  $description `;
    
    print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_ethernet_port,port_name= $arg_eth_port_name, dlc_name=$arg_dlc_name  , initially_active=$arg_initially_active  , implicit_hpr_support=$arg_implicit_hpr_support  , implicit_link_lvl_error=$arg_implicit_link_lvl_error  , implicit_uplink_to_en=$arg_implicit_uplink_to_en  $port_number $lsap_address  $max_rcv_btu_size $tot_link_act_lim $implicit_dspu_template $max_ifrm_rcvd  $xid_timer_retry  $description ";
   
# Display output of snaadmin query_node
   print "<br> Display Output from Add Ethernet Port:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

exit 0; 

