#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_ethdlcname, $arg_description, $arg_neg_ls_supp, $arg_initially_active, $arg_adapter_number, $arg_lan_type, $description, $adapter_number,
    $time, $line, @data, @contents);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "Failed to access the node. \n";
        exit -1;
    }
}

$arg_ethdlcname=param('ethdlcname_unique');
if ($arg_ethdlcname eq "") {
    $arg_adapter_number="0";
    $arg_description="";
    $arg_neg_ls_supp="YES";
    $arg_initially_active="YES";
    $arg_lan_type="802_3_DIX";
        
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    
    #   Define DLC name
    print "<tr> <td>* DLC name :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"ethdlcname_unique\"  maxlength=\"8\" value=\"$arg_ethdlcname\" required=\"required\" /> </td></tr>";

    #   Define Description field
    print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    #   Define Negotiable link stations supported?
    print "<tr> <td>Negotiable link stations supported ? </td> <td><select name=\"neg_ls_supp\"  class=\"rightAligned\" value=\"$arg_neg_ls_supp\">";
    print "<option value=\"YES\" selected=\"selected\">YES</option> ";
    print "<option value=\"NO\">NO</option> </select></td></tr>";

    #   Define Initially active?
    print "<tr> <td>Initially active ? </td> <td><select name=\"initially_active\"  class=\"rightAligned\" value=\"$arg_initially_active\" >  ";
    print "<option value=\"YES\" selected=\"selected\">YES</option> ";
    print "<option value=\"NO\">NO</option> </select></td></tr>";
    
    #   Adapter Number
    print "<tr> <td>Adapter Number :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"adapter_number\"  maxlength=\"9\"  value=\"$arg_adapter_number\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   Ethernet type
    print "<tr> <td>Ethernet type :</td> <td><select name=\"lan_type\"  class=\"rightAligned\" value=\"$arg_lan_type\" >  ";
    print "<option value=\"802_3\">802_3</option> ";
    print "<option value=\"DIX\">DIX</option> ";
    print "<option value=\"802_3_DIX\" selected=\"selected\">802_3_DIX</option> </select></td></tr>";
    
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
} else {
   $arg_ethdlcname=param('ethdlcname_unique');   # get ethernet dlc name
   $arg_description=param('description');  # get Description
   $arg_neg_ls_supp=param('neg_ls_supp');   # get Negotiable link stations supported?
   $arg_initially_active=param('initially_active');       #get initially active?
   $arg_adapter_number=param('adapter_number');       #get Adapter Number
   $arg_lan_type=param('lan_type');       #get Ethernet type
    
   
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    if ($arg_adapter_number eq "") {
        $adapter_number="";
    }else
    {
        $adapter_number=",adapter_number=$arg_adapter_number";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_ethernet_dlc,dlc_name=$arg_ethdlcname, neg_ls_supp=$arg_neg_ls_supp, initially_active=$arg_initially_active, lan_type=$arg_lan_type $adapter_number $description `;
    
    print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_ethernet_dlc,dlc_name=$arg_ethdlcname, neg_ls_supp=$arg_neg_ls_supp, initially_active=$arg_initially_active, lan_type=$arg_lan_type $adapter_number $description";
   
# Display output of snaadmin query_node
   print "<br> Display Output from Add Ethernet DLC:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

exit 0; 

