#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_dspu_template, $arg_description, $arg_max_instance, $arg_min_nau, $arg_max_nau, $arg_allow_timeout, $arg_delayed_logon, $arg_host_lu, $description, $max_instance,
    $time, $line, @data, @list, @contents);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_dspu_template=param('dspu_template_unique');

if ($arg_dspu_template eq "") {
   
    $arg_description="";
    $arg_max_instance="";
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_lu_0_to_3`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        if ($line=~m/lu_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @list, $data[1];
            next;
        }
    }
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_lu_pool`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        if ($line=~m/pool_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @list, $data[1];
            next;
        }
    }
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\"> ";
    print "<tbody> ";
    
    #   DSPU template name
   print "<tr> <td>* DSPU template name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"dspu_template_unique\"  maxlength=\"8\" value=\"$arg_dspu_template\" required=\"required\" /></td></tr>";
    
    #   Description
   print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    #  Maximum number of DSPU instances allowed
    print "<tr><td>Maximum number of DSPU instances allowed(0-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_instance\" maxlength=\"5\" value=\"$arg_max_instance\"  oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";

    print "<tr><td><b>if define dslu_template, please fill the requied field below :</b></td></tr>";
    
    # First LU number (1-255)
    print "<tr><td>* First LU number (1-255) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"min_nau\" maxlength=\"3\" value=\"$arg_min_nau\"  oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    # Last LU number (1-255)
     print "<tr><td>* Last LU number (1-255) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_nau\" maxlength=\"3\" value=\"$arg_max_nau\"  oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    # Allow timeout
    print "<tr><td>Allow timeout : </td> <td> <select name=\"allow_timeout\" class=\"rightAligned\" value=\"$arg_allow_timeout\" >  ";
    print "<option value=\"NO\" selected=\"selected\">NO</option> ";
    print "<option value=\"YES\">YES</option></select></td></tr>";
    
    # Allow delayed logon
    print "<tr><td>Allow delayed logon : </td> <td> <select name=\"delayed_logon\" class=\"rightAligned\" value=\"$arg_delayed_logon\" >  ";
    print "<option value=\"NO\" selected=\"selected\">NO</option> ";
    print "<option value=\"YES\">YES</option></select></td></tr>";
    
    # Host LU name
    print "<tr><td>* Host LU name :</td> <td><select name=\"host_lu\" class=\"rightAligned\" value=\"$arg_host_lu\" >  ";
    print "<option value=\"\"></option> ";
    foreach $line (@list) {
        print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";
    
    print "<tr> <td><input type=\"submit\"  value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
   
} else {
  
    $arg_description=param('description');
    $arg_max_instance=param('max_instance');
    $arg_min_nau=param('min_nau');
    $arg_max_nau=param('max_nau');
    $arg_host_lu=param('host_lu');
    $arg_delayed_logon=param('delayed_logon');
    $arg_allow_timeout=param('allow_timeout');

  
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    if ($arg_max_instance eq "") {
        $max_instance="";
    }else
    {
        $max_instance=",max_instance=$arg_max_instance";
    }
    
    print "<br> Display Output from Add DSPU Template :";
    
    if ($arg_min_nau eq "" && $arg_max_nau eq "" && $arg_host_lu eq "" )
    {
        @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_dspu_template,  template_name=$arg_dspu_template $description $max_instance`;
        
        print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_dspu_template, template_name=$arg_dspu_template $description $max_instance";
    } elsif($arg_min_nau ne "" && $arg_max_nau ne "" && $arg_host_lu ne "" )
    {
        @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_dspu_template,  template_name=$arg_dspu_template $description $max_instance ,{dslu_template}, min_nau=$arg_min_nau, max_nau=$arg_max_nau, host_lu=$arg_host_lu, allow_timeout=$arg_allow_timeout, delayed_logon=$arg_delayed_logon`;
        
        print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_dspu_template,  template_name=$arg_dspu_template $description $max_instance ,{dslu_template}, min_nau=$arg_min_nau, max_nau=$arg_max_nau, host_lu=$arg_host_lu, allow_timeout=$arg_allow_timeout, delayed_logon=$arg_delayed_logon";
    }else{
        print "<br>if you want to define dslu_template, please fill all the requied field or left them empty. ";
        @contents="";
    }
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

exit 0; 

