#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2012 All rights reserved. #
#                                                     #
#######################################################

#  Purpose of the script is to call snaadmin query_local_lu and display
#  sys_name information a terse format .


use strict;

 my ( $luname, $aliasname, $sysname, $descript, @data, @status );

#  Initialize for scalar declaration
$luname = " ";

if ($#ARGV < 0)    # Check for input argument on line
{
  @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -d query_local_lu `;             # Get detailed Link Station information
} else {
  @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $ARGV[0] -d query_local_lu` or die "Node $ARGV[0] not recognized $!\n";
}

#   Print header line


print "LU Name   LU ALias               Sys Name            Description \n";
print "========  ========  ==============================  ============= \n";


foreach(@status) {
   chomp;
   if (/^query_local_lu/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }

  #  Skip headers
   next if (/^------/);
   next if (/^list_option/);

   next if (/^\n/);

   @data = split(/=/,$_);   #Break NAU, LU, Type, Status

   next if (@data == 0);        # on blank line, skip

# debug   print "line: $line:", @data;

   if ($data[0]=~m/^lu_name/) {       # get LU name
     $luname = $data[1];
     $luname=~s/ //g;
   } elsif ($data[0]=~m/^description/) { # description
     $descript = "<nobr>$data[1]</nobr>";
#     $descript=~s/-/&#45;\\/g;
     $descript=~s/ //g;
     next;
   } elsif ($data[0]=~m/^lu_alias/) {  # alias name
     $aliasname = $data[1];
     $aliasname=~s/ //g;
     next;
   } elsif ($data[0]=~m/^sys_name/) { # sys_name
     $sysname = $data[1];
     $sysname=~s/ //g;
     if (m/\"/) {
        $sysname="-------------------------------";
     } 
     printf("%8s %8s %32.32s   %s \n",
         $luname, $aliasname, $sysname, $descript);
     next;
   }
}
print "\n------------------------------------------------\n";

