#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2004 All rights reserved. #
#                                                     #
#######################################################

#  Purpose of the script is to call snaadmin query_pu and display
#  in a terse format the information. By 'grep"ing on the output for "=",
#  only the active API and tn3270 sessions will be displayed.


use strict;

 my (  $puname_set, $label, $value, @status );

#  Initialize for scalar declaration
$puname_set = 0;

if ($#ARGV < 0)    # Check for input argument on line
{
  @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_pu ; sudo -u webuser snaadmin query_downstream_pu`; # Get Dep. LU information
} else {
  @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $ARGV[0] query_pu ; sudo -u webuser snaadmin query_downstream_pu` 
       or die "Node $ARGV[0] not recognized $!\n";
}

#   Print header line
print "\n=    PU:    LINK:   ACTIVE:   ATTACHMENT: \n";
print "= ======= ========  =======   ========== ";

foreach(@status) {
   chomp;
   if (/^query_pu/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }
 
  #  Skip headers
   next if (/^----/);
   next if (/^list_option/);
   next if (/^host_attachment/ && (!$puname_set));

   next if (/^\n/);

   ($label,$value) = split(/=/,$_);  # Get label = value

   if (/^pu_name/) {       # get PU name
      $value=~s/ //g; 
      printf( "\n %8s ",$value);
      $puname_set = 1;
      next;
   } elsif (/^dspu_name/) {  # get DNST PU name
      $value=~s/ //g; 
      printf( "\n %8s ",$value);
      next;
   } elsif (/^ls_name/) {  # Link station
      $value=~s/ //g;
      printf("%8s ", $value);
      next;
   } elsif (/^pu_sscp_sess_/) { # is PU active 
      $value=~s/ //g;
      printf("%8s ", $value);
      next;
   } elsif (/^host_attachment/) { # How is this attached
      $value=~s/ //g;
      printf("  %s ", $value);
      next;
   } elsif (/^dspu_service/) { # PU type
      $value=~s/ //g;
      printf("  %s ", $value);
      next;
   }  else {                     # get next line
      next;       
   }
}
print "\n------------------------------------------------\n";

