#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2004 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $trace_opt, $action, $linkname, $time, $num_select, @result, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;
$trace_opt = " ";
print "<b> Communication Server Web Admin TN3270 Trace: $time</b>";
print "<font face=\"Courier, Helvetica\">";
print "<p>\n";

if (! param) {
   print "Invalid invocation of Trace activation!";
} else {
   $arg=param('traceopt');
   if ($arg=~/^none/) {
       $trace_opt = "NONE";
   } elsif ($arg=~/^all/) {
       $trace_opt = "ALL";
   } else {
   # Determine selection of trace flags
       $num_select = 0;   # track if any are selected
     if ($arg=param('tcp')) {
       $trace_opt.="TCP+";
       $num_select++;
     }
     if ($arg=param('cfg')) {
       $trace_opt.="CFG+";
       $num_select++;
     }
     if ($arg=param('fmapi')) {
       $trace_opt.="FMAPI+";
       $num_select++;
     }
     if ($arg=param('nof')) {
       $trace_opt.="NOF+";
       $num_select++;
     }
     $trace_opt=~s/\+$//;
   #  if nothing selected, turn off all trace points 
     if ($num_select == 0) {
        $trace_opt = "NONE";
     }
   }
 # Set trace
 #  commout out    print "<br> Debug: snaadmin set_tn_server_trace_type,trace_flags=$trace_opt<br>";

   @result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin set_tn_server_trace,trace_flags=$trace_opt `;
}
print "<b>";
foreach(@result) {
   chomp;
   next if (/^------/);
   print $_;
}
print "</b><br>";
print "<br><b> TN3270 Trace Status: </b><br>";

@contents=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_tn_server_trace`; # Command to get Tracestatus

foreach $line (@contents) {
   $line=~s/ /&nbsp;/g;
   print "<br>$line";
}

print "</font></p>";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

exit 0;

