#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2006 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $trace_opt, $action, $linkname, $time, @result, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;
$trace_opt = " ";
print "<b> Communication Server Web Admin DLC Trace: $time</b>";
print "<font face=\"Courier, Helvetica\">";
print "<p>\n";

if (! param) {
   print "Invalid invocation of Trace activation!";
} else {
   $arg=param('traceopt');
   if ($arg=~/^none/) {
 # Remove trace
      @result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin remove_dlc_trace `;

   } elsif ($arg=~/^all/) {
 # Set trace
      @result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin add_dlc_trace `;


   } else {
   # error in selection of trace flags
      print "Invalid selection of DLC Trace options!";
   }

}
print "<b>";
foreach(@result) {
   chomp;
   next if (/^------/);
   print $_;
}
print "</b><br>";

@contents=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_dlc_trace`; # Command to get Tracestatus

foreach $line (@contents) {
   $line=~s/ /&nbsp;/g;
   print "<br>$line";
}

print "</font></p>";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

exit 0;

