/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.appletresource;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import sun.applet.AppletResourceLoader;
import sun.net.www.URLConnection;

public class AppletResourceConnection
extends URLConnection {
    private static boolean debug;
    private Object resource;
    private String base;
    private String member;
    private URL cachedURL;

    protected AppletResourceConnection(URL uRL) throws MalformedURLException, IOException {
        super(uRL);
        this.debug("AppletResourceConnection(" + uRL + ")");
        String string = uRL.getFile();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        this.base = string.substring(0, string.indexOf("/+/"));
        this.member = string.substring(string.indexOf("/+/") + 3);
        this.cachedURL = new URL(String.valueOf(this.base) + this.member);
        this.debug(" base: " + this.base);
        this.debug(" member: " + this.member);
        this.debug(" cachedURL: " + this.cachedURL);
    }

    public void connect() throws IOException {
        this.debug("Looking for " + this.cachedURL + " in AppletResourceLoader");
        Object object = AppletResourceLoader.getLocalResource(this.cachedURL);
        if (object == null) {
            this.debug("Invalid resource name");
            this.resource = null;
            return;
        }
        this.debug("Found resource");
        this.resource = object;
    }

    public Object getContent() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.resource;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.resource instanceof InputStream) {
            return (InputStream)this.resource;
        }
        return AppletResourceLoader.getLocalResourceStream(this.cachedURL);
    }

    private void debug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }
}

