echo off
REM To generate an xml file from the input activity log file
REM enter the following:
REM   ivblogfile intxtfile outxmlfile
REM where intxtfile is the full path name of the input log file in text format
REM       outxmlfile is the full path name of the output xml file
REM
REM   e.g. ivblogfile d:\cbroker\service\activity.txt d:\cbroker\service\act.xml
REM
REM To generate an xml file for a specific unit of work only
REM enter the following:
REM   ivblogfile intxtfile outxmlfile -filter filterval
REM where
REM       intxtfile is the full path name of the input log file
REM       outxmlfile is the full path name of the output xml file
REM       -filter specifiy the option to generate for a specific unit of work
REM       filterval is the value of the unit of work 
REM  e.g. ivblogfile d:\cbroker\service\activity.txt d:\cbroker\service\act.xml -filter 7346:mfok.torolab.ibm.com
REM
setlocal
for /f %%d in ('cd') do set CURRDIR=%%d
set DIR=%SOMCBASE%\bin
pushd %DIR%
jre -DIVB_HOME=%USERPROFILE% -DIVB_DRIVER_PATH=%SOMCBASE% ^
  -DTEMP=%TEMP% ^
  -DCURRDIR=%CURRDIR% ^
  -DVABHELP=%VABHELP% ^
  -DSymptomAnalyzerPath=%SOMCBASE%\bin\symptomdb.xml ^
  -DTimeStampFormat="M/d/yy H:mm:ss." ^
  -cp %SOMCBASE%\lib\ivblogbr.jar;%SOMCBASE%\bin;%SOMCBASE%\lib\ivbjfaceall.jar;%SOMCBASE%\lib\ivbjfc.jar;%SOMCBASE%\lib\ivbxml.jar -mx90m -ms30m com.ibm.ivb.log.LogFile %*
popd

