/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.BrowserFrame;
import com.ibm.ivb.jface.LinkEvent;
import com.ibm.ivb.log.tree.Node;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.ivb.log.ui.ProgressiveExecution;
import com.ibm.ivb.log.ui.TranslatableConstants;
import com.ibm.ivb.log.ui.UIConstants;
import com.ibm.ivb.log.ui.events.AdvancedAnalysisEvent;
import java.io.File;

public class AdvAnalyzeExecution
extends ProgressiveExecution
implements UIConstants,
TranslatableConstants {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Node[] nodes;
    private File mapDir;
    private int toBeAnalyzedNodeIndex;
    private int toBeAnalyzedChildIndex;

    AdvAnalyzeExecution(BrowserFrame browserFrame, Node[] nodeArray, File file) {
        super(browserFrame);
        this.nodes = nodeArray;
        this.mapDir = file;
        this.setActionNormalText(LogBrowser.getLBString("ComIbmIvbLogUiStatusPerformAdvAnalysis"));
    }

    protected int getTotalNumberOfSteps() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.nodes.length) {
            n = this.nodes[n2].isLeaf() ? ++n : (n += this.nodes[n2].getChildCount());
            ++n2;
        }
        return n;
    }

    protected boolean performStep(int n) {
        Node node = this.nodes[this.toBeAnalyzedNodeIndex];
        if (node.isLeaf()) {
            node.advanceAnalyze("GPF Analyzer", this.mapDir.getPath());
            ++this.toBeAnalyzedNodeIndex;
            this.toBeAnalyzedChildIndex = 0;
        } else {
            node.getChild(this.toBeAnalyzedChildIndex).advanceAnalyze("GPF Analyzer", this.mapDir.getPath());
            ++this.toBeAnalyzedChildIndex;
            if (this.toBeAnalyzedChildIndex == node.getChildCount()) {
                ++this.toBeAnalyzedNodeIndex;
                this.toBeAnalyzedChildIndex = 0;
            }
        }
        return true;
    }

    protected boolean actionCompletion() {
        if (this.nodes.length == 1 && this.nodes[0].isLeaf()) {
            String string = this.nodes[0].getAnalysisResult("GPF Analyzer");
            this.frame.fireLinkEvent((LinkEvent)new AdvancedAnalysisEvent(this.frame, string));
        } else {
            this.frame.fireLinkEvent((LinkEvent)new AdvancedAnalysisEvent(this.frame));
        }
        return true;
    }

    protected void actionFinalize() {
        super.actionFinalize();
    }
}

