/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

#ifndef IMSCLNT_HPP
#define IMSCLNT_HPP

#include "hws.h"
#include "imsclnt.h"
#include "hwsdlist.hpp"
#include "tcpotma.hpp"
#include "hwscnvtr.hpp"
#include "hwssgmnt.hpp"
#include "hwssegs.hpp"
#include "hwsbval.hpp"

class HWSError;

/*--------------------------------------------------------------------*/
/* The IMSClient class provides a means of submitting messages to     */
/* and receiveing messages from IMS transactions.                     */
/*                                                                    */
/* The HWSError interface is only available to IMS Web code.          */
/*                                                                    */
/* Change History:                                                    */
/*                                                                    */
/* 03/18/98  JEH  PTM2338 Add support for encryption exits.           */
/*                                                                    */
/* 05/08/98  JEH  PTM2481 New OTMA msg format; LTERM override.        */
/*                                                                    */
/*--------------------------------------------------------------------*/
class DllExport IMSClient {

   /*-----------------------------------------------------------------*/
   /* Public methods and attributes.                                  */
   /*-----------------------------------------------------------------*/
   public:

   IMSClient( HWSClientType aType,
              HWSConverter  *aConvObj );
   ~IMSClient();

#ifdef HWS_IMSWEB
   int            setStringOption(      char           *optName,
                                        char           *optValue,
                                        HWSError       *errObj );

   int            setByteOption(        char           *optName,
                                        HWSByteValue   *optValue,
                                        HWSError       *errObj );
#else
   int            setStringOption(      char           *optName,
                                        char           *optValue );

   int            setByteOption(        char           *optName,
                                        HWSByteValue   *optValue );
#endif

   char           *getStringOption(     char           *optName );

   HWSByteValue   *getByteOption(       char           *optName );

#ifdef HWS_IMSWEB
   int         connect( HWSError *errObj );
#else
   int         connect();
#endif

#ifdef HWS_IMSWEB
   int         disconnect( HWSError *errObj );
#else
   int         disconnect();
#endif

#ifdef HWS_IMSWEB
   int         send( HWSSegments *inSegs,
                     HWSError    *errObj );
#else
   int         send( HWSSegments *inSegs );
#endif

#ifdef HWS_IMSWEB
   int         receive( HWSSegments **segs, HWSError *errObj );
#else
   int         receive( HWSSegments **segs );
#endif

#ifdef HWS_IMSWEB
   int         sendResponse( HWSResponseType aRespType, HWSError *errObj );
#else
   int         sendResponse( HWSResponseType aRespType );
#endif

#ifdef HWS_IMSWEB
   int         exitConversation( HWSexitConvType aExitType, HWSError *errObj );
#else
   int         exitConversation( HWSexitConvType aExitType );
#endif



   /*-----------------------------------------------------------------*/
   /* Private methods and attributes.                                 */
   /*-----------------------------------------------------------------*/
   private:

   void    setIOption( char     *optName,
                       char     *optValue );

   void    addOption2List( char *oName, void *optValue, int optLength );

   HWSBool allITOCOptionsSet( HWSError *errObj );

   HWSBool allConnectOptionsSet( HWSError *errObj );

   void    sendOTMAMsg( HWSDList     *msgInList,
                        int          msglen,
                        char         *ruName,
                        HWSConverter *convObj,
                        HWSError     *errObj );

   HWSClientType  clType;          /* Type of IMSClient object.       */
   HWSDList       *optionList;     /* Option name/value pairs.        */
   HWSConverter   *convObj;        /* Converter object.               */

   TcpOtma        *hostObj;
   HWSAPIState    currentState;    /* Current state IMSClient's API.  */

   /*-----------------------------------------------------------------*/
   /* Option counts are used by methods allITOCOptionsSet and         */
   /* allConnectOptionsSet to detect if necessary options are set.    */
   /*-----------------------------------------------------------------*/

   /*     For setOption method...                                     */
   int    HOSTNAMECount;
   int    PORTCount;
   int    IMSNAMECount;
   int    RUNAMECount;
   int    LTERMOVERCount;                             /* PTM2481      */
   int    USERIDCount;
   int    GROUPCount;
   int    PASSWORDCount;
   int    PDATATYPECount;                             /* PTM2338      */
   int    SYNCLEVELCount;
   int    TRANTYPECount;
   int    CONNTYPECount;
   int    CONVIDCount;
   int    CONVSTATECount;

};

#endif

