/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

#ifndef IMSCLNT_H
#define IMSCLNT_H

/*--------------------------------------------------------------------*/
/* Include file for class IMSClient.                                  */
/*                                                                    */
/* Change History:                                                    */
/*                                                                    */
/* 03/18/98  JEH  PTM2338 Add support for encryption exits.           */
/*                                                                    */
/* 05/08/98  JEH  PTM2481 New OTMA msg format; LTERM override.        */
/*                                                                    */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* typedefs...                                                        */
/*--------------------------------------------------------------------*/
typedef enum  { HWS_INVALIDTYPE,         /* Invalid type.             */
                HWS_ITOC,                /* OTMA message via TCPIP to */
                                         /* ITOC.                     */
                HWS_LU62,                /* LU6.2                     */
                HWS_MQ                   /* MQSeries                  */
              } HWSClientType;

typedef enum  { HWS_ACK,                 /* Positive acknowledgement. */
                HWS_NACK                 /* Negative acknowledgement. */
              } HWSResponseType;         /* Response type.            */

typedef enum  { HWS_COMMIT,              /* commit.                   */
                HWS_ABORT                /* abort.                    */
              } HWSexitConvType;         /* exitConversation type.    */

typedef enum  { HWS_NOSTATE,
                HWS_ERROR_STATE,         /* error state.              */
                HWS_CONNECT_STATE,       /* connect state.            */
                HWS_SEND_STATE,          /* send state.               */
                HWS_RECEIVE_STATE,       /* receive state.            */
                HWS_RECRESP_STATE,       /* receive response state.   */
                HWS_SENDRESP_STATE,      /* send response state.      */
                HWS_DISCONN_STATE,       /* disconnect state.         */
                HWS_EXITCONV_STATE       /* exitConversation state.   */
              } HWSAPIState;             /* State of API.             */

/*--------------------------------------------------------------------*/
/* The following figure shows methods not including exitConversation. */
/*--------------------------------------------------------------------*/
/*        Begin-----------\                               End         */
/*                         \      + -------------------+    A         */
/*                          \     |                    |    |         */
/*       +-------------------\----------------------+  |    |         */
/*       |                    |   |                 |  |    |         */
/*       |                    V   |                 V  V    |         */
/*       send-----\           connect <-------------disconnect        */
/*       response  \              |                    A              */
/*       A          +----------+  |                    |              */
/*       |                     V  V                    |              */
/*       |    +----------------send <--+               |              */
/*       |    |                 |      |               |              */
/*       |    |                 |      |               |              */
/*       |    V                 V      |               |              */
/*       receive              receive--+               |              */
/*       response               |                      |              */
/*                              |                      |              */
/*                              +----------------------+              */
/*                                                                    */
/*--------------------------------------------------------------------*/
/* exitConversation can be issued following                           */
/*                  - connect                                         */
/*                  - send                                            */
/*                  - receive                                         */
/*                  - receive response                                */
/*                  - sendResponse                                    */
/* exitConversation can be followed by                                */
/*                  - send                                            */
/*                  - disconnect                                      */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Defines for HWS_ITOC Options.  All options are character strings.  */
/*                                                                    */
/* Note: if you add an option, remember to add a corresponding        */
/*       "use count" attribute to IMSClient.                          */
/*--------------------------------------------------------------------*/
#define  HWS_HOSTNAME        "HOSTNAME"           //
#define  HWS_MAX_HOSTNAME    250                  // PTM2303  This is the
                                                  // max allowed in the DAT
                                                  // file buffer for a fully
                                                  // qualified hostname.
#define  HWS_PORT            "PORT"               //
#define  HWS_MAX_PORT        4

#define  HWS_IMSNAME         "IMSNAME"            //
#define  HWS_MAX_IMSNAME     8

#define  HWS_RUNAME          "RUNAME"             //
#define  HWS_MAX_RUNAME      8

#define  HWS_LTERMOVER       "LTERMOVERRIDE"      // PTM2481
#define  HWS_MAX_LTERMOVER   8                    // PTM2481

#define  HWS_USERID          "USERID"             //
#define  HWS_MAX_USERID      8

#define  HWS_GROUP           "GROUP"              //
#define  HWS_MAX_GROUP       8

#define  HWS_PASSWORD        "PASSWORD"           //
#define  HWS_MAX_PASSWORD    8

#define  HWS_PASSDATATYPE    "PASSDATATYPE"       // PTM2338
#define  HWS_PDAT_PWTEXT     "PASSWORDTEXT"       // PTM2338
#define  HWS_PDAT_PWBIN      "PASSWORDBINARY"     // PTM2338

#define  HWS_SYNCLEVEL       "SYNCLEVEL"          //
#define  HWS_SYNC_NONE       "NONE"               //
#define  HWS_SYNC_CONFIRM    "CONFIRM"            //

#define  HWS_TRANTYPE        "TRANTYPE"           //
#define  HWS_TRAN_CONV       "CONVERSATION"       //
#define  HWS_TRAN_NONCONV    "NONCONVERSATION"    //

#define  HWS_CONNTYPE        "CONNTYPE"           //
#define  HWS_CONN_PERS       "PERSISTENT"         //
#define  HWS_CONN_NONPERS    "NONPERSISTENT"      //

#define  HWS_CONVID          "CONVID"             //
#define  HWS_MAX_CONVID      16

#define  HWS_CONVSTATE       "CONVSTATE"          //
#define  HWS_CONVS_INCONV    "INCONVERSATION"     //
#define  HWS_CONVS_NOTINCONV "NOTINCONVERSATION"  //

#define  HWS_REASONMSG       "REASONMSG"          //
#define  HWS_MAX_REASONMSG   100

#define  HWS_REASONDIAG      "REASONDIAG"         //
#define  HWS_MAX_REASONDIAG  500

#endif
