/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/
#ifndef HWSMFSF_HPP
#define HWSMFSF_HPP

#include "hwsmfs.hpp"

class HWSConverter;
class HWSDList;
class HWSError;

//  The HWSMFSFormat class inherits from the HWSMFSDesc class to inherit
//  all the information about the format set.
//  HWSMFSFormat enhances the parent class by providing methods to format
//  the messages.
class DllExport HWSMFSFormat: public HWSMFSDesc {

  // Public access
  public:

     // Member functions
     HWSMFSFormat();                // Constructor.
     ~HWSMFSFormat();               // Destructor.

     //  Returns the MOD, whose name is input, from the chain of default MODs.
     //  If the MOD by the specified name does not exist, NULL is returned.
     HWSMsgDesc *getDMODbyName(char *name);

     // Returns MID associated with LPage specified on input.
     HWSMsgDesc *getMIDbyLPageName( char *lpName );

     // Error code range:          1000-1099
     // Internal error code range: 9000-9099

     HWSDList  *formatIn( HWSError *errStruc, HWSDList *fldList, HWSConverter *cObj );
     HWSDList  *formatOut( HWSError *errStruc, HWSDList *segList );

     // Data members
     HWSMsgDesc    *firstDMOD;       // First default MOD in chain.

  private:

     HWSConverter *convObj;
};

#endif
