/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/
#ifndef HWSEFMTI_H
#define HWSEFMTI_H

/******************************************************************/
/* HWSMFSFormat Component Internal Error Definition               */
/* 9100 - 9119                                                    */
/******************************************************************/

#define  FMT_FIRST_MSG_FAILURE              9100
#define  FMT_FIRST_MSG_FAILURE_S            "HWSMFSFormat::formatIn>Format of first message failed."
#define  FIRST_MSG_FORMAT_MISSING           9101
#define  FIRST_MSG_FORMAT_MISSING_S         "HWSLMFSFormat::formatIn>First HWSMsgFormat object not found."
//#define  CONVERSION_OPEN_FAILURE            9102
//#define  CONVERSION_OPEN_FAILURE_S          "HWSLMFSFormat::formatIn>Failure to open conversion object."
//#define  OUT_CONVERSION_OPEN_FAILURE        9103
//#define  OUT_CONVERSION_OPEN_FAILURE_S      "HWSLMFSFormat::formatOut>Failure to open conversion object."
#define  SEGLIST_NOT_EMPTY                  9104
#define  SEGLIST_NOT_EMPTY_S                "HWSMFSFormat::formatOut>Input DList (segList) not empty at exit."
#define  NO_MOD_NAME                        9105
#define  NO_MOD_NAME_S                      "HWSMFSFormat::formatOut>Pointer to MOD name null in input DList."
#define  INVALID_INPUT_FORMATIN             9106
#define  INVALID_INPUT_FORMATIN_S           "HWSMFSFormat::formatIn>Null pointer or invalid language input to member function."
#define  INVALID_INPUT_FORMATOUT            9107
#define  INVALID_INPUT_FORMATOUT_S          "HWSMFSFormat::formatOut>Null pointer input to member function."
#define  OUTMSG_FORMAT_FAILED               9108
#define  OUTMSG_FORMAT_FAILED_S             "HWSMFSFormat::formatOut>formatOut for output message failed."

/******************************************************************/
/* HWSMsgFormat Component Inernal Error Definition               */
/* 9120 - 9139                                                    */
/******************************************************************/

#define  FMT_FIRST_LPG_FAILURE              9120
#define  FMT_FIRST_LPG_FAILURE_S            "HWSMsgFormat::formatIn>Format of first message failed."
#define  FIRST_LPG_FORMAT_MISSING           9121
#define  FIRST_LPG_FORMAT_MISSING_S         "HWSMsgFormat::formatIn>First HWSLPageFormat object not found."
#define  INVALID_GETLPAGE_INPUT             9122
#define  INVALID_GETLPAGE_INPUT_S           "HWSMsgFormat::getLpagebyCond>Null pointer passed as input."
#define  INVALID_FMT_OUTMSG_INPUT           9123
#define  INVALID_FMT_OUTMSG_INPUT_S         "HWSMsgFormat::formatOut>Null pointer passed as input."
#define  OUTMSG_LPAGE_NOT_FOUND             9124
#define  OUTMSG_LPAGE_NOT_FOUND_S           "HWSMsgFormat::formatOut>getLPagebyCOND failed or pointer null."
#define  OUTMSG_LPAGE_FMT_ERROR             9125
#define  OUTMSG_LPAGE_FMT_ERROR_S           "HWSMsgFormat::formatOut>Format of output LPage failed."
#define  INVALID_OUTMSG_DLIST               9126
#define  INVALID_OUTMSG_DLIST_S             "HWSMsgFormat::formatOut>No first segment LLData for message."
#define  INVALID_FMT_INMSG_INPUT            9127
#define  INVALID_FMT_INMSG_INPUT_S          "HWSMsgFormat::formatIn>Null pointer passed as input."
#define  IN_OPT3_NOT_SUPPORTED              9128
#define  IN_OPT3_NOT_SUPPORTED_S            "HWSMsgFormat::formatIn>Release does not support message option 3."
#define  OUT_OPT3_NOT_SUPPORTED             9129
#define  OUT_OPT3_NOT_SUPPORTED_S           "HWSMsgFormat::formatIn>Release does not support message option 3."

/******************************************************************/
/* HWSLpgFormat Component Internal Error Definition               */
/* 9140 - 9159                                                    */
/******************************************************************/

#define  FMT_FIRST_SEG_FAILURE              9140
#define  FMT_FIRST_SEG_FAILURE_S            "HWSLpageFormat::formatIn>Format of first segment failed."
#define  FMT_SEG_FAILURE                    9141
#define  FMT_SEG_FAILURE_S                  "HWSLPageFormat::formatIn>Format of subsequent segment failed."
#define  FIRST_SEG_FORMAT_MISSING           9142
#define  FIRST_SEG_FORMAT_MISSING_S         "HWSLPageFormat::formatIn>First HWSSegFormat object not found."
#define  BAD_LAST_LLDATA                    9143
#define  BAD_LAST_LLDATA_S                  "HWSLPageFormat::formatIn>Invalid pointer to last LLData object in DList."
#define  LPG_FLD_LIST_NOT_EMPTY             9144
#define  LPG_FLD_LIST_NOT_EMPTY_S           "HWSLPageFormat::formatIn>Input fldList should be empty on exit from formatIn."
#define  INVALID_FMT_OUTLPG_INPUT           9145
#define  INVALID_FMT_OUTLPG_INPUT_S         "HWSLPageFormat::formatOut>Null pointer passed as input."
#define  FMT_OUTLPG_SEG_FAILURE             9146
#define  FMT_OUTLPG_SEG_FAILURE_S           "HWSLPageFormat::formatOut>Format of segment failed."
#define  INVALID_TESTCOND_INPUT             9147
#define  INVALID_TESTCOND_INPUT_S           "HWSLPageFormat::testCond>Null pointer passed for one of input parameters."
#define  INVALID_CONDTYPE                   9148
#define  INVALID_CONDTYPE_S                 "HWSLPageFormat::testCond>Invalid CONTType for LPage."
#define  GETPTR_FAILURE                     9149
#define  GETPTR_FAILURE_S                   "HWSLPageFormat::testCond>getPtrInSegBufData failed for mfldname of COND=."
#define  INVALID_CONDOP                     9150
#define  INVALID_CONDOP_S                   "HWSLPageFormat::testCond>Invalid OPType for LPage COND=."
#define  TESTCOND_INVALID_CONV_LENGTH       9151
#define  TESTCOND_INVALID_CONV_LENGTH_S     "HWSLPageFormat::testCond>Invalid converted data length."
#define  INVALID_PP_FOR_CONDTYPE            9152
#define  INVALID_PP_FOR_CONDTYPE_S          "HWSLPageFormat::testCond>MFLD name only but non-zero pp value."
#define  TESTCOND_INVALID_COND              9153
#define  TESTCOND_INVALID_COND_S            "HWSLPageFormat::testCond>No literal for condition."

/******************************************************************/
/* HWSSegFormat Component Internal Error Definition               */
/* 9160 - 9179                                                    */
/******************************************************************/

#define  FMT_FIRST_FIELD_FAILURE            9160
#define  FMT_FIRST_FIELD_FAILURE_S          "HWSSegFormat::formatIn>Format of first field failed."
#define  FMT_FIELD_FAILURE                  9161
#define  FMT_FIELD_FAILURE_S                "HWSSegFormat::formatIn>Format of subsequent field failed."
#define  FIRST_FIELD_FORMAT_MISSING         9162
#define  FIRST_FIELD_FORMAT_MISSING_S       "HWSSegFormat::formatIn>First HWSFldFormat object not found."
#define  INVALID_FMT_OUTSEG_INPUT           9163
#define  INVALID_FMT_OUTSEG_INPUT_S         "HWSSegFormat::formatOut>Null pointer passed as input."
#define  INVALID_OUTSEG_LLDATA              9164
#define  INVALID_OUTSEG_LLDATA_S            "HWSSegFormat::formatOut>LLData object for segment contains invalid data."
#define  FMT_OUTSEG_FIELD_FAILURE           9165
#define  FMT_OUTSEG_FIELD_FAILURE_S         "HWSSegFormat::formatOut>HWSFldFormat::formatOut failed for field of segment."
#define  UNEXPECTED_END_OF_SEGS             9166
#define  UNEXPECTED_END_OF_SEGS_S           "HWSSegFormat::formatOut>LLData object for segment not found in DList."
#define  INVALID_GETPTR_INPUT               9167
#define  INVALID_GETPTR_INPUT_S             "HWSSegFormat::getFldData>Null pointer passed for one of input parameters."
#define  INVALID_GETPTR_LLDATA              9168
#define  INVALID_GETPTR_LLDATA_S            "HWSSegFormat::getFldData>The input segment LLData object is invalid."
#define  INVALID_COND_FLD                   9169
#define  INVALID_COND_FLD_S                 "HWSSegFormat::getFldData>SCA output fields not supported with LPage COND=."
#define  INVALID_PP                         9170
#define  INVALID_PP_S                       "HWSSegFormat::getFldData>Invalid pp passed to getFldData."

/******************************************************************/
/* HWSFldFormat Component Internal Error Definition               */
/* 9180 - 9199                                                    */
/******************************************************************/

#define  DATA_AND_FLDLIT                    9180
#define  DATA_AND_FLDLIT_S                  "HWSFldFormat::getInData>Have both field literal and field data."
#define  FLDLIT_BUT_NOLIT                   9181
#define  FLDLIT_BUT_NOLIT_S                 "HWSFldFormat::getInData>Have field literal but no literal."
#define  INVALID_IN_FLDTYPE                 9182
#define  INVALID_IN_FLDTYPE_S               "HWSFldFormat::getInData>Invalid input fldType."
#define  INCONSISTENT_FLD_INPUT             9183
#define  INCONSISTENT_FLD_INPUT_S           "HWSFldFormat::formatIn>HWSFldDesc object doesn't match input fld object."
#define  INVALID_FILLTYPE                   9184
#define  INVALID_FILLTYPE_S                 "HWSFldFormat::formatIn>Invalid FILLType."
#define  INVALID_CONV_LENGTH                9185
#define  INVALID_CONV_LENGTH_S              "HWSFldFormat::formatIn>Invalid converted data length."
#define  INVALID_JUSTTYPE                   9186
#define  INVALID_JUSTTYPE_S                 "HWSFldFormat::formatIn>Invalid JUSTType."
#define  INVALID_OUT_FLDTYPE                9187
#define  INVALID_OUT_FLDTYPE_S              "HWSFldFormat::getOutData>Invalid output fldType."
#define  OUT_MSGFLD_NODATA                  9188
#define  OUT_MSGFLD_NODATA_S                "HWSFldFormat::getOutData>length 0 in HWSFldFormat object for STANDARD field."
#define  ATTRLEN_EXCEED_FLDLEN              9189
#define  ATTRLEN_EXCEED_FLDLEN_S            "HWSFldFormat::getOutData>Length of attribute bytes exceeds field length."
#define  INVALID_OUT_CONV_LENGTH            9190
#define  INVALID_OUT_CONV_LENGTH_S          "HWSFldFormat::formatOut>Invalid converted data length."
#define  INVALID_TIME_LENGTH                9191
#define  INVALID_TIME_LENGTH_S              "HWSFldFormat::getOutData>Length of field NE length of TIME system literal."
#define  INVALID_DATE1_LENGTH               9192
#define  INVALID_DATE1_LENGTH_S             "HWSFldFormat::getOutData>Length of field NE length of DATE1 system literal."
#define  INVALID_DATE2_LENGTH               9193
#define  INVALID_DATE2_LENGTH_S             "HWSFldFormat::getOutData>Length of field NE length of DATE2 system literal."
#define  INVALID_DATE3_LENGTH               9194
#define  INVALID_DATE3_LENGTH_S             "HWSFldFormat::getOutData>Length of field NE length of DATE3 system literal."
#define  INVALID_DATE4_LENGTH               9195
#define  INVALID_DATE4_LENGTH_S             "HWSFldFormat::getOutData>Length of field NE length of DATE4 system literal."
#define  INVALID_DATA_LITERAL_LENGTH        9196
#define  INVALID_DATA_LITERAL_LENGTH_S      "HWSFldFormat::getOutData>Length of field NE length of DATE4 system literal."
#define  INVALID_OUT_FILLTYPE               9197
#define  INVALID_OUT_FILLTYPE_S             "HWSFldFormat::formatOut>Invalid MSG FILLType."
#define  INVALID_OUT_JUSTTYPE               9198
#define  INVALID_OUT_JUSTTYPE_S             "HWSFldFormat::formatOut>Invalid JUSTType."

#endif
