/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

#ifndef HWSCNVTR_H
#define HWSCNVTR_H

/*--------------------------------------------------------------------*/
/* Include file for class HWSConverter.                               */
/*--------------------------------------------------------------------*/
typedef enum  { HWS_CLIENT2IMS,          /* IMSClient to Host IMS.    */
                HWS_IMS2CLIENT           /* Host IMS to IMSClient.    */
              } HWSDirection;            /* Direction of conversion.  */

/*--------------------------------------------------------------------*/
/* Supported conversions.                                             */
/*                                                                    */
/* Note: To add a new language, add a new enum symbol at the END of   */
/*       the HWSCnvsn enum, but before LASTLANG.  At the same time,   */
/*       initialize the corresponding entry in the LNG table in       */
/*       the constructor for the HWSConverter class (HWSCnvsn.cpp).   */
/*                                                                    */
/* 03-9-98 ckt @2263  - add additional languages support              */
/*                                                                    */
/*--------------------------------------------------------------------*/
typedef enum  {HWS_BAD_CNVSN,             /* Invalid conversion type. */
               HWS_ASCIIASCII,            /* No conversion.           */
               HWS_USENGLISH,             /* U.S. English.            */
               HWS_LATIN1,                /* Latin1 languages.        */
               HWS_LATIN2,                /* Latin1 languages.        */
               HWS_HEBREW,                /* Hebrew.                  */
               HWS_TURKISH,               /* Turkish.                 */
               HWS_GERMAN,                /* German              @2263*/ 
               HWS_DEN_NRWAY,             /* Denmark/Norway      @2263*/ 
               HWS_FIN_SWDN,              /* Finland/Sweden      @2263*/ 
               HWS_ITALIAN,               /* Italian             @2263*/ 
               HWS_SPANISH,               /* Spanish             @2263*/ 
               HWS_UKENGLISH,             /* UK English          @2263*/ 
               HWS_FRENCH,                /* French              @2263*/ 
               HWS_ICELANDIC,             /* Iceland             @2263*/ 
//             HWS_JAPANLATIN,            /* Japanese-Latin1.         */
//             HWS_JAPANKATA,             /* Japanese-Katakana.       */
//             HWS_KOREAN,                /* Korean.                  */
               HWS_LASTLANG               /* LAST DELIMETER           */
                           } HWSCnvsn;

/*--------------------------------------------------------------------*/
/* Defines for byte ordering for numeric data types.                  */
/*--------------------------------------------------------------------*/
#define  HWS_INTEL_ENDIAN         0x0001
#define  HWS_RISC_ENDIAN          0x0002
#define  HWS_SPARC_ENDIAN         0x0002
#define  HWS_S370_ENDIAN          0x0002

/*--------------------------------------------------------------------*/
/* Miscellaneous defines.                                             */
/*--------------------------------------------------------------------*/
#define  ZERO                      0
#define  NUM_CHAR                  1
#define  MAX_LEN                   13
#define  RANGE_NUM                 4

#define  SO                        0x0E
#define  SI                        0x0F
#define  DBCS_LEN                  2
#define  FST_BYTE                  0
#define  SND_BYTE                  1

/* Conversion methods.                                                */
#define  PURESBCS                  1
#define  PUREDBCS                  2
#define  HOSTTOPCMIXED             3
#define  PCTOHOSTMIXED             4

/*--------------------------------------------------------------------*/
/* Structures.                                                        */
/*--------------------------------------------------------------------*/
struct TconvIDTable
{
   unsigned short fromCCSID; /* From CCSID  (source)                 */
   unsigned short toCCSID;   /* To   CCSID  (target)                 */
   unsigned short conversionMethod; /*Conversion Method indicator    */
   char dtbl[MAX_LEN];       /* DBCS Conversion Table file name      */
   unsigned long dsize;      /* DBCS Conversion Table file size      */
   char stbl[MAX_LEN];       /* SBCS Conversion Table file name      */
   unsigned long ssize;      /* SBCS Conversion Table file size      */
   char htbl[MAX_LEN];       /* Header Table file name               */
   unsigned long hsize;      /* Header Table file size               */
};

struct TconvTableInfo
{
   unsigned long cvid;   /* Conversion ID                            */
   char * PBDTbl;        /* Pointer to DBCS table buffer             */
   char * PBSTbl;        /* Pointer to SBCS table buffer             */
   char * PBHTbl;        /* Pointer to Header table buffer           */
};

typedef struct lngStructure {
   char          *langStr;          /* Language string.               */
   char          *langTbl;          /* Name of file containing        */
                                    /* conversion information.        */
   int           hostCCSID;         /* CCSID for host user data.      */
   int           servCCSID;         /* CCSID for server user data.    */
   int           ctlHostCCSID;      /* CCSID for host control data.   */
   int           ctlServCCSID;      /* CCSID for server control data. */
   char          *dbcsBlank;        /* Double byte blank.             */
}  lng;

#endif
