/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.RGBImageFilter;
import java.util.ResourceBundle;
import symantec.itools.resources.ErrorsBundle;
import symantec.itools.util.GeneralUtils;

public class LightenFilter
extends RGBImageFilter {
    protected double percent;
    protected transient ResourceBundle errors;

    public LightenFilter() {
        this(0.5);
    }

    public LightenFilter(double percent) {
        try {
            this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        }
        catch (Throwable throwable) {
            this.errors = new ErrorsBundle();
        }
        this.canFilterIndexColorModel = true;
        try {
            this.setPercent(percent);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] args = new Object[]{new Double(percent)};
            System.err.println("LightenFilter: " + this.errors.getString("InvalidPercent1"));
            System.err.println("     " + this.errors.getString("InvalidPercent2"));
            System.err.println("     " + this.errors.getString("InvalidPercent3"));
            try {
                this.setPercent(0.5);
            }
            catch (IllegalArgumentException illegalArgumentException2) {}
        }
    }

    public void setPercent(double percent) throws IllegalArgumentException {
        GeneralUtils.checkValidPercent(percent);
        this.percent = percent;
    }

    public double getPercent() {
        return this.percent;
    }

    public int filterRGB(int x, int y, int rgb) {
        DirectColorModel cm = (DirectColorModel)ColorModel.getRGBdefault();
        int alpha = cm.getAlpha(rgb);
        int red = cm.getRed(rgb);
        int green = cm.getGreen(rgb);
        int blue = cm.getBlue(rgb);
        red += (int)((double)(255 - red) * this.percent);
        green += (int)((double)(255 - green) * this.percent);
        blue += (int)((double)(255 - blue) * this.percent);
        return (alpha <<= 24) | (red <<= 16) | (green <<= 8) | blue;
    }
}

