/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import symantec.itools.awt.SimpleWizardController;
import symantec.itools.awt.WizardController;
import symantec.itools.awt.WizardInterface;
import symantec.itools.awt.shape.HorizontalLine;

public class Wizard
extends Panel
implements WizardInterface,
Serializable {
    private WizardController controller;
    private boolean controllerPrepared = false;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private Vector vPages;
    private int curIndex = -1;
    private Component userComponent;
    private Action action;
    private Mouse mouse;
    protected Panel panel1;
    protected HorizontalLine horizontalLine1;
    protected Panel panel2;
    protected Panel panel3;
    protected Panel panel4;
    protected Button previousButton;
    protected Button nextButton;
    protected Button finishButton;
    protected Button cancelButton;
    protected Button helpButton;
    private boolean helpButtonVisible = true;
    private boolean combinedButton = false;
    private Vector actionListeners;
    protected static final String PREVIOUS_LABEL = "< Back";
    protected static final String NEXT_LABEL = "Next >";
    protected static final String FINISH_LABEL = "Finish";
    protected static final String CANCEL_LABEL = "Cancel";
    protected static final String HELP_LABEL = "Help";
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;

    public Wizard() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        super.setLayout(gridBagLayout);
        this.panel1 = new Panel();
        this.panel1.setLayout(null);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)super.getLayout()).setConstraints(this.panel1, gbc);
        super.add(this.panel1);
        this.horizontalLine1 = new HorizontalLine();
        try {
            this.horizontalLine1.setBevelStyle(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)super.getLayout()).setConstraints(this.horizontalLine1, gbc);
        super.add(this.horizontalLine1);
        this.panel2 = new Panel();
        this.panel2.setLayout(new FlowLayout(2, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)super.getLayout()).setConstraints(this.panel2, gbc);
        super.add(this.panel2);
        this.panel3 = new Panel();
        this.panel3.setLayout(new GridLayout());
        this.panel2.add(this.panel3);
        this.previousButton = new Button();
        this.previousButton.setActionCommand("button");
        this.previousButton.setLabel(PREVIOUS_LABEL);
        this.previousButton.setEnabled(false);
        this.panel3.add(this.previousButton);
        this.nextButton = new Button();
        this.nextButton.setActionCommand("button");
        this.nextButton.setLabel(NEXT_LABEL);
        this.nextButton.setEnabled(false);
        this.panel3.add(this.nextButton);
        this.finishButton = new Button();
        this.finishButton.setActionCommand("button");
        this.finishButton.setLabel(FINISH_LABEL);
        this.finishButton.setEnabled(false);
        this.panel3.add(this.finishButton);
        this.panel4 = new Panel();
        this.panel4.setLayout(new GridLayout(1, 2, 6, 0));
        this.panel2.add(this.panel4);
        this.cancelButton = new Button();
        this.cancelButton.setActionCommand("button");
        this.cancelButton.setLabel(CANCEL_LABEL);
        if (Beans.isDesignTime()) {
            this.cancelButton.setEnabled(false);
        }
        this.panel4.add(this.cancelButton);
        this.helpButton = new Button();
        this.helpButton.setActionCommand("button");
        this.helpButton.setLabel(HELP_LABEL);
        if (Beans.isDesignTime()) {
            this.helpButton.setEnabled(false);
        }
        this.panel4.add(this.helpButton);
        this.vPages = new Vector();
        this.actionListeners = new Vector();
        this.controller = new SimpleWizardController(this);
    }

    public void setWizardController(WizardController controller) {
        WizardController oldController = this.controller;
        this.controller = controller;
        if (this.controllerPrepared) {
            oldController.doCancel();
            this.controllerPrepared = false;
            this.initiateController(this.userComponent);
        }
        this.updateButtonsState();
    }

    private void initiateController(Component comp) {
        if (!this.controllerPrepared) {
            this.controller.doPrepare();
            this.controllerPrepared = true;
            this.controller.resetChainInfo();
            this.controller.preparePage(comp, 1);
            this.showPage(comp);
            this.curIndex = 0;
            this.controller.pageShown(comp);
        }
    }

    public void restart() {
        if (this.controllerPrepared) {
            this.controller.doCancel();
            this.controllerPrepared = false;
        }
        this.initiateController(this.getComponentAt(0));
    }

    public WizardController getWizardController() {
        return this.controller;
    }

    public int getSelectedIndex() {
        return this.curIndex;
    }

    public synchronized void setComponentAt(int index, Component comp) throws PropertyVetoException {
        if (!this.isIndexValid(index)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        Component oldPage = this.getComponentAt(index);
        this.vetos.fireVetoableChange("ComponentAt", oldPage, comp);
        this.vPages.setElementAt(comp, index);
        if (index == this.curIndex) {
            this.hidePage();
            this.showPage(comp);
        }
        this.changes.firePropertyChange("ComponentAt", oldPage, comp);
    }

    public synchronized Component getComponentAt(int index) {
        if (!this.isIndexValid(index)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (Component)this.vPages.elementAt(index);
    }

    public synchronized void setHelpButtonVisible(boolean visible) throws PropertyVetoException {
        if (visible == this.helpButtonVisible) {
            return;
        }
        Boolean oldvalue = new Boolean(this.helpButtonVisible);
        Boolean newvalue = new Boolean(visible);
        this.vetos.fireVetoableChange("HelpButtonVisible", oldvalue, newvalue);
        if (visible && !this.helpButtonVisible) {
            this.panel4.add(this.helpButton);
            this.helpButtonVisible = true;
        } else if (!visible && this.helpButtonVisible) {
            this.panel4.remove(this.helpButton);
            this.helpButtonVisible = false;
        }
        this.changes.firePropertyChange("HelpButtonVisible", oldvalue, newvalue);
    }

    public boolean isHelpButtonVisible() {
        return this.helpButtonVisible;
    }

    public synchronized void setCombinedButton(boolean combined) throws PropertyVetoException {
        if (combined == this.combinedButton) {
            return;
        }
        Boolean oldvalue = new Boolean(this.combinedButton);
        Boolean newvalue = new Boolean(combined);
        this.vetos.fireVetoableChange("combinedButton", oldvalue, newvalue);
        if (combined && !this.combinedButton) {
            this.panel3.remove(this.finishButton);
            this.combinedButton = true;
        } else if (!combined && this.combinedButton) {
            this.panel3.add(this.finishButton);
            this.combinedButton = false;
        }
        this.changes.firePropertyChange("combinedButton", oldvalue, newvalue);
    }

    public boolean isCombinedButton() {
        return this.combinedButton;
    }

    public synchronized void setButtonsAlignment(int align) throws PropertyVetoException {
        if (align != 0 && align != 1 && align != 2) {
            throw new IllegalArgumentException();
        }
        Integer oldvalue = new Integer(this.getButtonsAlignment());
        Integer newvalue = new Integer(align);
        this.vetos.fireVetoableChange("buttonsAlignment", oldvalue, newvalue);
        ((FlowLayout)this.panel2.getLayout()).setAlignment(align);
        this.panel2.invalidate();
        this.changes.firePropertyChange("buttonsAlignment", oldvalue, newvalue);
    }

    public int getButtonsAlignment() {
        return ((FlowLayout)this.panel2.getLayout()).getAlignment();
    }

    public synchronized int getPageIndex(Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        return this.vPages.indexOf(comp);
    }

    private void showPageAt(int index) {
        if (!this.isIndexValid(index)) {
            return;
        }
        if (index != this.curIndex) {
            this.hidePage();
            this.showPage(this.getComponentAt(index));
            this.curIndex = index;
        }
    }

    private void hidePage() {
        if (this.userComponent != null) {
            this.userComponent.hide();
            this.userComponent = null;
        }
    }

    private void showPage(Component comp) {
        this.userComponent = comp;
        if (this.userComponent != null) {
            Component[] comps = this.panel1.getComponents();
            int l = comps.length;
            int x = 0;
            while (x < l) {
                if (comps[x] == this.userComponent) break;
                ++x;
            }
            if (x == l) {
                this.panel1.add(this.userComponent, -1);
            }
            this.userComponent.show();
            this.userComponent.requestFocus();
            this.validate();
        }
    }

    private boolean isIndexValid(int index) {
        return index >= 0 && index < this.getPageCount();
    }

    public synchronized void removePageAt(int index) {
        if (!this.isIndexValid(index)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int oldSize = this.getPageCount();
        if (index == this.curIndex) {
            if (this.getPageCount() == 1) {
                if (this.userComponent != null) {
                    this.userComponent.hide();
                }
                this.curIndex = -1;
                if (this.controllerPrepared) {
                    this.controller.doCancel();
                    this.controllerPrepared = false;
                }
            } else if (this.curIndex == this.getPageCount() - 1) {
                this.showPageAt(this.curIndex - 1);
            } else {
                this.showPageAt(this.curIndex + 1);
            }
        }
        Component p = this.getComponentAt(index);
        this.panel1.remove(p);
        this.vPages.removeElementAt(index);
        if (this.curIndex != -1 && index < this.curIndex) {
            --this.curIndex;
        }
        this.updateButtonsState();
        int newSize = this.getPageCount();
        this.changes.firePropertyChange("PageCount", new Integer(oldSize), new Integer(newSize));
    }

    public synchronized void removeAllPages() {
        if (this.userComponent != null) {
            this.userComponent.hide();
        }
        this.userComponent = null;
        this.vPages = new Vector();
        this.curIndex = -1;
        if (this.controllerPrepared) {
            this.controller.doCancel();
            this.controllerPrepared = false;
        }
        this.panel1.removeAll();
        this.updateButtonsState();
    }

    public int getPageCount() {
        return this.vPages.size();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.addElement(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.removeElement(l);
    }

    private void fireActionEvent(String command) {
        ActionEvent event = new ActionEvent(this, 0, command);
        Enumeration e = this.actionListeners.elements();
        while (e.hasMoreElements()) {
            ActionListener l = (ActionListener)e.nextElement();
            l.actionPerformed(event);
        }
    }

    public Component add(Component comp) {
        return this.add(comp, -1);
    }

    public synchronized Component add(Component comp, int pos) {
        int index;
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.getPageCount();
        if (pos == -1) {
            index = this.getPageCount();
            this.vPages.addElement(comp);
        } else {
            index = pos;
            this.vPages.insertElementAt(comp, index);
        }
        if (this.curIndex != -1 && index <= this.curIndex) {
            ++this.curIndex;
        }
        if (Beans.isDesignTime()) {
            this.showPageAt(index);
        } else if (!this.controllerPrepared) {
            this.initiateController(comp);
        }
        this.updateButtonsState();
        int newSize = this.getPageCount();
        this.changes.firePropertyChange("PageCount", new Integer(oldSize), new Integer(newSize));
        return comp;
    }

    public Component add(String name, Component comp) {
        return comp;
    }

    public synchronized void remove(Component comp) {
        if (comp == null) {
            return;
        }
        this.removePageAt(this.getPageIndex(comp));
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return super.getMinimumSize();
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null && Beans.isDesignTime()) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.action == null) {
            this.action = new Action();
            this.previousButton.addActionListener(this.action);
            this.nextButton.addActionListener(this.action);
            this.finishButton.addActionListener(this.action);
            this.cancelButton.addActionListener(this.action);
            this.helpButton.addActionListener(this.action);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.action != null) {
            this.previousButton.removeActionListener(this.action);
            this.nextButton.removeActionListener(this.action);
            this.finishButton.removeActionListener(this.action);
            this.cancelButton.removeActionListener(this.action);
            this.helpButton.removeActionListener(this.action);
            this.action = null;
        }
        super.removeNotify();
    }

    public void setLayout(LayoutManager mgr) {
    }

    public LayoutManager getLayout() {
        return null;
    }

    public void layout() {
        super.layout();
        Rectangle r = this.panel1.getBounds();
        if (this.userComponent != null) {
            this.userComponent.setBounds(0, 0, r.width, r.height);
        }
    }

    public void doFinish() {
        Component source;
        Component component = source = this.curIndex != -1 ? this.getComponentAt(this.curIndex) : null;
        if (source == null) {
            return;
        }
        if (this.controller.validatePage(source, null, 2)) {
            this.controller.doFinish();
            this.controllerPrepared = false;
            this.fireActionEvent(FINISH_LABEL);
        }
    }

    public void doCancel() {
        Component source;
        Component component = source = this.curIndex != -1 ? this.getComponentAt(this.curIndex) : null;
        if (source == null) {
            return;
        }
        if (this.controller.validatePage(source, null, 3)) {
            this.controller.doCancel();
            this.controllerPrepared = false;
            this.fireActionEvent(CANCEL_LABEL);
        }
    }

    public void doHelp() {
        Component source;
        Component component = source = this.curIndex != -1 ? this.getComponentAt(this.curIndex) : null;
        if (source == null) {
            return;
        }
        if (this.controller.validatePage(source, null, 4)) {
            this.controller.doHelp();
            this.fireActionEvent(HELP_LABEL);
        }
    }

    public void setPreviousPageIndex(int index) {
        this.controller.setPreviousPageIndex(index);
    }

    public void setNextPageIndex(int index) {
        this.controller.setNextPageIndex(index);
    }

    public void setPreviousPage(Component comp) {
        this.controller.setPreviousPage(comp);
    }

    public void setNextPage(Component comp) {
        this.controller.setNextPage(comp);
    }

    public synchronized void goPrevious() {
        Component source = this.curIndex != -1 ? this.getComponentAt(this.curIndex) : null;
        Component target = this.controller.getPreviousPage();
        int index = this.getPageIndex(target);
        if (this.curIndex != -1 && !this.controller.validatePage(source, target, 0)) {
            return;
        }
        target = this.controller.getPreviousPage();
        if (target == null) {
            return;
        }
        index = this.getPageIndex(target);
        if (this.curIndex != -1) {
            this.hidePage();
            this.controller.pageHidden(source);
        }
        this.controller.resetChainInfo();
        this.controller.preparePage(target, 0);
        this.showPage(target);
        this.curIndex = index;
        this.controller.pageShown(target);
        this.updateButtonsState();
    }

    public synchronized void goNext() {
        Component source = this.curIndex != -1 ? this.getComponentAt(this.curIndex) : null;
        Component target = this.controller.getNextPage();
        int index = this.getPageIndex(target);
        if (this.curIndex != -1 && !this.controller.validatePage(source, target, 1)) {
            return;
        }
        target = this.controller.getNextPage();
        if (target == null) {
            return;
        }
        index = this.getPageIndex(target);
        if (this.curIndex != -1) {
            this.hidePage();
            this.controller.pageHidden(source);
        }
        this.controller.resetChainInfo();
        this.controller.preparePage(target, 1);
        this.showPage(target);
        this.curIndex = index;
        this.controller.pageShown(target);
        this.updateButtonsState();
    }

    public synchronized void updateButtonsState() {
        this.previousButton.setEnabled(this.controller.isPreviousEnabled());
        if (this.combinedButton) {
            this.updateCombinedButton();
        } else {
            this.nextButton.setEnabled(this.controller.isNextEnabled());
            this.finishButton.setEnabled(this.controller.isFinishEnabled());
        }
        this.cancelButton.setEnabled(this.controller.isCancelEnabled());
        this.helpButton.setEnabled(this.controller.isHelpEnabled());
    }

    private void updateCombinedButton() {
        String ntext = NEXT_LABEL;
        boolean nstatus = true;
        boolean nextEnabled = this.controller.isNextEnabled();
        boolean finishEnabled = this.controller.isFinishEnabled();
        if (!nextEnabled && !finishEnabled) {
            nstatus = false;
        } else if (!nextEnabled && finishEnabled) {
            ntext = FINISH_LABEL;
        }
        this.nextButton.setLabel(ntext);
        this.nextButton.setEnabled(nstatus);
    }

    public void setPreviousEnabled(boolean status) {
        this.controller.setPreviousEnabled(status);
    }

    public void setNextEnabled(boolean status) {
        this.controller.setNextEnabled(status);
    }

    public void setFinishEnabled(boolean status) {
        this.controller.setFinishEnabled(status);
    }

    public void setCancelEnabled(boolean status) {
        this.controller.setCancelEnabled(status);
    }

    public void setHelpEnabled(boolean status) {
        this.controller.setHelpEnabled(status);
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent e) {
            Component c = Wizard.this.getComponentAt(e.getPoint());
            if (c == Wizard.this.panel2) {
                e.translatePoint(-Wizard.this.panel2.getLocation().x, -Wizard.this.panel2.getLocation().y);
                c = Wizard.this.panel2.getComponentAt(e.getPoint());
                if (c == Wizard.this.panel3) {
                    e.translatePoint(-Wizard.this.panel3.getLocation().x, -Wizard.this.panel3.getLocation().y);
                    c = Wizard.this.panel3.getComponentAt(e.getPoint());
                    if (c == Wizard.this.previousButton) {
                        Wizard.this.goPrevious();
                    } else if (c == Wizard.this.nextButton) {
                        Wizard.this.goNext();
                    }
                } else if (c == Wizard.this.panel4) {
                    e.translatePoint(-Wizard.this.panel4.getLocation().x, -Wizard.this.panel4.getLocation().y);
                    c = Wizard.this.panel4.getComponentAt(e.getPoint());
                }
            }
        }

        Mouse() {
            Wizard.this = Wizard.this;
        }
    }

    class Action
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == Wizard.this.previousButton) {
                Wizard.this.goPrevious();
            } else if (!(o != Wizard.this.nextButton || Wizard.this.combinedButton && Wizard.this.controller.isFinishEnabled())) {
                Wizard.this.goNext();
            } else if (o == Wizard.this.finishButton || o == Wizard.this.nextButton && Wizard.this.combinedButton && Wizard.this.controller.isFinishEnabled()) {
                Wizard.this.doFinish();
            } else if (o == Wizard.this.cancelButton) {
                Wizard.this.doCancel();
            } else if (o == Wizard.this.helpButton) {
                Wizard.this.doHelp();
            }
        }

        Action() {
            Wizard.this = Wizard.this;
        }
    }
}

