/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;

public class RollOverButton
extends Component {
    protected transient Image standardImage = null;
    protected transient Image overImage = null;
    protected transient Image downImage = null;
    protected String standardFileName = null;
    protected String overFileName = null;
    protected String downFileName = null;
    protected String frame = null;
    protected URL standardURL = null;
    protected URL overURL = null;
    protected URL downURL = null;
    protected URL linkURL = null;
    protected boolean isCenterMode = true;
    protected transient boolean isMouseOver = false;
    protected boolean isClearFrame = false;
    protected transient boolean isPressed = false;
    protected transient boolean isMouseDrag = false;
    protected transient AppletContext context;
    String actionCommand;
    ActionListener actionListener;
    private Mouse mouse;
    private MouseMtn mouseMotion;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public RollOverButton() {
    }

    public RollOverButton(String standard, String over, String down) throws MalformedURLException {
        this();
        try {
            this.setStandardFileName(standard);
            this.setOverFileName(over);
            this.setDownFileName(down);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public RollOverButton(URL standard, URL over, URL down) {
        this();
        try {
            this.setStandardURL(standard);
            this.setOverURL(over);
            this.setDownURL(down);
        }
        catch (PropertyVetoException propertyVetoException) {
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public RollOverButton(Image standard, Image over, Image down) {
        this();
        try {
            this.setStandardImage(standard);
            this.setOverImage(over);
            this.setDownImage(down);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public void setStandardFileName(String str) throws MalformedURLException, PropertyVetoException {
        if (!(this.standardFileName == str || this.standardFileName != null && this.standardFileName.equals(str))) {
            String oldValue = this.standardFileName;
            this.vetos.fireVetoableChange("StandardFileName", oldValue, str);
            this.standardFileName = str;
            if (this.standardFileName == null) {
                this.setStandardURL(null);
            } else {
                this.setStandardURL(new URL(this.standardFileName));
            }
            this.setStandardURL(new URL(this.standardFileName));
            this.changes.firePropertyChange("StandardFileName", oldValue, str);
        }
    }

    public String getStandardFileName() {
        return this.standardFileName;
    }

    public void setOverFileName(String str) throws MalformedURLException, PropertyVetoException {
        if (!(this.overFileName == str || this.overFileName != null && this.overFileName.equals(str))) {
            String oldValue = this.overFileName;
            this.vetos.fireVetoableChange("OverFileName", oldValue, str);
            this.overFileName = str;
            if (this.overFileName == null) {
                this.setOverURL(null);
            } else {
                this.setOverURL(new URL(this.overFileName));
            }
            this.changes.firePropertyChange("OverFileName", oldValue, str);
        }
    }

    public String getOverFileName() {
        return this.overFileName;
    }

    public void setDownFileName(String str) throws MalformedURLException, PropertyVetoException {
        if (!(this.downFileName == str || this.downFileName != null && this.downFileName.equals(str))) {
            String oldValue = this.downFileName;
            this.vetos.fireVetoableChange("DownFileName", oldValue, str);
            this.downFileName = str;
            if (this.downFileName == null) {
                this.setDownURL(null);
            } else {
                this.setDownURL(new URL(this.downFileName));
            }
            this.changes.firePropertyChange("DownFileName", oldValue, str);
        }
    }

    public String getDownFileName() {
        return this.downFileName;
    }

    public void setStandardURL(URL aUrl) throws MalformedURLException, PropertyVetoException {
        if (this.standardURL == null || !this.standardURL.equals(aUrl)) {
            URL oldValue = this.standardURL;
            this.vetos.fireVetoableChange("StandardURL", oldValue, aUrl);
            this.standardURL = aUrl;
            this.standardFileName = null;
            Image loadedImage = null;
            if (aUrl != null) {
                loadedImage = this.getToolkit().getImage(aUrl);
            }
            this.setStandardImage(loadedImage);
            this.repaint();
            this.changes.firePropertyChange("StandardURL", oldValue, aUrl);
        }
    }

    public URL getStandardURL() {
        return this.standardURL;
    }

    public void setOverURL(URL aUrl) throws MalformedURLException, PropertyVetoException {
        if (this.overURL == null || !this.overURL.equals(aUrl)) {
            URL oldValue = this.overURL;
            this.vetos.fireVetoableChange("OverURL", oldValue, aUrl);
            this.overURL = aUrl;
            Image loadedImage = null;
            if (aUrl != null) {
                loadedImage = this.getToolkit().getImage(aUrl);
            }
            this.setOverImage(loadedImage);
            this.repaint();
            this.changes.firePropertyChange("OverURL", oldValue, aUrl);
        }
    }

    public URL getOverURL() {
        return this.overURL;
    }

    public void setDownURL(URL aUrl) throws MalformedURLException, PropertyVetoException {
        if (this.downURL == null || !this.downURL.equals(aUrl)) {
            URL oldValue = this.downURL;
            this.vetos.fireVetoableChange("DownURL", oldValue, aUrl);
            this.downURL = aUrl;
            Image loadedImage = null;
            if (aUrl != null) {
                loadedImage = this.getToolkit().getImage(aUrl);
            }
            this.setDownImage(loadedImage);
            this.repaint();
            this.changes.firePropertyChange("DownURL", oldValue, aUrl);
        }
    }

    public URL getDownURL() {
        return this.downURL;
    }

    public void setStandardImage(Image img) throws PropertyVetoException {
        if (this.standardImage == null || !this.standardImage.equals(img)) {
            Image oldValue = this.standardImage;
            this.vetos.fireVetoableChange("StandardImage", oldValue, img);
            this.standardImage = img;
            this.setImageHelper(this.standardImage);
            this.changes.firePropertyChange("StandardImage", oldValue, img);
        }
    }

    public Image getStandardImage() {
        return this.standardImage;
    }

    public void setOverImage(Image img) throws PropertyVetoException {
        if (this.overImage == null || !this.overImage.equals(img)) {
            Image oldValue = this.overImage;
            this.vetos.fireVetoableChange("OverImage", oldValue, img);
            this.overImage = img;
            this.setImageHelper(this.overImage);
            this.changes.firePropertyChange("OverImage", oldValue, img);
        }
    }

    public Image getOverImage() {
        return this.overImage;
    }

    public void setDownImage(Image img) throws PropertyVetoException {
        if (this.downImage == null || !this.downImage.equals(img)) {
            Image oldValue = this.downImage;
            this.vetos.fireVetoableChange("DownImage", oldValue, img);
            this.downImage = img;
            this.setImageHelper(this.downImage);
            this.changes.firePropertyChange("DownImage", oldValue, img);
        }
    }

    public Image getDownImage() {
        return this.downImage;
    }

    public void setClearFrame(boolean b) throws PropertyVetoException {
        Boolean oldValue = new Boolean(this.isClearFrame);
        Boolean newValue = new Boolean(b);
        this.vetos.fireVetoableChange("ClearFrame", oldValue, newValue);
        this.isClearFrame = b;
        this.changes.firePropertyChange("ClearFrame", oldValue, newValue);
    }

    public boolean isClearFrame() {
        return this.isClearFrame;
    }

    public boolean getClearFrame() {
        return this.isClearFrame();
    }

    public void setURL(URL aUrl) throws PropertyVetoException {
        if (this.linkURL == null || !this.linkURL.equals(aUrl)) {
            URL oldValue = this.linkURL;
            this.vetos.fireVetoableChange("URL", oldValue, aUrl);
            this.linkURL = aUrl;
            this.context = null;
            this.changes.firePropertyChange("URL", oldValue, aUrl);
        }
    }

    public URL getURL() {
        return this.linkURL;
    }

    public void setFrame(String f) throws PropertyVetoException {
        String oldValue = this.frame;
        this.vetos.fireVetoableChange("Frame", oldValue, f);
        this.frame = f;
        this.changes.firePropertyChange("Frame", oldValue, f);
    }

    public String getFrame() {
        return this.frame;
    }

    public void setCenterMode(boolean flag) throws PropertyVetoException {
        if (this.isCenterMode != flag) {
            Boolean oldValue = new Boolean(this.isCenterMode);
            Boolean newValue = new Boolean(flag);
            this.vetos.fireVetoableChange("CenterMode", oldValue, newValue);
            this.isCenterMode = flag;
            this.invalidate();
            this.changes.firePropertyChange("CenterMode", oldValue, newValue);
        }
    }

    public boolean isCenterMode() {
        return this.isCenterMode;
    }

    public boolean getCenterMode() {
        return this.isCenterMode();
    }

    public void paint(Graphics g) {
        Dimension dim = this.size();
        int y = 0;
        int x = 0;
        if (this.isPressed) {
            if (this.isMouseOver) {
                if (this.downImage != null) {
                    if (this.isCenterMode) {
                        x += (dim.width - this.downImage.getWidth(this)) / 2;
                        y += (dim.height - this.downImage.getHeight(this)) / 2;
                    }
                    g.drawImage(this.downImage, x, y, this);
                }
            } else if (this.overImage != null) {
                if (this.isCenterMode) {
                    x += (dim.width - this.overImage.getWidth(this)) / 2;
                    y += (dim.height - this.overImage.getHeight(this)) / 2;
                }
                g.drawImage(this.overImage, x, y, this);
            }
        } else if (this.isMouseOver && this.overImage != null) {
            if (this.isCenterMode) {
                x += (dim.width - this.overImage.getWidth(this)) / 2;
                y += (dim.height - this.overImage.getHeight(this)) / 2;
            }
            g.drawImage(this.overImage, x, y, this);
        } else if (this.standardImage != null) {
            if (this.isCenterMode) {
                x += (dim.width - this.standardImage.getWidth(this)) / 2;
                y += (dim.height - this.standardImage.getHeight(this)) / 2;
            }
            g.drawImage(this.standardImage, x, y, this);
        }
    }

    public void update(Graphics g) {
        if (this.isClearFrame) {
            super.update(g);
        } else {
            this.paint(g);
        }
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.mouseMotion == null) {
            this.mouseMotion = new MouseMtn();
            this.addMouseMotionListener(this.mouseMotion);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.mouseMotion != null) {
            this.removeMouseMotionListener(this.mouseMotion);
            this.mouseMotion = null;
        }
        super.removeNotify();
    }

    public void validate() {
        Container c = this.getParent();
        while (c != null) {
            if (c instanceof Applet) {
                this.setAppletContext(((Applet)c).getAppletContext());
                break;
            }
            c = c.getParent();
        }
    }

    public Dimension getPreferredSize() {
        int iWidth = this.standardImage == null ? 0 : this.standardImage.getWidth(this);
        int oWidth = this.overImage == null ? 0 : this.overImage.getWidth(this);
        int dWidth = this.downImage == null ? 0 : this.downImage.getWidth(this);
        int iHeight = this.standardImage == null ? 0 : this.standardImage.getHeight(this);
        int oHeight = this.overImage == null ? 0 : this.overImage.getHeight(this);
        int dHeight = this.downImage == null ? 0 : this.downImage.getHeight(this);
        int maxWidth = iWidth >= oWidth ? iWidth : oWidth;
        maxWidth = maxWidth >= dWidth ? maxWidth : dWidth;
        int maxHeight = iHeight >= oHeight ? iHeight : oHeight;
        maxHeight = maxHeight >= dHeight ? maxHeight : dHeight;
        maxWidth = maxWidth == 0 ? 10 : maxWidth;
        maxHeight = maxHeight == 0 ? 10 : maxHeight;
        return new Dimension(maxWidth, maxHeight);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public void setActionCommand(String command) throws PropertyVetoException {
        String oldValue = this.actionCommand;
        this.vetos.fireVetoableChange("ActionCommand", oldValue, command);
        this.actionCommand = command;
        this.changes.firePropertyChange("ActionCommand", oldValue, command);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    protected void setImageHelper(Image img) {
        if (img != null) {
            try {
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(img, 0);
                tracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.repaint();
        }
    }

    protected void setAppletContext(AppletContext c) {
        this.context = c;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.standardURL != null) {
            this.standardImage = this.getToolkit().getImage(this.standardURL);
            if (this.standardImage != null) {
                this.setImageHelper(this.standardImage);
                this.repaint();
            }
        }
        if (this.overURL != null) {
            this.overImage = this.getToolkit().getImage(this.overURL);
            if (this.overImage != null) {
                this.setImageHelper(this.overImage);
                this.repaint();
            }
        }
        if (this.downURL != null) {
            this.downImage = this.getToolkit().getImage(this.downURL);
            if (this.downImage != null) {
                this.setImageHelper(this.downImage);
                this.repaint();
            }
        }
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent e) {
            RollOverButton.this.isPressed = true;
            RollOverButton.this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            if (RollOverButton.this.isPressed) {
                RollOverButton.this.isPressed = false;
                RollOverButton.this.repaint();
                if (RollOverButton.this.isMouseOver) {
                    if (RollOverButton.this.context != null & RollOverButton.this.linkURL != null) {
                        if (RollOverButton.this.frame == null || RollOverButton.this.frame.length() == 0) {
                            RollOverButton.this.context.showDocument(RollOverButton.this.linkURL);
                        } else {
                            RollOverButton.this.context.showDocument(RollOverButton.this.linkURL, RollOverButton.this.frame);
                        }
                    }
                    RollOverButton.this.sourceActionEvent();
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
            RollOverButton.this.isMouseOver = true;
            if (RollOverButton.this.context != null && RollOverButton.this.linkURL != null) {
                RollOverButton.this.context.showStatus(RollOverButton.this.linkURL.toString());
            }
            RollOverButton.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            RollOverButton.this.isMouseOver = false;
            if (RollOverButton.this.context != null && RollOverButton.this.linkURL != null) {
                RollOverButton.this.context.showStatus("");
            }
            RollOverButton.this.repaint();
        }

        Mouse() {
            RollOverButton.this = RollOverButton.this;
        }
    }

    class MouseMtn
    implements MouseMotionListener,
    Serializable {
        public void mouseMoved(MouseEvent e) {
            RollOverButton.this.isMouseDrag = false;
            RollOverButton.this.isPressed = false;
        }

        public void mouseDragged(MouseEvent e) {
            RollOverButton.this.isMouseDrag = true;
        }

        MouseMtn() {
            RollOverButton.this = RollOverButton.this;
        }
    }
}

