/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JOptionPane;

public class hlcjshelf {
    public boolean invalidShelf = false;
    public String shelfFileName;
    public String shelfName;
    public String shelfAuthor;
    public String shelfDescription;
    public String shelfDate;
    public String indexNumberOfBooks;
    protected String theShelfIndexName;
    protected String theShelfIndexDictionaryName;
    protected Date theShelfIndexUpdateTimestamp;
    protected SimpleDateFormat bksTimestampFormatter = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
    protected SimpleDateFormat xksTimestampFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private String emptyString = "";
    private Vector theDocumentInstanceExpirationTimestamps = new Vector();
    private Vector theDocumentInstanceUpdateComments = new Vector();
    private Vector theDocumentInstanceUpdateTimestamps = new Vector();
    private Vector theDocumentInstanceKeywords = new Vector();
    private Vector theDocumentInstanceAuthors = new Vector();
    private Vector theDocumentInstanceSubjects = new Vector();
    private Vector theDocumentIDs = new Vector();
    private Vector theDocumentInstanceTitles = new Vector();
    private Vector theDocumentInstanceNames = new Vector();
    private Vector theDocumentInstanceFileNames = new Vector();
    private Vector theDocumentInstanceMimeTypes = new Vector();
    Vector returnedchTitleFromCPP = new Vector();
    Vector returnedBookNameFromCPP = new Vector();
    Vector returnedBookDateFromCPP = new Vector();
    Vector returnedDocNumberFromCPP = new Vector();
    Vector returnedBksIndexFromCPP = new Vector();
    Vector returnedFullNameFromCPP = new Vector();
    static String returnedNativeString = "need to be set from cpp";
    static int returnedNativeInt = 100;
    int verifyShelfResult = 0;
    int verifyIndexResult = 0;
    private boolean bksshelf;
    private boolean bkstitle;
    private boolean bksdatetime;
    private boolean bksindex;
    private boolean bkidatetime;
    private boolean isBKSInfo;
    public static final int DOCUMENT_INSTANCE_ICON_COLUMN = 0;
    public static final int DOCUMENT_INSTANCE_NAME_COLUMN = 1;
    public static final int DOCUMENT_INSTANCE_UPDATE_TIMESTAMP_COLUMN = 2;
    public static final int DOCUMENT_INSTANCE_TITLE_COLUMN = 3;
    public static final int DOCUMENT_ID_COLUMN = 4;
    public static final int DOCUMENT_INSTANCE_FILENAME_COLUMN = 5;
    public static final int DOCUMENT_INSTANCE_UPDATE_COMMENTS_COLUMN = 6;
    public static final int DOCUMENT_INSTANCE_KEYWORDS_COLUMN = 7;
    public static final int DOCUMENT_INSTANCE_AUTHOR_COLUMN = 7;
    public static final int DOCUMENT_INSTANCE_EXPIRATION_TIMESTAMP_COLUMN = 8;
    public static final int DOCUMENT_INSTANCE_SUBJECT_COLUMN = 9;
    public static final int DOCUMENT_INSTANCE_INDEXED_FLAG_COLUMN = 10;
    public static final int DOCUMENT_INSTANCE_MIME_TYPES_COLUMN = 11;
    public static final int DOCUMENT_COLUMN_COUNT = 12;
    static final String fsep = new String(System.getProperty("file.separator"));
    static final char fsepChar = fsep.charAt(0);
    String runDir = "what ever";
    private String userDataDirectory = "";

    public int shelfSearch(String shelfNameIn, int sortTypeIn, String pathsIn, int searchFlagIn, String searchArgsIn) {
        this.resetVectors();
        return this.JNI_ephdbsap_shelfSearch(shelfNameIn, sortTypeIn, pathsIn, searchFlagIn, searchArgsIn);
    }

    protected native int JNI_ephdbsap_shelfSearch(String var1, int var2, String var3, int var4, String var5);

    public String getShelfIndexName() {
        return this.theShelfIndexName;
    }

    public String getShelfIndexDictionaryName() {
        return this.theShelfIndexDictionaryName;
    }

    public String getShelfIndexUpdateTimestamp() {
        String result = "";
        result = this.theShelfIndexUpdateTimestamp != null ? this.bksTimestampFormatter.format(this.theShelfIndexUpdateTimestamp) : "";
        return result;
    }

    protected void setShelfIndexName(String nameIn) {
        this.theShelfIndexName = nameIn;
    }

    protected void setShelfIndexDictionaryName(String nameIn) {
        this.theShelfIndexDictionaryName = nameIn != null ? nameIn : "";
    }

    protected void setShelfIndexUpdateTimestamp(String timestampIn) {
        this.theShelfIndexUpdateTimestamp = this.bksTimestampFormatter.parse(timestampIn, new ParsePosition(0));
    }

    public String getShelfName() {
        return this.shelfName;
    }

    public void resetVectors() {
        this.returnedchTitleFromCPP.clear();
        this.returnedBookNameFromCPP.clear();
        this.returnedBookDateFromCPP.clear();
        this.returnedDocNumberFromCPP.clear();
        this.returnedBksIndexFromCPP.clear();
        this.returnedFullNameFromCPP.clear();
    }

    public void addElementToVector(int vectorNumberIn) {
        switch (vectorNumberIn) {
            case 1: {
                this.returnedchTitleFromCPP.addElement(returnedNativeString);
                break;
            }
            case 2: {
                this.returnedBookNameFromCPP.addElement(returnedNativeString);
                break;
            }
            case 3: {
                this.returnedBookDateFromCPP.addElement(returnedNativeString);
                break;
            }
            case 4: {
                this.returnedDocNumberFromCPP.addElement(returnedNativeString);
                break;
            }
            case 5: {
                Integer returnedInteger = new Integer(returnedNativeInt);
                String returnedIntTemp = new String(returnedInteger.toString());
                this.returnedBksIndexFromCPP.addElement(returnedIntTemp);
                break;
            }
            case 6: {
                this.returnedFullNameFromCPP.addElement(returnedNativeString);
                break;
            }
            default: {
                System.out.println("hlcjshelf:  unknown vector number " + vectorNumberIn);
            }
        }
    }

    public String getShelfFileName() {
        return this.shelfFileName;
    }

    public String getShelfFilePath() {
        File sFile = new File(this.shelfFileName);
        return sFile.getAbsolutePath();
    }

    public String getShelfDescription() {
        return this.shelfDescription;
    }

    public String getShelfDate() {
        return this.shelfDate;
    }

    public String getIndexFileName() {
        return this.theShelfIndexName;
    }

    public String getIndexDate() {
        String result = "";
        if (this.theShelfIndexUpdateTimestamp != null) {
            result = this.bksTimestampFormatter.format(this.theShelfIndexUpdateTimestamp);
        }
        return result;
    }

    public String getIndexNumberOfBooks() {
        return this.indexNumberOfBooks;
    }

    public void setRundir(String rdir) {
        this.runDir = rdir;
    }

    public void setUserDataDirectory(String directoryIn) {
        this.userDataDirectory = directoryIn;
    }

    public void resetBookInfo() {
        this.theDocumentIDs.clear();
        this.theDocumentInstanceAuthors.clear();
        this.theDocumentInstanceExpirationTimestamps.clear();
        this.theDocumentInstanceFileNames.clear();
        this.theDocumentInstanceKeywords.clear();
        this.theDocumentInstanceNames.clear();
        this.theDocumentInstanceSubjects.clear();
        this.theDocumentInstanceTitles.clear();
        this.theDocumentInstanceUpdateComments.clear();
        this.theDocumentInstanceUpdateTimestamps.clear();
        this.theDocumentInstanceMimeTypes.clear();
    }

    public void readBookInfo(String shelfNameIn) throws XKOopsException, IOException, Exception {
        if (shelfNameIn.toUpperCase().endsWith(".XKS")) {
            this.readXKSBookInfo(shelfNameIn);
        } else {
            this.readBKSBookInfo(shelfNameIn);
        }
    }

    public void readBookshelf(String shelfNameIn, boolean readBooksIn) throws XKOopsException, IOException, Exception {
        if (shelfNameIn.toUpperCase().endsWith(".XKS")) {
            this.readXKSBookshelf(shelfNameIn, readBooksIn);
        } else {
            this.readBKSBookshelf(shelfNameIn, readBooksIn);
        }
    }

    public void readBKSBookInfo(String sName) throws IOException {
        this.shelfFileName = sName;
        File myShelfFile = new File(this.shelfFileName);
        if (myShelfFile.exists()) {
            BufferedReader myShelf = new BufferedReader(new FileReader(this.shelfFileName));
            String line = myShelf.readLine();
            this.isBKSInfo = true;
            this.theDocumentIDs.clear();
            this.theDocumentInstanceAuthors.clear();
            this.theDocumentInstanceExpirationTimestamps.clear();
            this.theDocumentInstanceFileNames.clear();
            this.theDocumentInstanceKeywords.clear();
            this.theDocumentInstanceNames.clear();
            this.theDocumentInstanceSubjects.clear();
            this.theDocumentInstanceTitles.clear();
            this.theDocumentInstanceUpdateComments.clear();
            this.theDocumentInstanceUpdateTimestamps.clear();
            this.theDocumentInstanceMimeTypes.clear();
            while (line != null) {
                line = line.trim();
                if (!this.isBKSInfo || line.startsWith("SH")) {
                    if (line.startsWith("BKNAME=")) {
                        this.theDocumentInstanceNames.addElement(line.substring(7).toUpperCase());
                        this.theDocumentInstanceFileNames.addElement(line.substring(7) + ".boo");
                        this.theDocumentInstanceAuthors.addElement("");
                        this.theDocumentInstanceExpirationTimestamps.addElement("");
                        this.theDocumentInstanceKeywords.addElement("");
                        this.theDocumentInstanceSubjects.addElement("");
                        this.theDocumentInstanceUpdateComments.addElement("");
                    } else if (line.startsWith("ST ") || line.equals("ST")) {
                        this.theDocumentInstanceTitles.addElement(line.substring(2).trim());
                    } else if (line.startsWith("BKDATETIME=")) {
                        this.theDocumentInstanceUpdateTimestamps.addElement(line.substring(11));
                    } else if (line.startsWith("SH")) {
                        this.theDocumentIDs.addElement(line.substring(2));
                        this.theDocumentInstanceMimeTypes.addElement("APPLICATION/PDF");
                        this.isBKSInfo = false;
                    } else if (line.startsWith("DOSNAME=")) {
                        // empty if block
                    }
                }
                line = myShelf.readLine();
            }
            myShelf.close();
        }
    }

    public void readXKSBookInfo(String sName) throws XKOopsException, IOException, Exception {
        this.shelfFileName = sName;
        File myShelfFile = new File(this.shelfFileName);
        if (myShelfFile.exists()) {
            this.isBKSInfo = true;
            this.theDocumentIDs.clear();
            this.theDocumentInstanceMimeTypes.clear();
            this.theDocumentInstanceAuthors.clear();
            this.theDocumentInstanceExpirationTimestamps.clear();
            this.theDocumentInstanceFileNames.clear();
            this.theDocumentInstanceKeywords.clear();
            this.theDocumentInstanceNames.clear();
            this.theDocumentInstanceSubjects.clear();
            this.theDocumentInstanceTitles.clear();
            this.theDocumentInstanceUpdateComments.clear();
            this.theDocumentInstanceUpdateTimestamps.clear();
            XKShelf shelf = new XKShelf(myShelfFile.getCanonicalPath());
            shelf.openRead();
            this.readXKSDocuments(shelf);
        }
    }

    public void readXKSDocuments(XKShelf xkshelfIn) throws Exception {
        XKDocument currentDocument = xkshelfIn.getFirstDocument();
        while (currentDocument != null) {
            this.readXKSInstances(currentDocument);
            currentDocument = xkshelfIn.getNextDocument();
        }
    }

    public void readXKSInstances(XKDocument xkdocumentIn) throws Exception {
        XKInstance currentInstance = xkdocumentIn.getFirstInstance();
        String fileName = new String("");
        String mimeType = new String("");
        String currentDocumentID = xkdocumentIn.getID();
        while (currentInstance != null) {
            this.theDocumentIDs.addElement(currentDocumentID);
            fileName = currentInstance.getName();
            mimeType = currentInstance.getType().toUpperCase();
            this.theDocumentInstanceMimeTypes.addElement(mimeType);
            fileName = mimeType.equals("APPLICATION/PDF") ? fileName + ".pdf" : (mimeType.equals("APPLICATION/X-BOO") || mimeType.equals("APPLICATION/BOO") ? fileName + ".boo" : "");
            this.theDocumentInstanceAuthors.addElement(currentInstance.getAuthor());
            this.theDocumentInstanceExpirationTimestamps.addElement(currentInstance.getExpirationTimestamp());
            this.theDocumentInstanceFileNames.addElement(fileName);
            this.theDocumentInstanceKeywords.addElement(currentInstance.getKeywords());
            this.theDocumentInstanceNames.addElement(currentInstance.getName());
            this.theDocumentInstanceSubjects.addElement(currentInstance.getSubject());
            this.theDocumentInstanceTitles.addElement(currentInstance.getTitle());
            this.theDocumentInstanceUpdateComments.addElement(currentInstance.getUpdateComment());
            this.theDocumentInstanceUpdateTimestamps.addElement(this.getSCRFormattedTimestamp(currentInstance.getUpdateTimestamp()));
            currentInstance = xkdocumentIn.getNextInstance();
        }
    }

    public String getSCRFormattedTimestamp(String timestampIn) {
        return timestampIn.substring(5, 7) + "/" + timestampIn.substring(8, 10) + "/" + timestampIn.substring(2, 4) + " " + timestampIn.substring(11, 13) + ":" + timestampIn.substring(14, 16) + ":" + timestampIn.substring(17, 19) + " ";
    }

    public String getXKSFormattedTimestamp(String timestampIn) {
        String result = "";
        if (!timestampIn.equals("")) {
            int yy = Integer.parseInt(timestampIn.substring(6, 8));
            int year = (yy <= 59 ? 2000 : 1900) + yy;
            result = year + "-" + timestampIn.substring(0, 2) + "-" + timestampIn.substring(3, 5) + "T" + timestampIn.substring(9, 11) + ":" + timestampIn.substring(12, 14) + ":" + timestampIn.substring(15, 17);
        }
        return result;
    }

    public void readXKSBookshelf(String sName, boolean readBooks) throws XKOopsException, IOException, Exception {
        this.shelfFileName = sName;
        File myShelfFile = new File(this.shelfFileName);
        if (myShelfFile.exists()) {
            this.bkidatetime = true;
            this.bksdatetime = true;
            this.bksindex = true;
            this.bksshelf = true;
            this.bkstitle = true;
            try {
                XKShelf shelf = new XKShelf(myShelfFile.getCanonicalPath());
                shelf.openRead();
                this.indexNumberOfBooks = "?";
                this.shelfDate = this.getSCRFormattedTimestamp(shelf.getUpdateTimestamp());
                this.shelfDescription = shelf.getTitle();
                this.shelfName = shelf.getName();
                this.theShelfIndexName = shelf.getIndexName();
                this.theShelfIndexDictionaryName = shelf.getIndexDictionaryName();
                this.theShelfIndexUpdateTimestamp = this.xksTimestampFormatter.parse(shelf.getIndexUpdateTimestamp(), new ParsePosition(0));
                this.invalidShelf = false;
                if (readBooks) {
                    this.readXKSDocuments(shelf);
                }
                this.isBKSInfo = true;
            }
            catch (XKOopsException e) {
                this.invalidShelf = true;
                throw e;
            }
            catch (IOException e) {
                this.invalidShelf = true;
                throw e;
            }
            catch (Exception e) {
                this.invalidShelf = true;
                throw e;
            }
        }
    }

    public void readBKSBookshelf(String sName, boolean readBooks) throws IOException {
        this.shelfFileName = sName;
        File myShelfFile = new File(this.shelfFileName);
        if (myShelfFile.exists()) {
            BufferedReader myShelf = new BufferedReader(new FileReader(this.shelfFileName));
            this.isBKSInfo = true;
            this.invalidShelf = false;
            this.bksshelf = true;
            this.bkstitle = true;
            this.bksdatetime = true;
            this.bksindex = false;
            this.bkidatetime = true;
            this.shelfName = this.emptyString;
            this.shelfDescription = this.emptyString;
            this.shelfDate = this.emptyString;
            this.indexNumberOfBooks = this.emptyString;
            this.theShelfIndexDictionaryName = this.emptyString;
            this.theShelfIndexName = this.emptyString;
            String line = myShelf.readLine();
            while (line != null && this.isBKSInfo) {
                line = line.trim();
                if (this.bksshelf && line.startsWith("BKSHELF")) {
                    this.shelfName = line.substring(8);
                    this.bksshelf = false;
                } else if (this.bkstitle && line.startsWith("BKSTITLE")) {
                    this.shelfDescription = line.substring(9);
                    this.bkstitle = false;
                } else if (this.bksdatetime && line.startsWith("BKSDATETIME")) {
                    this.shelfDate = line.substring(12);
                    this.bksdatetime = false;
                } else if (line.startsWith("BKSINDEX")) {
                    this.theShelfIndexName = line.substring(9);
                    this.bksindex = true;
                } else if (this.bksindex && line.startsWith("BKSLEXIS")) {
                    this.theShelfIndexDictionaryName = line.substring(9);
                    if (this.theShelfIndexDictionaryName == null) {
                        this.theShelfIndexDictionaryName = "";
                    }
                } else if (this.bkidatetime && line.startsWith("BKIDATETIME")) {
                    this.theShelfIndexUpdateTimestamp = this.bksTimestampFormatter.parse(line.substring(12), new ParsePosition(0));
                    this.bkidatetime = false;
                } else if (line.startsWith("BKIBOOKS")) {
                    this.indexNumberOfBooks = line.substring(9);
                    this.isBKSInfo = false;
                    this.invalidShelf = false;
                }
                line = myShelf.readLine();
            }
            while (line != null && readBooks) {
                if ((line = line.trim()).startsWith("BKNAME=")) {
                    this.theDocumentInstanceNames.addElement(line.substring(7).toUpperCase());
                    this.theDocumentInstanceFileNames.addElement(line.substring(7) + ".boo");
                    this.theDocumentInstanceAuthors.addElement("");
                    this.theDocumentInstanceExpirationTimestamps.addElement("");
                    this.theDocumentInstanceKeywords.addElement("");
                    this.theDocumentInstanceSubjects.addElement("");
                    this.theDocumentInstanceUpdateComments.addElement("");
                } else if (line.startsWith("ST ") || line.equals("ST")) {
                    this.theDocumentInstanceTitles.addElement(line.substring(2));
                } else if (line.startsWith("BKDATETIME=")) {
                    this.theDocumentInstanceUpdateTimestamps.addElement(line.substring(11));
                } else if (line.startsWith("SH")) {
                    this.theDocumentIDs.addElement(line.substring(2));
                    this.theDocumentInstanceMimeTypes.addElement("APPLICATION/X-BOO");
                } else if (!line.startsWith("DOSNAME=")) {
                    if (line.startsWith("PDFSH")) {
                        this.theDocumentIDs.addElement(line.substring(5));
                        this.theDocumentInstanceMimeTypes.addElement("APPLICATION/PDF");
                    } else if (line.startsWith("PDFST")) {
                        this.theDocumentInstanceTitles.addElement(line.substring(5));
                    } else if (!line.startsWith("PDFNAME=")) {
                        if (line.startsWith("PDFDATETIME=")) {
                            this.theDocumentInstanceUpdateTimestamps.addElement(line.substring(12));
                        } else if (line.startsWith("PDFDOSNAME=")) {
                            this.theDocumentInstanceFileNames.addElement(line.substring(11));
                        } else if (line.startsWith("IONSH")) {
                            this.theDocumentIDs.addElement(line.substring(5));
                        } else if (line.startsWith("IONST")) {
                            this.theDocumentInstanceTitles.addElement(line.substring(5));
                        } else if (line.startsWith("IONNAME=")) {
                            this.theDocumentInstanceNames.addElement(line.substring(8).toUpperCase());
                        } else if (line.startsWith("IONDATETIME=")) {
                            this.theDocumentInstanceUpdateTimestamps.addElement(line.substring(12));
                        } else if (line.startsWith("IONDOSNAME=")) {
                            // empty if block
                        }
                    }
                }
                line = myShelf.readLine();
            }
            myShelf.close();
        }
    }

    public hlcjshelf(String sName, boolean readBooks, String rDir, String userDataDirectoryIn) throws XKOopsException, IOException, Exception {
        this.runDir = new String(rDir);
        this.userDataDirectory = new String(userDataDirectoryIn);
        this.readBookshelf(sName, readBooks);
    }

    public hlcjshelf(String rDir, String userDataDirectoryIn) {
        this.runDir = rDir;
        this.userDataDirectory = new String(userDataDirectoryIn);
    }

    public void addBookFromFile(String fileName) throws IOException {
        hlcjbook jb = new hlcjbook(fileName, this.runDir, this.userDataDirectory);
        int status = jb.jbOpen();
        if (status == 0) {
            jb.jbClose();
            this.theDocumentIDs.addElement(jb.jbGetjDocnum());
            this.theDocumentInstanceAuthors.addElement("");
            this.theDocumentInstanceExpirationTimestamps.addElement("");
            this.theDocumentInstanceFileNames.addElement(fileName.substring(fileName.lastIndexOf(fsepChar) + 1, fileName.length()));
            this.theDocumentInstanceKeywords.addElement("");
            String fileExtension = fileName.substring(fileName.lastIndexOf(46) + 1);
            if (fileExtension.equalsIgnoreCase("BOO")) {
                this.theDocumentInstanceMimeTypes.addElement("APPLICATION/X-BOO");
            } else if (fileExtension.equalsIgnoreCase("PDF")) {
                this.theDocumentInstanceMimeTypes.addElement("APPLICATION/PDF");
            } else {
                this.theDocumentInstanceMimeTypes.addElement("");
            }
            String bookName = fileName.substring(fileName.lastIndexOf(fsepChar) + 1, fileName.length() - 4);
            this.theDocumentInstanceNames.addElement(bookName.toUpperCase());
            this.theDocumentInstanceSubjects.addElement("");
            this.theDocumentInstanceTitles.addElement(jb.jbGetjTitle());
            this.theDocumentInstanceUpdateComments.addElement("");
            this.theDocumentInstanceUpdateTimestamps.addElement(jb.jbGetjBuildDate());
            this.saveBookshelf(this.shelfFileName);
        } else {
            JOptionPane.showMessageDialog(null, "Book " + fileName + " could not be found.", "IBM Softcopy Reader", 0);
        }
    }

    public void addPublications(Vector documentIDsIn, Vector authorsIn, Vector expirationTimestampsIn, Vector fileNamesIn, Vector mimeTypesIn, Vector keywordsIn, Vector lastModifiedTimestampsIn, Vector namesIn, Vector subjectsIn, Vector titlesIn, Vector updateCommentsIn) throws XKOopsException, IOException {
        this.theDocumentIDs.addAll(documentIDsIn);
        this.theDocumentInstanceAuthors.addAll(authorsIn);
        this.theDocumentInstanceExpirationTimestamps.addAll(expirationTimestampsIn);
        this.theDocumentInstanceFileNames.addAll(fileNamesIn);
        this.theDocumentInstanceKeywords.addAll(keywordsIn);
        this.theDocumentInstanceMimeTypes.addAll(mimeTypesIn);
        this.theDocumentInstanceUpdateTimestamps.addAll(lastModifiedTimestampsIn);
        this.theDocumentInstanceNames.addAll(namesIn);
        this.theDocumentInstanceSubjects.addAll(subjectsIn);
        this.theDocumentInstanceTitles.addAll(titlesIn);
        this.theDocumentInstanceUpdateComments.addAll(updateCommentsIn);
        this.saveShelf(this.shelfFileName);
    }

    public void cutBooks(Vector booksToCut) throws XKOopsException, IOException {
        for (int i = 0; i < booksToCut.size(); ++i) {
            int cutIndex = this.theDocumentInstanceFileNames.indexOf(((Vector)booksToCut.elementAt(i)).elementAt(5));
            if (cutIndex < 0) {
                cutIndex = this.theDocumentInstanceNames.indexOf(((Vector)booksToCut.elementAt(i)).elementAt(1));
            }
            if (cutIndex < 0) {
                cutIndex = this.theDocumentInstanceTitles.indexOf(((Vector)booksToCut.elementAt(i)).elementAt(3));
            }
            if (cutIndex < 0) {
                cutIndex = this.theDocumentIDs.indexOf(((Vector)booksToCut.elementAt(i)).elementAt(4));
            }
            this.theDocumentIDs.removeElementAt(cutIndex);
            this.theDocumentInstanceAuthors.removeElementAt(cutIndex);
            this.theDocumentInstanceExpirationTimestamps.removeElementAt(cutIndex);
            this.theDocumentInstanceFileNames.removeElementAt(cutIndex);
            this.theDocumentInstanceKeywords.removeElementAt(cutIndex);
            this.theDocumentInstanceNames.removeElementAt(cutIndex);
            this.theDocumentInstanceSubjects.removeElementAt(cutIndex);
            this.theDocumentInstanceTitles.removeElementAt(cutIndex);
            this.theDocumentInstanceUpdateComments.removeElementAt(cutIndex);
            this.theDocumentInstanceUpdateTimestamps.removeElementAt(cutIndex);
            this.theDocumentInstanceMimeTypes.removeElementAt(cutIndex);
        }
        this.saveShelf(this.shelfFileName);
    }

    public void pasteBooks(Vector booksToPaste) throws XKOopsException, IOException {
        for (int i = 0; i < booksToPaste.size(); ++i) {
            this.theDocumentIDs.addElement(((Vector)booksToPaste.elementAt(i)).elementAt(4));
            this.theDocumentInstanceAuthors.addElement(((Vector)booksToPaste.elementAt(i)).elementAt(7));
            this.theDocumentInstanceExpirationTimestamps.addElement(((Vector)booksToPaste.elementAt(i)).elementAt(8));
            this.theDocumentInstanceFileNames.addElement(((Vector)booksToPaste.elementAt(i)).elementAt(5));
            this.theDocumentInstanceKeywords.addElement(((Vector)booksToPaste.elementAt(i)).elementAt(7));
            String instanceName = (String)((Vector)booksToPaste.elementAt(i)).elementAt(1);
            this.theDocumentInstanceNames.addElement(instanceName.toUpperCase());
            this.theDocumentInstanceSubjects.addElement(((Vector)booksToPaste.elementAt(i)).elementAt(9));
            this.theDocumentInstanceTitles.addElement(((Vector)booksToPaste.elementAt(i)).elementAt(3));
            this.theDocumentInstanceUpdateComments.addElement(((Vector)booksToPaste.elementAt(i)).elementAt(6));
            this.theDocumentInstanceUpdateTimestamps.addElement(((Vector)booksToPaste.elementAt(i)).elementAt(2));
            this.theDocumentInstanceMimeTypes.addElement(((Vector)booksToPaste.elementAt(i)).elementAt(11));
        }
        this.saveShelf(this.shelfFileName);
    }

    public String findFileForBook(Vector locations, String whichBook, String whichField) throws IOException {
        int i;
        String fileForBook = new String();
        String nameForBook = new String();
        String tfn = new String();
        boolean found = false;
        if (whichField.toUpperCase().equals("NAME")) {
            for (i = 0; i < this.theDocumentInstanceNames.size(); ++i) {
                if (!this.theDocumentInstanceNames.elementAt(i).toString().toUpperCase().startsWith(whichBook.toUpperCase())) continue;
                nameForBook = this.theDocumentInstanceNames.elementAt(i).toString();
                break;
            }
        } else if (whichField.toUpperCase().equals("TITLE")) {
            for (i = 0; i < this.theDocumentInstanceTitles.size(); ++i) {
                if (!this.theDocumentInstanceTitles.elementAt(i).toString().toUpperCase().startsWith(whichBook.toUpperCase())) continue;
                nameForBook = this.theDocumentInstanceNames.elementAt(i).toString();
                break;
            }
        } else if (whichField.toUpperCase().equals("DOC NUMBER")) {
            for (i = 0; i < this.theDocumentIDs.size(); ++i) {
                if (!this.theDocumentIDs.elementAt(i).toString().toUpperCase().startsWith(whichBook.toUpperCase())) continue;
                nameForBook = this.theDocumentInstanceNames.elementAt(i).toString();
                break;
            }
        }
        if (!fileForBook.equals("")) {
            return fileForBook;
        }
        if (!nameForBook.equals("")) {
            for (i = 0; i < locations.size() && !found; ++i) {
                tfn = new String(locations.elementAt(i) + fsep + nameForBook + ".BOO");
                File tf = new File(tfn);
                if (tf.exists()) {
                    found = true;
                    continue;
                }
                tfn = new String(locations.elementAt(i) + fsep + nameForBook.toLowerCase() + ".boo");
                File tf1 = new File(tfn);
                if (!tf1.exists()) continue;
                found = true;
            }
            if (found) {
                return tfn;
            }
        }
        return "";
    }

    public Vector getNames() {
        return this.theDocumentInstanceNames;
    }

    public Vector getFileNames() {
        return this.theDocumentInstanceFileNames;
    }

    public Vector getDates() {
        return this.theDocumentInstanceUpdateTimestamps;
    }

    public Vector getDescriptions() {
        return this.theDocumentInstanceTitles;
    }

    public Vector getDocNumbers() {
        return this.theDocumentIDs;
    }

    public Vector getDocumentInstanceMimeTypes() {
        return this.theDocumentInstanceMimeTypes;
    }

    public void setShelfProperties(String selectedFile, String selectedName, String selectedDescription, String selectedDate, int NumRows, String selectedIndexFileName, String selectedIndexDate, String selectedIndexNumberOfBooks, String selectedIndexDictionary) {
        this.shelfName = selectedName;
        this.shelfDescription = selectedDescription;
        this.shelfDate = selectedDate;
        this.theShelfIndexUpdateTimestamp = this.bksTimestampFormatter.parse(selectedIndexDate, new ParsePosition(0));
        this.theShelfIndexName = selectedIndexFileName;
        this.indexNumberOfBooks = selectedIndexNumberOfBooks;
        this.theShelfIndexDictionaryName = selectedIndexDictionary;
    }

    public Vector getDocumentInstanceFileNames() {
        return this.theDocumentInstanceFileNames;
    }

    public Vector getDocumentInstanceNames() {
        return this.theDocumentInstanceNames;
    }

    public Vector getDocumentInstanceTitles() {
        return this.theDocumentInstanceTitles;
    }

    public Vector getDocumentIDs() {
        return this.theDocumentIDs;
    }

    public Vector getDocumentInstanceSubjects() {
        return this.theDocumentInstanceSubjects;
    }

    public Vector getDocumentInstanceAuthors() {
        return this.theDocumentInstanceAuthors;
    }

    public Vector getDocumentInstanceKeywords() {
        return this.theDocumentInstanceKeywords;
    }

    public Vector getDocumentInstanceUpdateTimestamps() {
        return this.theDocumentInstanceUpdateTimestamps;
    }

    public Vector getDocumentInstanceUpdateComments() {
        return this.theDocumentInstanceUpdateComments;
    }

    public Vector getDocumentInstanceExpirationTimestamps() {
        return this.theDocumentInstanceExpirationTimestamps;
    }

    public HashSet getUniqueDocumentInstanceKeys() {
        int size = this.theDocumentIDs.size();
        HashSet<String> result = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            result.add((String)this.theDocumentIDs.elementAt(i) + (String)this.theDocumentInstanceMimeTypes.elementAt(i));
        }
        return result;
    }

    public void setName(String nameIn) {
        this.shelfName = nameIn;
    }

    public void setAuthor(String authorIn) {
        this.shelfAuthor = authorIn;
    }

    public void setTitle(String titleIn) {
        this.shelfDescription = titleIn;
    }

    public void setDate(String dateIn) {
        this.shelfDate = dateIn;
    }

    public void setDocumentInstanceFileNames(Vector documentInstanceFileNamesIn) {
        this.theDocumentInstanceFileNames = documentInstanceFileNamesIn;
    }

    public void setDocumentInstanceNames(Vector documentInstanceNamesIn) {
        this.theDocumentInstanceNames = documentInstanceNamesIn;
    }

    public void setDocumentInstanceTitles(Vector documentInstanceTitlesIn) {
        this.theDocumentInstanceTitles = documentInstanceTitlesIn;
    }

    public void setDocumentIDs(Vector documentIDsIn) {
        this.theDocumentIDs = documentIDsIn;
    }

    public void setDocumentInstanceMimeTypes(Vector mimeTypesIn) {
        this.theDocumentInstanceMimeTypes = mimeTypesIn;
    }

    public void setDocumentInstanceSubjects(Vector documentInstanceSubjectsIn) {
        this.theDocumentInstanceSubjects = documentInstanceSubjectsIn;
    }

    public void setDocumentInstanceAuthors(Vector documentInstanceAuthorsIn) {
        this.theDocumentInstanceAuthors = documentInstanceAuthorsIn;
    }

    public void setDocumentInstanceKeywords(Vector documentInstanceKeywordsIn) {
        this.theDocumentInstanceKeywords = documentInstanceKeywordsIn;
    }

    public void setDocumentInstanceUpdateTimestamps(Vector documentInstanceUpdateTimestampsIn) {
        this.theDocumentInstanceUpdateTimestamps = documentInstanceUpdateTimestampsIn;
    }

    public void setDocumentInstanceUpdateComments(Vector documentInstanceUpdateCommentsIn) {
        this.theDocumentInstanceUpdateComments = documentInstanceUpdateCommentsIn;
    }

    public void setDocumentInstanceExpirationTimestamps(Vector documentInstanceExpirationTimestampsIn) {
        this.theDocumentInstanceExpirationTimestamps = documentInstanceExpirationTimestampsIn;
    }

    private void saveXKShelf(String saveFileIn) throws XKOopsException, IOException {
        boolean newFile = true;
        File shelfFile = new File(saveFileIn);
        if (shelfFile.exists()) {
            shelfFile = File.createTempFile("xks", null);
            this.shelfFileName = shelfFile.getCanonicalPath();
            shelfFile.delete();
            newFile = false;
        } else {
            this.shelfFileName = saveFileIn;
            newFile = true;
        }
        this.bkidatetime = true;
        this.bksdatetime = true;
        this.bksindex = true;
        this.bksshelf = true;
        this.bkstitle = true;
        XKShelf shelf = new XKShelf(this.shelfFileName);
        if (this.shelfName == null) {
            this.shelfName = "BLANK";
        }
        shelf.create(this.shelfName, this.shelfDescription);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        shelf.setUpdateTimestamp(df.format(new Date()));
        shelf.setAuthor(this.shelfAuthor);
        if (this.theShelfIndexName != null && this.theShelfIndexDictionaryName != null && this.theShelfIndexUpdateTimestamp != null && this.theShelfIndexName.toString().length() > 0 && this.theShelfIndexDictionaryName.toString().length() > 0 && this.theShelfIndexUpdateTimestamp.toString().length() > 0) {
            shelf.createIndex(this.theShelfIndexName, this.theShelfIndexDictionaryName, this.xksTimestampFormatter.format(this.theShelfIndexUpdateTimestamp));
        }
        if (this.theDocumentInstanceFileNames != null) {
            HashMap<String, XKDocument> uniqueDocuments = new HashMap<String, XKDocument>();
            String currentDocumentID = "";
            boolean documentAlreadyExisted = false;
            for (int c = 0; c < this.theDocumentInstanceFileNames.size(); ++c) {
                XKDocument d;
                currentDocumentID = (String)this.theDocumentIDs.elementAt(c);
                if (uniqueDocuments.containsKey(currentDocumentID)) {
                    d = (XKDocument)uniqueDocuments.get(currentDocumentID);
                    documentAlreadyExisted = true;
                } else {
                    d = shelf.createDocument(currentDocumentID);
                    uniqueDocuments.put(currentDocumentID, d);
                    documentAlreadyExisted = false;
                }
                String fileName = (String)this.theDocumentInstanceFileNames.elementAt(c);
                fileName = fileName.toUpperCase();
                String fileType = "";
                XKInstance i = d.createDocumentInstance(((String)this.theDocumentInstanceMimeTypes.elementAt(c)).toLowerCase(), ((String)this.theDocumentInstanceNames.elementAt(c)).toUpperCase(), (String)this.theDocumentInstanceTitles.elementAt(c), this.getXKSFormattedTimestamp((String)this.theDocumentInstanceUpdateTimestamps.elementAt(c)));
                i.setExpirationTimestamp(this.getXKSFormattedTimestamp((String)this.theDocumentInstanceExpirationTimestamps.elementAt(c)));
                i.setKeywords((String)this.theDocumentInstanceKeywords.elementAt(c));
                i.setAuthor((String)this.theDocumentInstanceAuthors.elementAt(c));
                i.setSubject((String)this.theDocumentInstanceSubjects.elementAt(c));
                i.setUpdateComment((String)this.theDocumentInstanceUpdateComments.elementAt(c));
                d.appendInstance(i);
                if (documentAlreadyExisted) continue;
                shelf.appendDocument(d);
            }
        }
        this.isBKSInfo = true;
        shelf.commitChanges();
        if (!newFile) {
            File oldShelfFile = new File(saveFileIn);
            oldShelfFile.delete();
            shelfFile.renameTo(new File(saveFileIn));
            this.shelfFileName = saveFileIn;
        }
    }

    public void saveShelf(String saveFileIn) throws XKOopsException, IOException {
        if (saveFileIn.toUpperCase().endsWith(".XKS")) {
            this.saveXKShelf(saveFileIn);
        } else {
            this.saveBookshelf(saveFileIn);
        }
    }

    private void saveBookshelf(String saveFile) throws IOException {
        boolean okFlag = true;
        int status = -1;
        if (!saveFile.toUpperCase().endsWith(".BKS")) {
            saveFile = saveFile + ".bks";
        }
        File sFile = new File(saveFile);
        if (okFlag) {
            File newBKS = new File(saveFile);
            PrintStream pos = new PrintStream(new FileOutputStream(newBKS));
            pos.println("BKSHELF=" + this.shelfName);
            pos.println("BKSTITLE=" + this.shelfDescription);
            pos.println("BKSDATETIME=" + this.shelfDate);
            pos.println("BKSINDEX=" + this.theShelfIndexName);
            pos.println("BKIDATETIME=" + this.getIndexDate());
            pos.println("BKSLEXIS=" + this.theShelfIndexDictionaryName);
            pos.println("BKIBOOKS=" + this.indexNumberOfBooks);
            for (int i = 0; i < this.theDocumentInstanceFileNames.size(); ++i) {
                String fileName = new String(this.theDocumentInstanceFileNames.elementAt(i).toString());
                pos.println("SH" + this.theDocumentIDs.elementAt(i).toString());
                pos.println("ST  " + this.theDocumentInstanceTitles.elementAt(i).toString());
                pos.println("BKNAME=" + this.theDocumentInstanceNames.elementAt(i).toString().toUpperCase());
                pos.println("BKDATETIME=" + this.theDocumentInstanceUpdateTimestamps.elementAt(i).toString());
                pos.println("DOSNAME=" + fileName);
                pos.println("BKFLAG=I");
            }
            pos.close();
        }
    }
}

