/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;

public class hlcHTMLTable {
    private String sepPositions;
    private Vector tableVec;
    private StringBuffer tableLines;
    private Vector tableLabel = new Vector();
    private boolean labeled = false;
    private final char vsepchar = (char)145;
    private final char hsepchar = (char)146;
    private final char csepchar = (char)143;
    private final char tsepchar = (char)144;
    private char[] vsepchars = new char[]{'\u0091'};
    private char[] hsepchars = new char[]{'\u0092'};
    private final String vseps = new String(this.vsepchars);
    private final String hseps = new String(this.hsepchars);
    private String fontSize = new String("2");
    private final String tableAlign = new String(" ALIGN=\"LEFT\"");
    private final String tableWidth = new String("");
    private final String tableBorder = new String(" BORDER");
    private final String startFontTag = new String("<FONT SIZE=");
    private final String endFontTag = new String("</FONT>");
    private final String startPreTag = new String("<PRE>");
    private final String endPreTag = new String("</PRE>");
    boolean hasAnySeps = true;
    boolean failConvert1 = false;
    int ntLength = 0;
    int iii = 0;

    public hlcHTMLTable() {
        this.tableVec = new Vector(100, 100);
        this.sepPositions = new String();
        this.tableLines = new StringBuffer(2048);
    }

    public hlcHTMLTable(Vector label) {
        this.tableLabel = new Vector(label);
        this.labeled = true;
        this.tableVec = new Vector(100, 100);
        this.sepPositions = new String();
        this.tableLines = new StringBuffer(2048);
    }

    public void resetFontSize(String x) {
        this.fontSize = x;
    }

    private boolean addSepPositions(String l) {
        int nseps = 0;
        int sepPos = l.indexOf(145);
        while (sepPos < l.length() && sepPos >= 0) {
            ++nseps;
            if (this.sepPositions.indexOf((char)(++sepPos)) < 0) {
                this.sepPositions = this.sepPositions + (char)sepPos;
            }
            sepPos = l.indexOf(145, sepPos);
        }
        return nseps > 1;
    }

    private boolean isCellSep(String s) {
        StringTokenizer cellTok = new StringTokenizer(s, this.hseps);
        return cellTok.countTokens() == 0;
    }

    private void parseLine(String t, String h) {
        Vector rowVec = new Vector();
        char[] sc = new char[]{'.', '.'};
        int sp = t.indexOf(145);
        if (++sp > 0) {
            StringTokenizer cellTok = new StringTokenizer(h, this.vseps);
            while (sp > 0 && sp < t.length() - 1) {
                StringBuffer ss = new StringBuffer(new String(sc));
                ss.setCharAt(0, (char)sp);
                ++sp;
                sp = t.indexOf(145, sp);
                if (sp > 0) {
                    ss.setCharAt(1, (char)(++sp));
                } else {
                    ss.setCharAt(1, (char)(t.length() + 1));
                }
                Vector<String> oc = new Vector<String>();
                if (cellTok.hasMoreTokens()) {
                    oc.addElement(cellTok.nextToken());
                    oc.addElement(ss.toString());
                } else {
                    oc.addElement("");
                    oc.addElement(ss.toString());
                }
                rowVec.addElement(oc);
            }
            this.tableVec.addElement(rowVec);
        }
    }

    private String stripToBorders(String h) {
        int bps = h.indexOf(145);
        int bpe = h.lastIndexOf(145);
        if (bps >= 0 && bpe >= 0) {
            return h.substring(bps, bpe + 1);
        }
        return h;
    }

    public boolean isBordered() {
        return this.hasAnySeps;
    }

    public void insertText(String t, String h) {
        String nt = new String(this.stripToBorders(t.replace('\u008f', '\u0091').replace('\u0090', '\u0092')));
        String nh = new String(this.stripToBorders(h.replace('\u008f', '\u0091').replace('\u0090', '\u0092')));
        if (!this.failConvert1) {
            int newNTlength = nt.length();
            if (this.ntLength == 0 && newNTlength > 0) {
                this.ntLength = newNTlength;
            } else if (newNTlength > this.ntLength) {
                this.failConvert1 = true;
            }
            boolean hasSeps = this.addSepPositions(nt);
            boolean bl = this.hasAnySeps = this.hasAnySeps && hasSeps;
            if (hasSeps) {
                this.parseLine(nt, nh);
            }
        }
        this.tableLines.append(h.replace('\u0091', '|').replace('\u0092', '-').replace('\u008f', '+').replace('\u0090', '+')).append("\n");
    }

    public void clearBuffer() {
        this.tableLines = new StringBuffer(2048);
    }

    public String getHTML(boolean preFmt) {
        Vector<tableCell> rowCellVec;
        int i;
        boolean failConvert = true;
        Vector tableCellVec = new Vector(100, 100);
        if (this.hasAnySeps && !this.failConvert1) {
            failConvert = false;
            tableCell[] tc = new tableCell[this.sepPositions.length() - 1];
            boolean[] cstart = new boolean[this.sepPositions.length() - 1];
            boolean[] cincrow = new boolean[this.sepPositions.length() - 1];
            for (int m = 0; m < cstart.length; ++m) {
                cstart[m] = false;
                cincrow[m] = false;
            }
            char[] spca = this.sepPositions.toCharArray();
            Arrays.sort(spca);
            this.sepPositions = new String(spca);
            for (i = 0; i < this.tableVec.size() && !failConvert; ++i) {
                int cnd;
                int cst;
                String ss;
                String ctxt;
                int j;
                Vector rowVec = new Vector((Vector)this.tableVec.elementAt(i));
                rowCellVec = new Vector<tableCell>();
                boolean hasNullCell = false;
                boolean hasHSeps = false;
                for (j = 0; j < rowVec.size(); ++j) {
                    ctxt = new String(((Vector)rowVec.elementAt(j)).elementAt(0).toString());
                    ss = new String(((Vector)rowVec.elementAt(j)).elementAt(1).toString());
                    cst = this.sepPositions.indexOf(ss.charAt(0));
                    cnd = this.sepPositions.indexOf(ss.charAt(1));
                    if (this.isCellSep(ctxt)) {
                        if (cstart[cst]) {
                            hasNullCell = true;
                        }
                        hasHSeps = true;
                        continue;
                    }
                    if (cstart[cst]) continue;
                    failConvert = true;
                }
                if (failConvert) continue;
                for (j = 0; j < rowVec.size(); ++j) {
                    ctxt = new String(((Vector)rowVec.elementAt(j)).elementAt(0).toString());
                    ss = new String(((Vector)rowVec.elementAt(j)).elementAt(1).toString());
                    cst = this.sepPositions.indexOf(ss.charAt(0));
                    cnd = this.sepPositions.indexOf(ss.charAt(1));
                    if (this.isCellSep(ctxt)) {
                        if (cstart[cst]) {
                            tc[cst] = new tableCell(" ", 1, cnd - cst);
                            rowCellVec.addElement(tc[cst]);
                        }
                        for (int k = cst; k < cnd; ++k) {
                            cstart[k] = true;
                            cincrow[k] = false;
                        }
                        continue;
                    }
                    if (cstart[cst]) {
                        tc[cst] = new tableCell(ctxt, 1, cnd - cst);
                        rowCellVec.addElement(tc[cst]);
                        cstart[cst] = false;
                        cincrow[cst] = false;
                        if (!hasNullCell) continue;
                        tc[cst].incRowspan();
                        continue;
                    }
                    if (tc[cst] == null) {
                        tc[cst] = new tableCell(ctxt, 1, cnd - cst);
                        rowCellVec.addElement(tc[cst]);
                    } else {
                        tc[cst].addText(ctxt);
                    }
                    cincrow[cst] = true;
                    if (!hasHSeps && !hasNullCell) continue;
                    tc[cst].incRowspan();
                }
                if (hasHSeps && !hasNullCell || rowCellVec.isEmpty()) continue;
                tableCellVec.addElement(rowCellVec);
            }
        }
        if (!failConvert && !this.failConvert1) {
            StringBuffer HTMLString = new StringBuffer("<TABLE" + this.tableBorder + this.tableWidth + ">");
            for (i = 0; i < tableCellVec.size(); ++i) {
                rowCellVec = (Vector<tableCell>)tableCellVec.elementAt(i);
                HTMLString.append("<TR>");
                for (int j = 0; j < rowCellVec.size(); ++j) {
                    HTMLString.append(((tableCell)rowCellVec.elementAt(j)).getHTML()).append("\n");
                }
                HTMLString.append("</TR>").append("\n");
            }
            String anchors = new String();
            if (this.labeled) {
                for (int k = 0; k < this.tableLabel.size(); ++k) {
                    anchors = anchors + "<A NAME=\"" + this.tableLabel.elementAt(k).toString() + "\"><BR></A>";
                }
            }
            if (preFmt) {
                HTMLString.insert(0, this.endFontTag + this.endPreTag + anchors).append("</TABLE>" + this.startPreTag + this.startFontTag + this.fontSize + ">");
            } else {
                HTMLString.insert(0, anchors).append("</TABLE>");
            }
            return HTMLString.toString();
        }
        String anchors = new String();
        if (this.labeled) {
            for (int k = 0; k < this.tableLabel.size(); ++k) {
                anchors = anchors + "<A NAME=\"" + this.tableLabel.elementAt(k).toString() + "\"><BR></A>";
            }
        }
        if (preFmt) {
            this.tableLines.insert(0, anchors);
        } else {
            this.tableLines.insert(0, anchors + this.endFontTag + this.startPreTag + this.startFontTag + this.fontSize + ">");
            this.tableLines.append(this.endFontTag + this.endPreTag + this.startFontTag + this.fontSize + ">");
        }
        return this.tableLines.toString();
    }

    private class tableCell {
        private int colspan;
        private int rowspan;
        private String text;
        private final String cellAlign = new String(" ALIGN=\"CENTER\"");

        public tableCell(String itext, int rs, int cs) {
            this.colspan = cs;
            this.rowspan = rs;
            this.text = new String(itext.replace('\u0091', '|').replace('\u0092', '-').replace('\u008f', '+').replace('\u0090', '+'));
        }

        public void test() {
            System.out.println("I love you, SCR");
        }

        public void incRowspan() {
            ++this.rowspan;
        }

        public int getRowspan() {
            return this.rowspan;
        }

        public int getColspan() {
            return this.colspan;
        }

        public void addText(String tx) {
            this.text = !this.text.trim().endsWith("<BR>") ? this.text + "<BR>" + tx.replace('\u0091', '|').replace('\u0092', '-').replace('\u008f', '+').replace('\u0090', '+') : this.text + tx.replace('\u0091', '|').replace('\u0092', '-').replace('\u008f', '+').replace('\u0090', '+');
            this.text.trim();
        }

        public String getHTML() {
            if (this.colspan > 1) {
                if (this.rowspan > 1) {
                    return "<TD" + this.cellAlign + " Rowspan=" + this.rowspan + " Colspan=" + this.colspan + ">" + hlcHTMLTable.this.startFontTag + hlcHTMLTable.this.fontSize + ">" + this.text + "</FONT></TD>";
                }
                return "<TD" + this.cellAlign + " Colspan=" + this.colspan + ">" + hlcHTMLTable.this.startFontTag + hlcHTMLTable.this.fontSize + ">" + this.text + "</FONT></TD>";
            }
            if (this.rowspan > 1) {
                return "<TD" + this.cellAlign + " Rowspan=" + this.rowspan + ">" + hlcHTMLTable.this.startFontTag + hlcHTMLTable.this.fontSize + ">" + this.text + "</FONT></TD>";
            }
            return "<TD" + this.cellAlign + ">" + hlcHTMLTable.this.startFontTag + hlcHTMLTable.this.fontSize + ">" + this.text + "</FONT></TD>";
        }
    }
}

