#! /usr/local/orexx/bin/rexx
/****************************************************************************/
/* Name:        tget.cmd                                                    */
/* Function:    Get the whole directory tree                                */
/* Type:        Object REXX Script                                          */     
/*                                                                          */     
/* Requirement: xFtp.cls and ftp framework ftp.frm                          */
/****************************************************************************/      
curmode = .false
 
ftp = .xFtp~new                         -- create ftp object
ftp~debug = .true                       -- request debug messages 
                                        -- connect to server 
if ftp~connect('host', 'userid', 'password') \= 0 then exit 
say ftp~sys(sys)                        -- determine ftp-server type
say 'remote slash' ftp~rslash           -- remote slash   

if curmode then do
  /*------------------------------------------------------------------------*/
  /* Get contents of current directory including all its subdirectories     */
  /*------------------------------------------------------------------------*/
  if ftp~cd('usr')=-1 then signal error -- change to remote directory
  say 'current remote directory:' ftp~pwd
  say
  rc = ftp~getRDirList()                -- show what's in there 
  if rc \= -1 & rc \= 0 then do
    say 'files/directories found in "usr":'
    do entry over rc; say entry; end
  end 
  else signal error

  say '-----tget()----------------'
  say 'get all files/directories from the current remote directory'      
  rc = ftp~tget(, mydir)                -- get current dir content into mydir
  say 'remote files/directories received with rc =' rc 
end 
else do
  /*------------------------------------------------------------------------*/
  /* Get directory dir including all its subdirectories into local ldir     */
  /*------------------------------------------------------------------------*/
  say 'remote dir:' ftp~pwd
  rc = ftp~getRDirList('usr')           -- show what's in there 
  if rc \= -1 & rc \= 0 then do
    say 'files/directories found in "usr":'
    do entry over rc; say entry; end
  end 
  else signal error

  say '-----tget(dir,ldir)------'
  say 'get the remote directory "usr" and all its subdirectories'      
  rc = ftp~tget('usr', 'mydir') 
  say 'remote directory tree received in "mydir" with rc =' rc 
end
say '---------------------------'
say 'current local dir:' directory()    -- show that it returned to current directory 

error:
  say 'logoff:' ftp~logoff              -- logoff from server
  exit 0

::REQUIRES "xftp.cls"                                          