#! /usr/local/orexx/bin/rexx
/****************************************************************************/
/* Name:        mget.cmd                                                    */
/* Function:    Get multiple files                                          */
/* Type:        Object REXX Script                                          */     
/*                                                                          */     
/* Requirement: xFtp.cls and ftp framework ftp.frm                          */
/****************************************************************************/      

ftp = .xFtp~new                         -- create ftp object
ftp~debug = .true                       -- request debug messages 
                                        -- connect to server 
if ftp~connect('host', 'userid', 'password') \= 0 then exit 
say ftp~sys(sys)                        -- determine ftp-server type
say 'remote slash' ftp~rslash           -- remote slash   
say 'remote dir:' ftp~pwd               -- display remote directory
say
say 'local dir:' directory('getdir')    -- display local directory  
say '-----get(fname)------------'
say 'gets file "myfile.txt" from current remote directory'      
rc = ftp~get('myfile.txt')              -- use base ftp method
say 'remote file "myfile.txt" received with rc =' rc 
say
say 'local dir:' directory('target1')   -- display local directory  
say '-----mget()----------------'
say 'gets all files from current remote directory'      
rc = ftp~mget()                         -- use  xftp method
say 'remote files received with rc =' rc 
say
say 'local dir:' directory('..\target2')-- display local directory  
say '-----mget(,dir)------------'
say 'gets all files from remote directory "usr"'      
rc = ftp~mget(, 'usr')                  -- use xftp method
say 'remote files received with rc =' rc 
say  
say 'local dir:' directory('..\target3')-- display local directory  
say '-----mget(pattern,dir)-----'
say 'gets all files from remote directory "usr" matching pattern "*.txt"'      
rc = ftp~mget('*.txt', 'usr')           -- use xftp method
say 'remote files received with rc =' rc 
say
say 'logoff:' ftp~logoff 
exit 0 

::REQUIRES "xftp.cls"