/********************************************************/
/*                                                      */
/* RSERVERD.CMD - IBM REXX Sample Program               */
/*                                                      */
/* Server daemon for remote control server. This        */
/* program listens at the well know port address for    */
/* connecting clients. After a client has connected a   */
/* new process is started that will handle the remote   */
/* commands.                                            */
/*                                                      */
/* Parameters:                                          */
/*   Port: if not the default port 1234 should be used  */
/*         then it has to be specified here             */
/*                                                      */
/* ---------------------------------------------------- */
/* (C) Copyright IBM Corp. 1996 - All Rights Reserved.  */
/*                                                      */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed]  */
/* code is sample code created by IBM Corporation. This */
/* sample code is not part of any standard or IBM       */
/* product and is provided to you solely for the        */
/* purpose of assisting you in the development of your  */
/* applications.  The code is provided "AS IS", without */
/* warranty of any kind.  IBM shall not be liable for   */
/* any damages arising out of your use of the sample    */
/* code,  even if they have been advised of the         */
/* possibility of such damages.                         */
/*                                                      */
/********************************************************/
Parse Arg Port
If Port = "" Then
  Port = 1234

/* Load REXX Socket library if not already loaded       */
If RxFuncQuery("SockLoadFuncs") Then
 Do
   Call RxFuncAdd "SockLoadFuncs","RXSOCK","SockLoadFuncs"
   Call SockLoadFuncs
 End

/* Open socket at well known port and wait for clients  */
Socket = ListenPort(Port)
If Socket = -1 Then
  Exit 1

/* close the socket when program is interrupted         */
Signal On Halt

Do Forever
  /* wait for client to connect and start handler       */
  Say "Waiting for client to connect."
  Say "Press Ctrl-C to exit program."
  ClientSocket = SockAccept(Socket)
  Say "Client connected, starting handler process."
  "start rserverh.cmd" ClientSocket
End

Halt:
Call Close Socket
Exit


/********************************************************/
/*                                                      */
/* Function:  ListenPort                                */
/* Purpose:   Create a socket, bind it to a port and    */
/*            listen at the port for connecting clients.*/
/* Arguments: Port - port number                        */
/* Returns:   Socket number if successful, -1 otherwise */
/*                                                      */
/********************************************************/
ListenPort: Procedure
  Parse Arg Port

  /* create a TCP socket                                */
  Socket = SockSocket("AF_INET", "SOCK_STREAM", "0")
  If Socket < 0 Then
   Do
     Say "Unable to create socket"
     Return -1
   End

  /* find out local IP address and bind socket to port  */
  Host.!addr = SockGetHostId()
  Host.!family = "AF_INET"
  Host.!port = Port
  rc = SockBind(Socket, "Host.!")
  If rc < 0 Then
   Do
     Say "Unable to bind to port:" Port
     Call Close Socket
     Return -1
   End

  /* listen at the port, allow 5 clients in queue       */
  rc = SockListen(Socket, 5)
  If rc < 0 Then
   Do
     Say "Unable to listen at port:" Port
     Call Close Socket
     Return -1
   End

  Return Socket


/********************************************************/
/*                                                      */
/* Procedure: Close                                     */
/* Purpose:   Close the specified socket.               */
/* Arguments: Socket - active socket number             */
/* Returns:   nothing                                   */
/*                                                      */
/********************************************************/
Close: Procedure
  Parse Arg Socket

  Call SockShutDown Socket, 2
  Call SockClose Socket
  Return
