/*****************************************************************************/
/* Loan Amotisation Calculated with Object REXX                     www2.cmd */ 
/*                                                                           */
/* (C) Copyright IBM Corporation 1999.                                       */
/*                                                                           */
/* This code is sample code, provided "AS IS", without warranty of any kind  */
/*****************************************************************************/

use arg type, list, address            /* get the arguments                  */

parm = .parmdir~new(list)              /* create parameter directory         */

amount = parm['amount']                /* get parameter values               */ 
interest = parm['interest']
years = parm['years']
fyears = parm['fyears']

NUMERIC DIGITS 14                      /* define the degree of accuracy      */

html = .myHtml~new                     /* create an html object              */ 
html~title('Loan amortization calculated with Object REXX')
html~a('top', .html~new~h2('Loan amortization input'))
html~p('Enter the following values and press' blink('"Calculate"') 'to calculate the payment figures.')
html~p

if interest~DataType("N") = 0 then
  interest = 9
if fyear~DataType("N") = 0 then 
  fyear = date()~right(4)

html~form("/cgi-bin/orxwww/www2")      /* input form aligned in a table      */
html~table("border=0 cellpadding=1")
html~tr                                /* table row                          */
html~td("Loan principal amount:")
html~td~itext("amount", amount)~etd
html~td("US$")
html~tr;                               /* table row                          */
html~td("Annual interest rate:")
html~td~itext("interest", interest)~etd
html~td("%") 
html~tr                                /* table row                          */
html~td("Loan period:")
html~td~itext("years", years)~etd
html~td("years")
html~tr                                /* table row                          */
html~td("Base year of loan:")
html~td~itext("fyear", fyear)~etd
html~etable
html~p~submit("submit", "Calculate")   /* calculate button                   */
html~eform

/* append the calculated data to input form                                  */
                                       /* Calculate button was pushed        */
if parm['submit'] = 'Calculate' then do
                                       /* perform calculations               */
  q = 1 + interest/100/12
  ann = amount*q**(years*12)*(q - 1)/(q**(years*12) - 1)
  tot_pay = ann*12*years

  /* display the results header                                              */
  html~hr                             
  html~h2('Payment overview')
  html~p('The following figures are for monthly payment afterwards.')
  html~p

  /* do key figures table                                                    */
  html~table('border=5 cellpadding=5')
  html~tr~td("Annual loan payments:")~td('$'Format(ann*12, , 2), 'align=right')
  html~tr~td("Monthly loan payments:")~td('$'ann~format(, 2), 'align=right')
  html~tr~td("Interest over term of loan:")~td('$'Format(tot_pay-amount, , 2), 'align=right')
  html~tr~td("Sum of all payments:")~td('$'tot_pay~format(, 2), 'align=right')
  html~etable

  /* amortization table with as many rows as the loan period                 */       
  html~h2('Amortization table')
  html~p
  html~table('border=1 cellpadding=4')
  html~tr                              /* new table row with table headers   */
  html~th('Year')~th('Balance')~th('Payments')~th('Principal')~th('Interest')
  html~th('Cum. Principal')~th('Cum. Interest')~th('Ending Balance')

  bal = amount
  c_principal = 0
  c_int = 0

  /* process the detailed information table                                  */
  do y = fyear + 1 to fyear + years
    html~tr
    html~td(y, 'align=center')
    html~td(bal~format(, 2), 'align=right')/* format with 2 digits after .   */

    bal_e = bal*q**12 - ann*(q**12 - 1)/(q - 1)
    a_int = ann*12-(bal-bal_e)

    html~td(Format(ann*12, , 2), 'align=right')
    html~td(Format(bal-bal_e, , 2), 'align=right')
    html~td(a_int~format(, 2), 'align=right')

    c_principal = c_principal + bal-bal_e

    html~td(c_principal~format(, 2), 'align=right')

    c_int = c_int + a_int

    html~td(c_int~format(, 2), 'align=right')
    html~td(bal_e~format(, 2), 'align=right')

    bal = bal_e
  end 
  html~etable
  html~pc~tt("This sample is based on a Lotus 123 example and was adapted for this sample.")
  html~pc~aref('#top','Back to Input')~p
end    

html~footing("/orxwww/www2.cmd")       /* footing with code reference        */
return html~end                        /* end HTML document and return it    */

::requires "myhtml.cls"                /* load the myHtml class              */  
