/********************************************************/
/*                                                      */
/* INSCNT1.CLS - IBM Object REXX Sample Program         */
/*                                                      */
/* Sample class definition file for an instance counter */
/* defined as a metaclass.                              */
/*                                                      */
/* ---------------------------------------------------- */
/* (C) Copyright IBM Corp. 1997 - All Rights Reserved.  */
/*                                                      */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed]  */
/* code is sample code created by IBM Corporation. This */
/* sample code is not part of any standard or IBM       */
/* product and is provided to you solely for the        */
/* purpose of assisting you in the development of your  */
/* applications.  The code is provided "AS IS", without */
/* warranty of any kind.  IBM shall not be liable for   */
/* any damages arising out of your use of the sample    */
/* code,  even if they have been advised of the         */
/* possibility of such damages.                         */
/*                                                      */
/********************************************************/
::CLASS InstanceCounter PUBLIC SUBCLASS Class

/* initialize the counter to 0 when a new class is created */
::METHOD Init
  Expose InstanceCounter
  InstanceCounter= 0
  Forward Class (Super)

/* increase the counter by one when a new object is created */
::METHOD New
  Expose InstanceCounter
  InstanceCounter = InstanceCounter + 1
  Forward Class(Super)

/* return the number of created instances */
::METHOD Instances
  Expose InstanceCounter
  Return InstanceCounter
