/**********************************************************************/
/*                                                                    */
/* SAMP07.REX: OLE Automation with Object REXX - Sample 7             */
/*                                                                    */
/* Create a new spreadsheet in 1-2-3 and fill in a table with fictive */
/* revenue numbers. The table will also contain a calculated field    */
/* and different styles. A second sheet is added with a 3D chart      */
/* displaying the revenue data.                                       */
/*                                                                    */
/* ------------------------------------------------------------------ */
/* (C) Copyright IBM Corp. 1998 - All Rights Reserved.                */
/*                                                                    */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is sample */
/* code created by IBM Corporation. This sample code is not part of   */
/* any standard or IBM product and is provided to you solely for the  */
/* purpose of assisting you in the development of your applications.  */
/* The code is provided "AS IS", without warranty of any kind.  IBM   */
/* shall not be liable for any damages arising out of your use of the */
/* sample code,  even if they have been advised of the possibility of */
/* such damages.                                                      */
/*                                                                    */
/**********************************************************************/

/* create a new 123 Workbook */
Workbook = .OLEObject~New("Lotus123.Workbook")
Range = Workbook~Ranges("A1")
Range~Contents = "Object REXX OLE Sample spreadsheet"

/* fill the first column with month names */
Col = "A"
Row = 3
Range = Workbook~Ranges(Col || Row)
Range~Contents = "Month"
Range~Font~FontName = "Times New Roman"
Range~Font~Bold = "True"

Do Month = 1 To 12
  Row = Row + 1
  Range = Workbook~Ranges(Col || Row)
  Range~Contents = '"' || Right(Month, 2, "0") || "/98"
  Range~TextHorizontalAlign = "$AlignLeft"
End

Row = Row + 1
Range = Workbook~Ranges(Col || Row)
Range~Contents = "All 1998"
Range~Font~Bold = "True"

/* fill the second column with random revenue numbers */
Col = "B"
Row = 3
Range = Workbook~Ranges(Col || Row)
Range~Contents = "Revenue"
Range~Font~FontName = "Times New Roman"
Range~Font~Bold = "True"

Do Month = 1 To 12
  Row = Row + 1
  Range = Workbook~Ranges(Col || Row)
  Range~Contents = Random(20000, 100000)
  Range~FormatName = "US Dollar"
  Range~FormatDecimals = 0
End

Row = Row + 1
Range = Workbook~Ranges(Col || Row)
Range~Contents = "@SUM(B4..B15)"
Range~Font~Bold = "True"
Range~FormatName = "US Dollar"
Range~FormatDecimals = 0

/* put a grid around the table */
Range = Workbook~Ranges("A3..B16")
Range~GridBorder~Style = "$SolidBorder"

/* use thick bottom lines for title and sum lines */
Range = Workbook~Ranges("A3..B3")
Range~BottomBorder~Style = "$DoubleBorder"
Range = Workbook~Ranges("A16..B16")
Range~TopBorder~Style = "$DoubleBorder"


/* create a 3d chart showing revenue over month */
Sheet = Workbook~NewSheet("$Last", 1, "False")
Range = Workbook~Ranges("A:A4..A:B15")
Chart = Sheet~NewChart(0, 0, 12800, 9600, Range)
Chart~Is3D = .True
Chart~Title~Lines(1)~Text = "Revenue development 1998"
Chart~Legend~Visible = .False

Chart~XAxis~Title~Text = "Month"
Chart~XAxis~Title~Font~Size = "36"
Chart~XAxis~TickLabels~Font~Size = "36"

Chart~YAxis~Title~Text = "Revenue"
Chart~YAxis~Title~Font~Size = "36"
Chart~YAxis~TickLabels~Font~Size = "36"
Chart~YAxis~SubTitle~Visible = .False

/* save spreadsheet as file OLETest */
Workbook~SaveAs("OLETest")
Workbook~Close

::REQUIRES OREXXOLE.CLS
