/**********************************************************************/
/*                                                                    */
/* SAMP06.REX: OLE Automation with Object REXX - Sample 6             */
/*                                                                    */
/* Create a new document in WordPro 97 with a provided Smartmaster.   */
/* Fill in some "Click here" fields with data prompted by the program */
/* or queried from the system. Finally the document will be saved to  */
/* the same directory where this REXX program is located and sent to  */
/* the printer.                                                       */
/*                                                                    */
/* Since no check is done do ensure the new document does not already */
/* exist you will get a popup message from WordPro asking to          */
/* overwrite an already existing document when this sample is run     */
/* multiple times.                                                    */
/*                                                                    */
/* ------------------------------------------------------------------ */
/* (C) Copyright IBM Corp. 1998 - All Rights Reserved.                */
/*                                                                    */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is sample */
/* code created by IBM Corporation. This sample code is not part of   */
/* any standard or IBM product and is provided to you solely for the  */
/* purpose of assisting you in the development of your applications.  */
/* The code is provided "AS IS", without warranty of any kind.  IBM   */
/* shall not be liable for any damages arising out of your use of the */
/* sample code,  even if they have been advised of the possibility of */
/* such damages.                                                      */
/*                                                                    */
/**********************************************************************/

/* determine path of this sample program */
Parse Source . . ProgName
ProgPath = ProgName~Left(ProgName~LastPos("\"))

/* determine the version of REXX currently running */
Parse Version VersStr

/* prompt user for some information */
Say "Please enter your name:"
Parse Pull Name
If Name~Length = 0 Then
  Name = "No name entered!"

Say "Please enter your phone number:"
Parse Pull Phone
If Phone~Length = 0 Then
  Phone = "No phone entered!"

/* create a new document */
WordProApp = .OLEObject~New("WordPro.Application.97")
WordProApp~NewDocument("Samp06.lwp", ProgPath, ProgPath || "Samp06.mwp")

/* replace the click here blocks in the document with the new values */
WordProApp~Foundry~ClickHeres("YourName")~InsertText(Name)
WordProApp~Foundry~ClickHeres("YourPhone")~InsertText(Phone)
WordProApp~Foundry~ClickHeres("ProgramName")~InsertText(ProgName)
WordProApp~Foundry~ClickHeres("RexxVersion")~InsertText(VersStr)

WordProApp~Save
WordProApp~PrintOut(1, 1, 1, .True)

WordProApp~Close(.False)
WordProApp~Quit

::REQUIRES OREXXOLE.CLS
