/**********************************************************************/
/*                                                                    */
/* SAMP05.REX: OLE Automation with Object REXX - Sample 5             */
/*                                                                    */
/* Create a new document in WordPro 97, enter some text with          */
/* different attributes and finally save and print the document.      */
/*                                                                    */
/* Since no check is done do ensure the new document does not already */
/* exist you will get a popup message from WordPro asking to          */
/* overwrite an already existing document when this sample is run     */
/* multiple times.                                                    */
/*                                                                    */
/* ------------------------------------------------------------------ */
/* (C) Copyright IBM Corp. 1998 - All Rights Reserved.                */
/*                                                                    */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is sample */
/* code created by IBM Corporation. This sample code is not part of   */
/* any standard or IBM product and is provided to you solely for the  */
/* purpose of assisting you in the development of your applications.  */
/* The code is provided "AS IS", without warranty of any kind.  IBM   */
/* shall not be liable for any damages arising out of your use of the */
/* sample code,  even if they have been advised of the possibility of */
/* such damages.                                                      */
/*                                                                    */
/**********************************************************************/

WordProApp = .OLEObject~New("WordPro.Application.97")
WordProApp~NewDocument("AutomatedDocument.lwp","","default.mwp")
WPDoc = WordProApp~ActiveDocument
WPDocText = WordProApp~Text

WordProApp~Type("This is the first paragraph entered from REXX via ")
WordProApp~Type("the OLE automation classes.[Enter]")

WordProApp~Type("The second paragraph will be changed in its ")
WordProApp~Type("appearance.")
WordProApp~SelectParagraph
WPDocText~Font~Name = "Arial"
WPDocText~Font~Bold = .True
WPDocText~Font~Italic = .True
WPDocText~Font~Size = 15

WordProApp~Type("[End][Enter][End]Document created at:" Time("N") "on" Date("N"))

WPDoc~Save
WordProApp~PrintOut(1, 1, 1, .True)
WPDoc~Close
WordProApp~Quit

::REQUIRES OREXXOLE.CLS
