/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  NetCentric Computing with Object Rexx                                   */
/*  Programming Example                                                     */
/*                                                                          */
/*    IBM Corporation 1998                                                  */
/*                                                                          */
/*  Security.frm  -  Sample security classes                                */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* dumper class definition (for auditing actions)                           */
/*--------------------------------------------------------------------------*/
::class dumper PUBLIC

::method init
  expose stream                        /* target stream for output          */
  use arg stream                       /* hook up the output stream         */

::method unknown                       /* generic unknown method            */
  expose stream                        /* need the global stream            */
  use arg name, args                   /* get the message and arguments     */
                                       /* write out the audit event         */
  stream~lineout(time() date() 'Called for event' name)
  stream~lineout('- Argments are:')    /* write out the arguments           */
  info = args[1]                       /* info directory is the first arg   */
  do name over info                    /* dump the info directory           */
    stream~lineout('  Item' name':' info[name])
  end
  return 0                             /* allow this to proceed             */


/*--------------------------------------------------------------------------*/
/* replacer class definition  (for replacement actions)                     */
/*--------------------------------------------------------------------------*/
::class replacer subclass NoWay PUBLIC /*                                   */

::method command                       /* issuing commands                  */
  use arg info                         /* access the directory              */

  say "execution of" info~address "'"|| info~command ||"' intercepted"
  info~rc = 1234                       /* set the command return code       */
  info~failure = .true                 /* raise a FAILURE condition         */
  return 1                             /* return "handled" return value     */

::method call                          /* external function/routine call    */
  use arg info                         /* access the directory              */

  say "call to function" info~name "intercepted, result replaced"
                                       /* all results are the same          */
  info~result = "dummy"
  return 1                             /* return "handled" return value     */

::method stream                        /* I/O function stream lookup        */
  use arg info                         /* access the directory              */

  say "stream I/O for" info~name "intercepted; stream replaced"
                                       /* replace with a different stream   */
  info~stream = .stream~new('replacer.txt')
  return 1                             /* return "handled" return value     */
  
::method local                         /* .LOCAL variable lookup            */
  use arg info                         /* access the directory              */

  if info~name = 'STREAM' then         /* check the index                   */
    return 0                           /* ... let the stream go             */

  say ".LOCAL variable lookup for" info~name "intercepted; handled as not found"
                                       /* no value returned at all          */
  return 1                             /* return "handled" return value     */

::method environment                   /* .ENVIRONMENT variable lookup      */
  use arg info                         /* access the directory              */

  if info~name = 'STREAM' then         /* check the index                   */
    return 0                           /* ... let the stream go             */

  say ".ENVIRONMENT variable lookup for" info~name "intercepted; handled as not found"
                                       /* no value returned at all          */
  return 1                             /* return "handled" return value     */
  
::method method                        /* protected method invocation       */
  use arg info                         /* access the directory              */

  say "method" info~name "invocation intercepted; result replaced"
                                       /* all results are the same          */
  info~result = "uh, uh, uh...you didn't say the magic word!"
  return 1                             /* return "handled" return value     */

::method requires                      /* REQUIRES directive                */
  use arg info                         /* access the directory              */

  name = info~name                     /* check for router requires         */
  if name = 'router.cmd' | name = 'router' then  
    info~name = 'routerd.cmd'          /* switch to load the default router */
  else                                 /* any other requires                */ 
    info~name = 'replacer.cmd'         /* switch to load a different file   */

  say '::requires' name 'intercepted; replaced by "'info~name'"'
  info~securitymanager = self          /* load under this authority         */
  return 1                             /* return "handled" return value     */

/*--------------------------------------------------------------------------*/
/* noway class definion (for closed cell), the default                      */
/*--------------------------------------------------------------------------*/
::class noWay PUBLIC

::method unknown                       /* everything trapped by unknown     */
                                       /* is an error (no magic!)           */
  raise syntax 98.948 array("You didn't say the magic word!")

