/*--------------------------------------------------------------------------*/
/* Generation of a Client/Server Applications Folder                        */
/* - Create a WPShell folder and set the title and folder icon              */
/* - Add a Chat Server program to it and set the title, program icon, ...   */
/* - Add a Chat Client program to it and set the title, program icon, ...   */
/* - Add an Agency Server program to it and set the title, program icon, .. */
/* - Add a Agency Client program to it and set the title, program icon, ... */
/* - Open the folder and make it current                                    */
/*--------------------------------------------------------------------------*/

path = 'd:\socketsx\'                  /* with trailing backslash!          */
pathi = 'd:\socketsx\install\'         /* with trailing backslash!          */
paths = 'd:\socketsx\swork\'           /* with trailing backslash!          */
pathc = 'd:\socketsx\cwork\'           /* with trailing backslash!          */
                                       /* Load RxSock interface             */
if RxFuncQuery("SockLoadFuncs") then do
  rc = RxFuncAdd("SockLoadFuncs", "rxsock", "SockLoadFuncs")
  rc = "SockLoadFuncs"()
end

hoststring = SockGetHostId()           /* get the host id of your system    */
if hoststring~left(1)~datatype('N') then
  rc = SockGetHostByAddr(hoststring, "Host.!")
else
  rc = SockGetHostByName(hoststring, "Host.!")

if rc = 0 then do
  say "Error" h_errno "accessing host. '"hoststring"' unknown."
  return
end
                                       /* get the host name                 */
host = Host.!name~translate(' ','.')~word(1)
call WPconst                           /* add WP constants to global env.   */
                                       /* Create new folder on the desktop  */
folder = .WPfolder~new('Client/Server Apps' '0d0a'x 'with Object Rexx' ,'ICONFILE='pathi'csfolder.ico;',.WPdesktop,1)
                                       /* Add program object to the folder  */
cserver = .WPprogram~new('Chat Server' '0d0a'x host,'EXENAME=pmrexx.exe;PARAMETERS=Chat_sx;ICONFILE='pathi'server.ico;STARTUPDIR='path, folder,1)
                                       /* Add program object to the folder  */
cclient = .WPprogram~new('A Chat Client','EXENAME=pmrexx.exe;PARAMETERS=Chat_c [Enter hostname and client alias] 1;ICONFILE='pathi'Chat_c.ico;STARTUPDIR='path, folder,1)
                                       /* Add program object to the folder  */
aserver = .WPprogram~new('Agency Server' '0d0a'x host,'EXENAME=pmrexx.exe;PARAMETERS=Agency;ICONFILE='pathi'server.ico;STARTUPDIR='paths, folder,1)
                                       /* Add program object to the folder  */
aclient = .WPprogram~new('An Agency Client','EXENAME=pmrexx.exe;PARAMETERS=Clientx [Enter hostname and client alias] [Enter your enabling password];ICONFILE='pathi'Client.ico;STARTUPDIR='pathc, folder,1)
                                       /* Open folder and make it current   */
folder~WPopen(0,.WPconst['OPEN_DEFAULT'],0)
folder~WPswitchto(0)

