/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  NetCentric Computing with Object Rexx                                   */
/*  Programming Example                                                     */
/*                                                                          */
/*    Kurt Maerker       Kurt_Maerker@vnet.ibm.com                          */
/*                                                              03/03/97    */
/*  Yodel_c.cmd  -  Session Client using TCP/IP Sockets                     */
/*                                                                          */
/*    Client program for the server. Ask the user for a string,             */ 
/*    send the string to the server and display the result string.          */
/*                                                                          */
/*    Parameters:                                                           */
/*      Port:   server port number                                          */
/*      Server: alias name of the server                                    */
/*                                                                          */
/*--------------------------------------------------------------------------*/

Parse Arg Port Server 
if Port = '' then Port = 1923          /* Default is yodel server           */

client = .yodelClient~new(Server, Port)/* create client for server via port */

if client~connected then do            /* Is client connected to server?    */
  client~raiseVoice                    /* process session until 'quit'      */ 
  client~hearAnswer                    /* receive and display returned data */ 
end

client~shutdown                        /* shutdown client                   */
return

/****************************************************************************/

::REQUIRES "clients.frm"               /* Use the clients framework         */   

/*--------------------------------------------------------------------------*/
/* myClient Class definition                                                */
/*--------------------------------------------------------------------------*/
::CLASS yodelClient SUBCLASS tcpClient

/*--------------------------------------------------------------------------*/
::METHOD raiseVoice 
  reply                                /* Frees up other concurrent work    */ 
                                       /* Watch for additional return data  */
  do until self~Input~word(1)~translate = 'QUIT' 
                                       /* get input from user               */
    rc = self~promptInput("Please enter your words to be yodeled") 
    if rc < 0 then leave               /* if error quit client session      */
  end 

/*--------------------------------------------------------------------------*/
::METHOD hearAnswer UNGUARDED
                                       /* Watch for additional return data  */
  do until RetString = ">>>End_of_session<<<"  
    rc = self~receive                  /* receive the returned string       */
    if rc < 0 then leave               /* if error terminate receive loop   */
    RetString = self~Output            /* get the output received           */
    Say "*" RetString                  /* show the result                   */
  end

