/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  NetCentric Computing with Object Rexx                                   */
/*  Programming Example                                                     */
/*                                                                          */
/*    Kurt Maerker       Kurt_Maerker@vnet.ibm.com                          */
/*                                                              03/03/97    */
/*  Mirror_S.cmd  -  default TCP/IP Server from "NewSocks" Server           */
/*                                                                          */
/*--------------------------------------------------------------------------*/

aMirrorServer = .MirrorServer~new(1921)/* Create mirror server at port 1921 */ 
aMirrorServer~startAccepting           /* method inherited from "tcpServer" */    
aMirrorServer~shutdown                 /* server shutdown                   */    


/****************************************************************************/
                                       
::REQUIRES "servers.frm"               /* Load the servers framework        */   

/*--------------------------------------------------------------------------*/
/* MirrorServer Class definition                                            */
/*--------------------------------------------------------------------------*/
::CLASS MirrorServer SUBCLASS tcpServer PUBLIC

::METHOD NewClient                     /* Over-write superclass method      */    
  use arg cSocket
                                       /* Get reversed packet back to client*/   
  cSocket~SendData(reverse(cSocket~ReceiveData))
  cSocket~Close                        /* Close client's socket             */  
  return                         
