;
;	u/micro size registors setter for CT65535 of PC110
;	named ct65535u.exe
;
;		2018.10.01	Begin of all
;		2019.07.18	start of micro
;			19	check keys and make file
;			21	OK ! built in to the boot sector
;
;------------------------------------------------
	.286
	.model	medium
	.stack	200h

	.data
mbuf	db	512 dup(2)
extf	db	512 dup(?)
hand	dw	0000h
drvno	db	80h
prmsg	db	cr,lf,"Drv : $"
ummsg	db	" Boot sector Set/ Get/ Rnw/ Pst/ Clr/ Dis/ Qut(Esc) ? = $"
flnam	db	"sectdata.bin",00h
drmsg	db	cr,lf,"Error code : $"

bs	equ	08h
cr	equ	0dh
lf	equ	0ah
esk	equ	1bh
;DOS int
rdky	equ	01h		;al
wrch	equ	02h		;dl
rdch	equ	08h		;al
wrln	equ	09h		;ds:dx
rdln	equ	0ah		;ds:dx | Enter for end
drtn	equ	4ch		;return
mkfl	equ	3ch		;make
opfl	equ	3dh		;open
clfl	equ	3eh		;close
rdfl	equ	3fh		;read
wrfl	equ	40h		;write
flpo	equ	42h		;position

;Index register & Value of register
ireg	equ	3d6h
vreg	equ	3d7h

DOS	macro	cmd
	mov	ah,cmd
	int	21h
	endm

;------------------------------------------------

	.code
	org	100h
start:	jmp	pinit
rhere:

	org	200h
;micro program start point
wtreg:	push	ax
	push	dx
	push	si
;write TFT value to registers
	lea	ax,ptable
	mov	si,ax
wtrg0:	mov	al,byte ptr cs:[si]
	cmp	al,0ffh
	jne	wtrg1
	pop	si
	pop	dx
	pop	ax
;
	cli			;FA	1 byte
	xor	ax,ax		;33C0	2 bytes
	jmp	rhere		;goto BIOS boot start address
;
wtrg1:	mov	dx,ireg		;=3d6h
	out	dx,al
	mov	al,byte ptr cs:[si+1]
	mov	dx,vreg		;=3d7h
	out	dx,al
	add	si,2
	jmp	wtrg0
;parameter table
ptable:	db	06h,0c0h	;No color reduction
	db	19h,00h		;Alt Hsync Start(CR04)
	db	1ah,7fh		;Alt Hsync End(CR05)
	db	1bh,0a0h		;Alt H Total(CR00)
	db	1ch,7fh		;Panel Width
	db	1dh,00h
	db	2ch,00h		;FLM Delay
	db	2dh,9fh		;LP Delay
	db	2eh,9fh		;LP Delay
	db	2fh,3fh		;LP Plus Width
	db	4fh,0c6h	;LP/M change to DE
	db	50h,0ah		;Clock divide, Dither, FRC
	db	51h,0c4h	;change to LCD on 4h !!!
	db	52h,42h		;for 'Panel On'
	db	53h,00h		;for FRC
	db	54h,0c8h	;Negative Polarity
	db	55h,0e5h	;H Auto Doubling
	db	56h,02h		;H Centering
	db	57h,00h		;V Stretch Mode
	db	59h,00h		;V H/W Line Replication
	db	5ah,04h		;V Line Repl Height
	db	64h,0e0h
	db	65h,27h		;Alt V Total(CR06)
	db	67h,0ch		;Alt Vsync End(CR11)
	db	68h,0dfh	;Panel Height / low
	db	0ffh,0ffh
	db	0ffh,0ffh
etable:

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;program start point
pinit:	mov	ax,@data	; !
	mov	ds,ax
	mov	es,ax
	mov	[drvno],80h
	call	dskrd		;disk read
	call	opfil		;1st open, get handle
	jnc	init
	call	mkfil		;make new file only once
init:	lea	dx,prmsg
	DOS	wrln
	mov	al,[drvno]
	call	dshx
	call	dssp
	lea	dx,ummsg
	DOS	wrln
	DOS	rdky
	call	crlf
	and	al,0dfh
	cmp	al,"S"
	jne	star0
;--------------------------------------
; for Set data to disk
	call	dsbuf
	call	dskwr		;disk write
	jmp	short finsh
;next check
star0:	cmp	al,"G"
	jne	star1
;--------------------------------------
; for Get gata from disk to mbuf
	call	dskrd
	call	dsbuf
	jmp	short finsh
;next
star1:	cmp	al,"R"
	jne	star2
;--------------------------------------
; for Recover with file data
	call	opfil
	call	rdfil		;read file
	call	dsbuf
;	call	dskwr		;disk write
	jmp	short finsh
;next
star2:	cmp	al,"D"
	jne	star3
;--------------------------------------
; for Display
	call	dsbuf		;display current mbuf
	jmp	short finsh
;next
star3:	cmp	al,"P"
	jne	star4
;--------------------------------------
; for Paste
	call	paste		;paste data on mbuf
	call	dsbuf
	jmp	short finsh
;next
star4:	cmp	al,"C"
	jne	star5
;--------------------------------------
; for clear mbuf
	call	clbuf		;clear mbuf
	call	dsbuf
	jmp	short finsh
;next
star5:	cmp	al,"3"+1-20h
	jnc	star6
	cmp	al,"0"-20h
	jc	star6
	sub	al,"0"-20h
	cmp	al,2
	jc	sta55
	add	al,80h-2	;HDD >= 2
sta55:	mov	[drvno],al	;set drv no.0-4
	call	dskrd
	call	dsbuf
	jmp	short finsh
star6:	cmp	al,"?"-20h
	jne	star7
	call	mimsg		;mini instruction
	clc
	jmp	short finsh
star7:	cmp	al,"Q"		;End ?
	jne	star8
	xor	al,al
	DOS	drtn
;next
star8:	cmp	al,esk		;End ?
	jne	star9
	xor	al,al
	DOS	drtn
star9:
	clc
;end of key command
finsh:	jc	finse
;	call	crlf
	jmp	init
;error message 2 byte code
finse:	call	ermsg
	jmp	init
;--------------------------------------
ermsg:	lea	dx,drmsg
	DOS	wrln
	call	dsax
	jmp	crlf
;--------------------------------------
;Paste data ct65535u to mbuf
paste:	mov	ax,0fde9h		;=jmp 200h
	mov	word ptr [mbuf],ax
	mov	byte ptr [mbuf+2],0
	cld
	push	ds
	mov	ax,cs
	mov	ds,ax
	lea	si,wtreg
	lea	di,mbuf+100h	;just !?
	mov	cx,etable-wtreg
	repnz	movsb
	pop	ds
	xor	al,al
	ret
;----------------------------
;Disk read
dskrd:	lea	bx,mbuf		;ds, es = .data
	mov	cx,10		;retry count
dskr0:	push	cx
	mov	cx,0001h	;cylider=0, sector=1
	mov	dh,00h		;head no=0
	mov	dl,[drvno]	;drive FDD=00h, HDD=80h
	mov	ax,0201h	;service=2, count =1
	int	13h		;BIOS disk service
	pop	cx
	jnc	dskre
	loopnz	dskr0
	stc
	jmp	short ermsg
dskre:	xor	al,al
	ret
;----------------------------
;Disk write
dskwr:	lea	bx,mbuf		;ds, es = .data
	mov	cx,10		;retry count
dskw0:	push	cx
	mov	cx,0001h	;cilider=0, sector=1
	mov	dh,00		;head no=0
	mov	dl,[drvno]	;drive FDD=00h, HDD=80h
	cmp	dl,80h
	jnc	dskw1		;not write to FDD
	pop	cx
	jmp	short ermsg
dskw1:	mov	ax,0301h	;service=3, count =1
	int	13h
	pop	cx
	jnc	dskwe
	loopnz	dskw0
	stc
	jmp	short ermsg
dskwe:	xor	al,al
	ret
;----------------------------
;Make new file
mkfil:	lea	dx,flnam
	DOS	mkfl
	jc	errmk
	mov	word ptr [hand],ax
	call	wrfil
	xor	al,al
errmk:	ret
;----------------------------
;Open file
opfil:	xor	cx,cx
	lea	dx,flnam
	DOS	opfl		;open file
	jc	errop
	mov	word ptr [hand],ax
	xor	ax,ax
errop:	ret
;----------------------------
;Write to file from buffer
wrfil:	mov	bx,word ptr [hand]
	mov	cx,512
	lea	dx,mbuf
	DOS	wrfl		;save data
	jc	errwr
	DOS	clfl
	xor	al,al
errwr:	ret
;----------------------------
;Read from file to buffer
rdfil:	mov	bx,word ptr [hand]
	mov	cx,512
	lea	dx,mbuf
	DOS	rdfl		;=3Fh
	jc	errrd
	DOS	clfl
	xor	al,al
errrd:	ret
;-----------------------------
; Display buffer contents
dsbuf:	pushf
	lea	si,mbuf
	mov	ch,20h
dsbf0:	call	crlf
	mov	ax,si
	sub	ax,offset mbuf
	call	dsax
	call	dssp
	mov	cl,8
;00-07
	call	ds8cl
	mov	dl,"-"
	DOS	wrch
	call	dssp
	mov	cl,8
;08-15
	call	ds8cl
	call	dssp
	call	dssp
;char
	push	cx
	push	dx
	push	si
	sub	si,10h
	mov	cl,10h
	call	dshch
	pop	si
	pop	dx
	pop	cx
;
	dec	ch
	jz	dsbfe
	mov	al,ch
	and	al,0fh
	jnz	dsbf1
;
	DOS	rdky		;wait a moment
	call	crlf
dsbf1:	jmp	short dsbf0
dsbfe:	popf
	ret
;display 8 columns
ds8cl:	mov	al,byte ptr [si]
	call	dshx
	call	dssp
	inc	si
	dec	cl
	jnz	ds8cl
	ret
;display 16 chars
dshch:	mov	dl,byte ptr [si]
	cmp	dl,20h
	jnc	dshc0
	mov	dl,"."
	jmp	short dshc2
dshc0:	cmp	cl,2
	jnc	dshc2
	cmp	dl,7fh
	jc	dshc2
dshc1:	mov	dl,","
dshc2:	DOS	wrch
	inc	si
	dec	cl
	jnz	dshch
	ret
;-----------------------------
;clear buf
clbuf:	mov	ax,33fah
	mov	[mbuf],ax
	mov	byte ptr [mbuf+2],0c0h
	lea	di,mbuf+100h
	mov	cx,60h
	xor	al,al
clbu0:	mov	byte ptr [di],al
	inc	di
	dec	cx
	jnz	clbu0
	ret
;-----------------------------
;display hex ah & al
dsax:	push	ax
	push	ax
	mov	al,ah
	call	dshx
	pop	ax
	call	dshx
	pop	ax
	ret
;----------------------------
;display hex on al
dshx:	push	dx
	push	ax
	push	ax
	and	al,0f0h
	shr	al,1
	shr	al,1
	shr	al,1
	shr	al,1
	add	al,'0'
	cmp	al,'9'+1
	jc	dsh1
	add	al,7
dsh1:	mov	dl,al
	DOS	wrch
	pop	ax
	and	al,0fh
	add	al,'0'
	cmp	al,'9'+1
	jc	dsh2
	add	al,7
dsh2:	mov	dl,al
	DOS	wrch
	pop	ax
	pop	dx
	ret
;----------------------------
;display space
dssp:	mov	dl,' '
	DOS	wrch
	ret
;----------------------------
;display cr & lf
crlf:	push	ax
	push	dx
	mov	dl,cr
	DOS	wrch
	mov	dl,lf
	DOS	wrch
	pop	dx
	pop	ax
	ret
crcr:	push	ax
	push	dx
	mov	dl,cr
	DOS	wrch
	pop	dx
	pop	ax
	ret
;-----------------------------
;mini manual
mimsg:	push	ds
	push	cs
	pop	ds
	lea	dx,mmsg
	DOS	wrln
	pop	ds
	ret
;
mmsg	db	cr,lf
	db	"	+++++ mini instruction +++++",cr,lf
	db	"Set	Set code to disk BOOT_SEC from mbuf",cr,lf
	db	"Get	Get code from disk BOOT_SEC to mbuf",cr,lf
	db	"Rnw	Renew mbuf with saved file_data in 'sectdata.bin'",cr,lf
	db	"Pst	Paste additional code (for TFTize) on mbuf",cr,lf
	db	"Clr	Clear additional code on mbuf",cr,lf
	db	"Dis	Display contents on mbuf",cr,lf
	db	"0,1,2,3	set Drive No.(0/1=FDD A:/ B:, 2/3=HDD C:/ D:(/E:)",cr,lf
	db	"Qut,Esk	End of this program",cr,lf
	db	"Attention : Display are shown 512 bytes by two steps !",cr,lf
	db	"$"

;-----------------------------
	end	start
