;
;	This program is "ct65535d.exe" at stay-resident type
;	for setting registers on Chips 65535 of PC110
;
;	2018.10.01	start programing
;	2018.10.21	/t=TFT /c=CRT (=> /l /c)
;	2018.10.25	XR30,31,32,XR33
;	2018.11.06	XR54 c8->c0
;
;	2019.07.05	start New Version !
;	2019.07.09	re-arranged routines
;			"ct65535d /s" for stay and LCD-TFT
;			"ct65535d /r" for leaving
;			"ct65535d /l" for set to LCD
;			"ct65535d /c" for set to CRT
;	2019.07.12	denay call method
;	2019.07.13	use int 55h as proxy of int 16h
;	2019.07.14	use Alt+F7 instead of Fn+F7 key
;	2019.07.15	fix to c=CRT, l=LCD, r=Release
;	2019.07.16	Alt+F7 are usefull for PC/MS-DOS
;	2020.05.01	debug for Xreg rewrite miss
;	2020.06.16	Ctrl+F7 can switch the screen
;	2020.07.06	Right shift screen with XR56, XR2C
;	2020.09.27	decreasing the value of XR register
;	2020.09.28	XR56>=02 OK
;	2020.10.01	XR register adjust
;	2020.10.18	XR1C adjusted to 70h
;	2021.01.12	XR6C=1ch forced
;
;++++++++++++++++++++++++++++++++++++++++++++++
;
keyint	equ	16h	;Keyboard interrupt
v_lim	equ	0B000h	; < CA4B of 16h vector
p_int	equ	55h	;proxy of keyint
;ASCII
bs	equ	08h
cr	equ	0dh
lf	equ	0ah
esk	equ	1bh
;DOS int
rdky	equ	01h		;al with echo
wrch	equ	02h		;dl
rdch	equ	08h		;al without echo
wrln	equ	09h		;ds:dx
rdln	equ	0ah		;ds:dx | bufferd input, Enter for end
drtn	equ	4ch
;Index register & Value of register
ireg	equ	3d6h
vreg	equ	3d7h
;
DOS	macro	cmd
	mov	ah,cmd
	int	21h
endm
;
pushreg	macro	r
	irp	reg,<r>
	push	reg
	endm
endm
;
popreg	macro	r
	irp	reg,<r>
	pop	reg
	endm
endm
;
;++++++++++++++++++++++++++++++++++++++++++++
code	segment	public
	assume	cs:code

start	proc
;program start point
init:	mov	ax,cs
;	mov	ds,ax		;ds is -10 segs than cs
	mov	es,ax
	mov	ss,ax
	mov	si,offset 80h
rdcml:	mov	al,byte ptr ds:[si]
	and	al,al
	jnz	rdcm0
	jmp	stman
rdcm0:	inc	si
	mov	al,byte ptr ds:[si]
	cmp	al,0dh
	jne	rdcm1
	jmp	stman
rdcm1:	cmp	al,2fh		;=/
	jne	rdcm0
	mov	al,byte ptr ds:[si+1]
	and	al,0dfh		;upper to lower
	cmp	al,'S'		;Stay and set to LCD
	jne	rdcm2
	jmp	pstay
rdcm2:	cmp	al,'L'		;LCD ?
	jne	rdcm3
;TFT
cgtft:	push	cs
	pop	ds
	call	streg
	xor	al,al
	DOS	drtn

rdcm3:	cmp	al,'C'		;CRT ?
	jne	ckotk
;CRT
cgcrt:	push	cs
	pop	ds
	call	screg
	xor	al,al
	DOS	drtn
;
ckotk:	cmp	al,'M'		;move/shift screen
	jne	relas
;	call	stsiz
	jmp	pstay
;release form stay
relas:	cmp	al,'R'		;Relese ?
	jne	rdcm0
	push	cs
	pop	ds
	mov	ax,3500h+keyint
	int	21h
	push	bx
	pop	bp
	mov	ax,es
	cmp	ax,v_lim	;< B000
	jc	rela1
	lea	dx,nmmsg
	jmp	relae
rela1:	mov	ax,3500h+p_int
	int	21h
	push	bx
	pop	dx
	push	es
	pop	ds
	mov	ax,2500h+keyint
	int	21h
	lea	dx,rlmsg
relae:	push	cs
	pop	ds
	DOS	wrln
	mov	ax,4c00h
	int	21h
start	endp
;
;interrupt entry
int_ent	proc	far
	jmp	inten0
status	db	?
shift	db	?
v_peg	db	0
toggle	db	0
v_ofs	dw	0
v_seg	dw	0
axsave	dw	?
spsave	dw	?
sssave	dw	?
	even
	dw	128 dup(?)
l_stack	label	word
;
inten0:	cmp	status,0	;reject multi entering
	je	inten2
inten1:	jmp	intrtn

inten2:	mov	status,1	;now stayed
	mov	axsave,ax
	mov	sssave,ss
	mov	spsave,sp
	mov	ax,cs
	mov	ss,ax
	mov	sp,offset l_stack
	sti
	pushreg	<ds,es,bx,cx,dx,si,di,bp>
	assume	ds:code, es:code, ss:code
	mov	ds,ax
	mov	es,ax
;check key-in with one shot
	mov	ah,01h
;call original proccess int_16h => copy to int_55h
	int	p_int
	jnc	rtnpe
	cmp	ax,6e00h	;Alt+F7 key ?
	jne	rtnp0
	mov	ah,01h
	int	p_int
	cmp	ax,6e00h	;Alt+F7 key ?
	je	rtnp1
rtnp0:	cmp	ax,6400h	;Ctrl+F7 ?
	jne	rtnpe
	mov	ah,01h
	int	p_int
	cmp	ax,6400h	;Ctrl+F7 ?
	jne	rtnpe
rtnp1:	cmp	toggle,0	;outer or inner ?
	jne	pwtrg		;switch to another display mode
	call	vscrg		;CRT display
	mov	toggle,1
	jmp	short rtnpe
pwtrg:	call	vslrg		;LCD TFT display
	mov	toggle,0
	assume	nothing
	assume	cs:code
rtnpe:	popreg	<bp,di,si,dx,cx,bx,es,ds>
	cli
	mov	sp,spsave
	mov	ss,sssave
	mov	ax,axsave
	mov	status,0
	stc
intrtn:	jmp	dword ptr [v_ofs]	;v_save
int_ent	endp
;
;+++++++++++++++++++++++++++++++++
;write CRT table value to registers
;	with code display
wsreg	proc	near
	lea	dx,smsg
	DOS	wrln
screg:	lea	si,crtbl
wsrgr:	jmp	wtrgr
;---------------------------------
;write TFT value to registers
;	with code display
wtreg:	lea	dx,tmsg
	DOS	wrln
streg:	lea	si,trtbl
wtrgr:	mov	al,byte ptr [si]
	cmp	al,0ffh
	jne	wtrg1
	call	crlf
	ret
wtrg1:	call	dshx
	mov	dx,3d6h
	out	dx,al
	mov	al,byte ptr [si+1]
	mov	dx,3d7h
	out	dx,al
	call	dshx
	call	dssp
	add	si,2
	jmp	wtrgr
wsreg	endp
;
;------------------------------------
;write registers with no display
vscrg	proc	near
	lea	si,crtbl
	jmp	vsbrr
;
vslrg:	lea	si,trtbl
vsbrr:	mov	al,byte ptr [si]
	cmp	al,0ffh
	jne	vsbr0
	ret
vsbr0:	mov	dx,3d6h
	out	dx,al
	mov	al,byte ptr [si+1]
	mov	dx,3d7h
	out	dx,al
	add	si,2
	jmp	vsbrr
vscrg	endp
;
;------------------------------------
; 1 asc to bin convert
abcnv	proc	near
	cmp	al,'@'
	jc	abcn1
	and	al,4fh
abcn1:	sub	al,'0'
	jnc	abcn2
	ret
abcn2:	cmp	al,11
	jc	abcn3
	sub	al,7
	cmp	al,16
abcn3:	cmc
	ret
abcnv	endp
;---------------------------------
;display hex on al
dshx	proc	near
	push	dx
	push	ax
	push	ax
	and	al,0f0h
	shr	al,1
	shr	al,1
	shr	al,1
	shr	al,1
	add	al,'0'
	cmp	al,'9'+1
	jc	dsh1
	add	al,7
dsh1:	mov	dl,al
	DOS	wrch
	pop	ax
	and	al,0fh
	add	al,'0'
	cmp	al,'9'+1
	jc	dsh2
	add	al,7
dsh2:	mov	dl,al
	DOS	wrch
	pop	ax
	pop	dx
	ret
dshx	endp
;
dssp	proc	near
	push	dx
	mov	dl,' '
	DOS	wrch
	pop	dx
	ret
dssp	endp
;---------------------------------
;show display ah & al
dsax	proc	near
	push	ax
	push	ax
	mov	al,ah
	call	dshx
	pop	ax
	call	dshx
	pop	ax
	ret
dsax	endp
;----------------------------------
crlf	proc	near
	push	ax
	push	dx
	mov	dl,cr
	DOS	wrch
	mov	dl,lf
	DOS	wrch
	pop	dx
	pop	ax
	ret
crcr:	push	ax
	push	dx
	mov	dl,cr
	DOS	wrch
	pop	dx
	pop	ax
	ret
crlf	endp
;
res_top	label	word		;check point only
;
;set horizontal shift size
stsiz	proc	near
	push	ax
	push	di
	push	es
	push	cs
	pop	es
	mov	al,byte ptr ds:[si+2]
	cmp	al,3fh
	jc	stsi0
	and	al,0dfh		;upper to lower
stsi0:	call	abcnv
	jc	stsie
	lea	di,trtbl
stsi1:	mov	ah,byte ptr es:[di]
	inc	di
	inc	di
	cmp	ah,0ffh
	je	stsie
	cmp	ah,56h		;=XR56
	jne	stsi1
	cmp	al,02h
	jnc	stsi2
	mov	al,02h
stsi2:	mov	byte ptr es:[di-1],al
stsie:	pop	es
	pop	di
	pop	ax
	ret
stsiz	endp
;+++++++++++++++++++++++++++++++++++++++++++++++
;parameter table
trtbl	db	06h,0c0h	;No color reduction
;	db	19h,00h		;Alt Hsync Start(CR04)
;	db	1ah,7fh		;Alt Hsync End(CR05)
;	db	1bh,0a0h	;Alt H Total(CR00)
	db	1ch,4fh		;Panel Width
	db	1dh,00h
	db	4fh,0c6h	;LP/M change to DE
	db	50h,00h		;Clock divide, Dither, FRC
	db	51h,0c4h	;change to LCD on 4h !!!
;	db	52h,42h		;for 'Panel On'
	db	53h,00h		;for FRC
	db	54h,0c8h	;Negative Polarity
;	db	55h,0e5h	;H Auto Doubling
;	db	56h,00h		;H Centering
;	db	57h,00h		;V Stretch Mode
;	db	59h,00h		;V H/W Line Replication
;	db	5ah,04h		;V Line Repl Height
;	db	64h,0e0h	;FP Alternate V Total
;	db	65h,27h		;Alt V Total(CR06)
;	db	66h,02h		;FP Alt Vsync Start
;	db	67h,0ch		;Alt Vsync End(CR11)
;	db	68h,0dfh	;Panel Height / low
	db	6ch,1ch
	db	0ffh,0ffh
;table end
;register table of the original data
crtbl	db	06h,0c0h
;	db	19h,01h
;	db	1ah,19h
;	db	1bh,59h
	db	1ch,4fh
	db	1dh,7fh
	db	4fh,04h
	db	50h,15h
	db	51h,0c0h	;63h?	;Change to CRT !!!
;	db	52h,42h
	db	53h,00h
	db	54h,3ah
;	db	55h,0e5h
;	db	56h,00h
;	db	57h,03h
;	db	59h,04h
;	db	5ah,04h
;	db	64h,0e0h
;	db	65h,07h
;	db	66h,00h
;	db	67h,01h
;	db	68h,0dfh
	db	6ch,1ch
	db	0ffh,0ffh
;old parameter table
ottbl	db	06h,0c0h
	db	19h,00h
	db	1ah,7fh
	db	1bh,0a0h
	db	1ch,7fh
	db	1dh,00h
	db	2ch,00h
	db	2dh,9fh
	db	2eh,9fh
	db	2fh,0fh		;LP width
	db	4fh,04h
	db	50h,0ah
	db	51h,0c4h
	db	52h,42h
	db	53h,00h
	db	54h,0c0h
	db	55h,0e5h
	db	56h,02h
	db	57h,00h
	db	58h,00h
	db	59h,00h
	db	5ah,04h
	db	64h,0e0h
	db	65h,27h
	db	67h,0ch
	db	68h,0dfh
	db	6ch,1ch
	db	0ffh,0ffh
;table end
;head message
hmsg	db	cr,lf,'+++ CT65535 Registers Setter for TFT/CRT 2020.7.7 +++',cr,lf,'$'
stymsg	db	cr,lf,'stay resident !',cr,lf,'$'
nstmsg	db	cr,lf,'already stay !',cr,lf,'$'
rlmsg	db	cr,lf,'release stay !',cr,lf,'$'
nmmsg	db	cr,lf,'not stay !',cr,lf,'$'
;
;------------------------------------------------
; Manual read / write
	assume	ds:code
stman	proc	near
	mov	ax,cs
	mov	ds,ax
	lea 	dx,hmsg
	DOS	wrln
	call	dcreg		;disp current reg
ini0:	call	crlf
	mov	dl,'-'
	DOS	wrch
	DOS	rdky		;waite keycode
	cmp	al,'q'
	jne	ini1
	xor	al,al
	DOS	drtn
ini1:	call	crcr
	cmp	al,'l'		;LCD ?
	jne	ini2
	call	wtreg
	jmp	ini0
ini2:	cmp	al,'c'		;CRT ?
	jne	ini3
	call	wsreg
	jmp	ini0
ini3:	cmp	al,'C'		;Capital letter for CRREG
	jne	ini4
	call	CRREG
	jmp	ini0
ini4:	cmp	al,'S'		;for SRREG
	jne	ini5
	call	SRREG
	jmp	ini0
ini5:	cmp	al,'G'
	jne	ini6
	call	GRREG
	jmp	ini0
ini6:	cmp	al,'A'
	jne	ini7
;	call	ARREG		;effect to Color palette
	jmp	ini0
;
ini7:	cmp	al,'x'
	jne	ini8
	call	XRREG
	jmp	ini0
;
ini8:	cmp	al,'?'
	jne	ini9
	lea	dx,qqmsg
	DOS	wrln
	jmp	ini0
ini9:	cmp	al,esk
	jne	ini0
	xor	al,al
	DOS	drtn
qqmsg	db	cr,lf,'Command : q(uit),l(CD),c(RT),x(Rreg),C(Rreg),S(Rreg),G(Rreg),A(Rreg ?)',cr,lf,'$'
stman	endp
;
; +++ read / write XRREG, CRREG, SRREG, GRREG, ARREG +++
;
;read and write XR registers
XRREG	proc	near
	lea	dx,XRmsg
	DOS	wrln
	mov	dx,3d6h		;for XR registers
	call	rwreg
	ret
XRREG	endp
;
;CRT Registers
;max index CR24
CRREG	proc	near
	lea	dx,CRmsg
	DOS	wrln
	mov	dx,3d4h
	call	rwreg
	ret
CRREG	endp
;
;Sequencer Registers
;max index SR07=07h
SRREG	proc	near
	lea	dx,SRmsg
	DOS	wrln
	mov	dx,3c4h
	call	rwreg
	ret
SRREG	endp
;
;Graphics Controller Registers
;max index GR08=08h
GRREG	proc	near
	lea	dx,GRmsg
	DOS	wrln
	mov	dx,3ceh
	call	rwreg
	ret
GRREG	endp
;
;Attribute controller and VGA Color Palette registers
;max index AR=14h	enable bit(20h) + index?
ARREG	proc	near
	lea	dx,ARmsg
	DOS	wrln
	mov	dx,3c0h
	call	rwreg
	ret
ARREG	endp
;
XRmsg	db	cr,lf,'Read/Write XR Registers',cr,lf,'$'
CRmsg	db	cr,lf,'Read/Write CR Registers',cr,lf,'$'
SRmsg	db	cr,lf,'Read/Write SR Registers',cr,lf,'$'
GRmsg	db	cr,lf,'Read/Write GR Registers',cr,lf,'$'
ARmsg	db	cr,lf,'Read/Write AR Registers',cr,lf,'$'
smsg	db	'CRT XRegister Values (q=quit, l=Lcd TFT, c=Crt, x=show & rewrite XReg)',cr,lf,'$'
tmsg	db	'TFT XRegister Values (q=quit, l=Lcd TFT, c=Crt, x=show & rewrite XReg)',cr,lf,'$'
jmsg	db	'Current XReg Value   (q=quit, l=Lcd TFT, c=Crt, x=show & rewrite XReg)',cr,lf,'$'

;Read and write multi registers
adrsv	dw	0000h
idxsv	db	00h
;
rwreg	proc	near
	mov	word ptr [adrsv],dx
rwrgi:	mov	dx,word ptr [adrsv]
	call	gtidx		;get idx no. on AL
	jc	rwrge
	mov	byte ptr [idxsv],al
	call	dssp
	mov	dx,word ptr [adrsv]
	mov	al,byte ptr [idxsv]
	out	dx,al		;set index !
	inc	dx
;Read a data from the register
	in	al,dx
	call	dshx
	call	dssp
;Get a data from keys
	call	rdtwk		;get two chrs
	jc	rwrgr
	push	ax		;push data
	mov	dx,word ptr [adrsv]
	mov	al,byte ptr [idxsv]
;Write a data to the register
	out	dx,al
	inc	dx
	pop	ax
	out	dx,al
rwrgr:	call	crlf
	jmp	rwrgi
rwrge:	ret
rwreg	endp
;-----------------------------
;get register number and display content
gtidx	proc	near
	DOS	rdky
	call	abcnv
	jc	gtide
	shl	al,1
	shl	al,1
	shl	al,1
	shl	al,1
	mov	cl,al
	DOS	rdky
	call	abcnv
	jc	gtide
	add	al,cl
	clc
gtide:	ret
gtidx	endp
;
;-----------------------------------------------
;Display Current register value
dcreg	proc	near
	lea	dx,jmsg
	DOS	wrln
	lea	si,trtbl
;	lea	si,ottbl
dcrg0:	mov	al,byte ptr[si]
	cmp	al,0ffh
	jne	dcrg1
	call	crlf
	ret
dcrg1:	mov	dx,3d6h		;XR index
	out	dx,al
	call	dshx
	mov	dx,3d7h		;XR register
	in	al,dx
	call	dshx
	call	dssp
	add	si,2
	jmp	dcrg0
dcreg	endp
;---------------------------------------
;read 2 keys to AL
rdtwk	proc	near
	push	bx
	DOS	rdky
	call	abcnv
	jc	rdtwe
	and	al,0fh
	shl	al,1
	shl	al,1
	shl	al,1
	shl	al,1
	mov	bh,al
	DOS	rdky
	call	abcnv
	jc	rdtwe
	and	al,0fh
	or	al,bh
	clc
rdtwe:	pop	bx
	ret
rdtwk	endp
;
prg_top label	word
;---------------------------------
;preparation for stay
pstay	proc	near
	cmp	v_peg,1
	je	nwext
	assume	cs:code, ds:code, es:code, ss:code
	mov	ax,cs
	mov	ds,ax
	call	vslrg			;set LCD-TFT
	mov	ax,3500h+keyint
	int	21h
	mov	di,bx
	mov	si,offset start
	mov	cx,res_top - start
	cld
	repz	cmpsb			;size check
	jnz	nw_res
nwext:	mov	dx,offset nstmsg	;already exist !
	DOS	wrln
	mov	v_peg,1
	xor	al,al
	DOS	drtn
;
nw_res:	mov	v_peg,1
	mov	ax,es
	cmp	ax,v_lim
	jc	nwext
	mov	v_ofs,bx
	mov	v_seg,es
;proxy int p_int
	push	bx
	pop	dx
	push	es
	pop	ds
	mov	ax,2500h+p_int
	int	21h
;
	mov	dx,offset int_ent
	mov	ax,cs
	mov	ds,ax
	mov	ax,2500h+keyint
	int	21h
	mov	dx,offset stymsg
	DOS	wrln
	mov	dx,offset prg_top
	mov	cl,4
	shr	dx,cl
	mov	ax,3100h		;stay resident !
	int	21h
pstay	endp
;
code	ends
	end	start
;-----------------------------------