//Copyright 2014,2015 MCbx, All rights reserved.
//http://mcbx.netne.net/ictester
//This file is part of ICTester.
//ICTester is free software; you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation; either version 2 of the License, or
//(at your option) any later version.
//ICTester is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//You should have received a copy of the GNU General Public License
//along with ICTester; if not, write to the Free Software Foundation,
//Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "r2716.h"
#include <QByteArray>
#include "../devicedriver.h"
#include <QDebug>
#include <QString>
#include <qglobal.h>
#include "toolkit.h"


//Hello, these comments will guide you to write your own routine :)
//Naming convention is usually powerICTYPE and readICTYPE.
//It is not forced, but simplifies things a lot.

//Here you display power requirements. Nothing special, this one just types text and waits for key.
void power2732()
{
    QTextStream cin(stdin);
    qDebug()<<"Please connect ground to pin 12 (switch 4 on)\n and Vcc to pin 24.";
    qDebug()<<"Press Return to start, Ctrl-C aborts";
    cin.readLine();
}


//reading algorithm. We are using "words" not "bytes" because some circuits have
//4-bit word, and it is casted to full byte later.
QByteArray read2732(DeviceDriver * tester, int debug)
{
    QByteArray rom;
    char readWord;

    //Here you initialize input/output of tester.
    //0 is input data TO chip 1 - FROM chip or power/NC pin.
    tester->setIO("000000001111111110000001"); //initialize IO
    tester->powerON();

    //Here you should keep convention: Reading X words from [TYPE] chip
    //It may be used by GUI to display progress bar.
    qDebug()<<"Reading 4096 words from 2732 chip...";

    for (int i=0;i<4096;i++) //word count...
    {
        //fill number of address lines here--------------V
        QString addr=QString::number(i,2).rightJustified(12,'0'); //generate binary address
        addr=rev(addr);

        //Generate binary addreses as you see in datasheet.
        QString state=addr.mid(7,1)+addr.mid(6,1)+addr.mid(5,1)+addr.mid(4,1)+addr.mid(3,1)+addr.mid(2,1)+addr.mid(1,1)+addr.mid(0,1)+"0000"
                     +"00000"+"0"+addr.mid(10,1)+"1"+addr.mid(11,1)+addr.mid(9,1)+addr.mid(8,1)+"1";

        tester->setData(state); //address and CS high goes in
        qSleep(2);

        state=addr.mid(7,1)+addr.mid(6,1)+addr.mid(5,1)+addr.mid(4,1)+addr.mid(3,1)+addr.mid(2,1)+addr.mid(1,1)+addr.mid(0,1)+"0000"
                             +"00000"+"0"+addr.mid(10,1)+"0"+addr.mid(11,1)+addr.mid(9,1)+addr.mid(8,1)+"1";

        tester->setData(state); //address and CS low goes in
        qSleep(2);

        //read word from chip. Remember to trim it from 24 to the following convention:
        // tester->getData().mid(a,b); a is 12-(numberOfPins/2), b is numberOfPins
        QString res=tester->getData();

        //Now an important thing: Get resulting bits from readout.
        //Here you have to REVERSE bits, it means D0 in chip becomes last bit, D1 becomes last but one etc.
        res=res.mid(16,1)+res.mid(15,1)+res.mid(14,1)+res.mid(13,1)+res.mid(12,1)+res.mid(10,1)+res.mid(9,1)+res.mid(8,1);
        readWord=res.toInt(NULL,2);
        if ((i+1)%16==0) qDebug()<<i+1;

       if (debug)
        qDebug()<<i<<"("<<addr<<"): "<<res<<" ascii: "<<readWord<<" to "<<QString::number(readWord,2).right(8).rightJustified(8,'0')<<":"<<state;
        rom.append(readWord);

    }
    tester->reset();
    return rom;
}

