        page 250,150
;Begin--------------------------------------------------------------------
;
; MkFs
; by: P.R. Faasse
;     Hakfort 337
;     1102LA Amsterdam
;
; Program to make a file-system on an PoFoIDE disk
; This file-system should completely satisfy all the DOS
; requirements of a file-system.
;
; update history:
; ---------------
;
;
;End----------------------------------------------------------------------

; ------------------------------------------------------------------------
; standard beginning of a .COM file. Seems to satisfy MASM...
; ------------------------------------------------------------------------

code    segment para 'code'     ; define the  code segment
        org   0100h             ; begin at offset 0100H

        assume cs:code, ds:code, es:code, ss:code
                                ; all segment registers
                                ; point to the code segment

Start:  jmp     Main            ; goto the main processing loop

;Pars---------------------------------------------------------------------
; The parameters of the file-system to be made.
;-------------------------------------------------------------------------
;
; the parameters of the file-system, I support 12-bits FATs for
; the moment
;
rootdir equ     128             ; # entries in the root directory
fats    equ     1               ; # fat's
cluster equ     16              ; sectors/cluster
dtype   equ     0F8H            ; media type byte (F8H = harddisk)
dsize   equ     65280           ; number of sectors in the disk
;
; the fixed parameters of the DOS file-system
;
secsize equ     0200H           ; always 512 bytes/sector
dirsize equ     020H            ; bytes per directory entry
dskresv equ     1               ; always one reserved sector (why?)
;
; one of the pars I compute from the others
;
;fatsize equ     ((3 * dsize)+1)/(2 * secsize * cluster) ; sectors/fat
fatsize equ     12              ; MASM is no good calculator
ZerBlocks       equ ((rootdir*dirsize)/secsize)+(fatsize*fats)+1
;
;End----------------------------------------------------------------------

;Pars---------------------------------------------------------------------
; The general parameters
;-------------------------------------------------------------------------
;
cr      equ     0DH     ; <CR>
lf      equ     0AH     ; <LF>
eos     equ     '$'     ; DOS end-of-string
eom     equ     0       ; my end-of-message
;
;End----------------------------------------------------------------------

;Data---------------------------------------------------------------------
;
; The boot record data. This data will be copied into the IoBuf
; and then written into the sector 0 of the partition.
;
;-------------------------------------------------------------------------

BootRec:jmp     short   noboot  ; go print boot message
        db      0          ;  2 ; filler byte
        db      "PoFoIDE " ;  3 ; some name, 8 chars
        dw      secsize    ;  B ; sector size (fixed)
        db      cluster    ;  D ; cluster size
        dw      dskresv    ;  E ; reserved sectors
        db      fats       ; 10 ; no of FAT's
        dw      rootdir    ; 11 ; root dir entries
        dw      dsize      ; 13 ; total number of sectors
        db      dtype      ; 15 ; media code F8 = hard-disk
        dw      fatsize    ; 16 ; sectors per FAT (is fixed...)
        dw      8          ; 18 ; sectors per track (nonsense
        dw      2          ; 1A ; number of heads     really)
        dd      0          ; 1C ; hidden sectors

        ; some reserved space, 11 bytes in all. This should
        ; satisfy even DOS4.0 and on
        db      0,0,0,0,0       ; reserved
        db      0,0,0,0,0,0     ; reserved too

;-------------------------------------------------------------------------
; Some code that will end up in the boot record. This code should
; print the message that the disk is not bootable. I do not know
; how to make DOS continue after that. I do a dynamic halt
; because I do not know better....
;-------------------------------------------------------------------------

        ; code to print "This is not a bootable disk"
NoBoot: mov     ax,cs           ; make segments ok
        cli                     ; NEVER handle stack segments
        mov     ss,ax           ; etc. with interrupts enabled...
        mov     sp,07C00H       ;
        sti                     ;
        mov     ds,ax           ;
        mov     si,07C00H+msg   ;
nbloop: lodsb                   ; get string byte
        cmp     al,0            ;
        jz      nbhalt          ;
        mov     ah,0EH          ;
        mov     bx,7            ;
        int     10h             ; print via BIOS
        jmp     short nbloop    ;

        ; dynamic halt
nbhalt: jmp     short nbhalt    ;

        ; the text message itself
msg     equ     $ - (offset BootRec)    ;
        db      "This disk is not bootable",10,13,0

        ; data for making the program put this in the IoBuf
BootRecEnd      equ this byte
NoBootSize      equ     (offset BootRecEnd - offset NoBoot)
BootRecSize     equ     (offset BootRecEnd - offset BootRec)

;-------------------------------------------------------------------------
;
; End of the data that will be put in the boot record. Only the
; AA55 as shown below will be put in the boot record tail.
;
;-------------------------------------------------------------------------

        ; end signal of a boot record
EndSig  equ     0AA55H          ; end signal boot record

;-------------------------------------------------------------------------
; the local parameters for the program, text strings too
;-------------------------------------------------------------------------

DriveNo db      0       ; drive number

; text strings
NoPars          db      "usage: mkfs <drive>",lf,cr,eos
NoDriver        db      "PoFoIDE driver not found",lf,cr,eos
NoWrite         db      "Write error to disk",lf,cr,eos
DoWrite         db      "Making file-system....",eos
OkWrite         db      "done"
NlStr           db      lf,cr,eos

;End----------------------------------------------------------------------

;Prog---------------------------------------------------------------------
;
; The main program itself. It will parse the runstring for a drive letter.
; Then it will first look for a PoFoIDE driver. If it finds one it will
; blindly pump a file-system on the drive.
;
Main:
        ; Parse parameters
        mov     si,081H                 ; si -> begin of parameters
        cld                             ;

ParLp:  lodsb                           ;
        cmp     al,CR                   ;
        jz      ParErr                  ;
        cmp     al,' '                  ;
        jz      ParLp                   ;

        ; convert to upper
        and     al,0DFH                 ; -> upper

        ; test if valid drive letter
        cmp     al,'D'                  ; test A .. Z
        jc      parerr                  ;
        cmp     al,'Z'+1                ;
        jnc     parerr                  ;
        sub     al,'A' - 1              ; A -> 1; D -> 4
        mov     driveno,al              ;

        jmp     TstIdeDrv               ;

        ; wrong parameters given
ParErr: mov     dx,offset NoPars        ; give message
        jmp     MesEx                   ; exit

        ; test if an IDE driver there for that drive
TstIdeDrv:
        mov     bl,driveno              ; save drive number
        mov     ax,04404H               ; IoCtlRead
        mov     cx,0258H                ; # bytes
        mov     dx,offset IoBuf         ;
        int     21H                     ;
        jc      NoIdeDrv                ;

        ; test if driver there
        cmp     word ptr IoBuf,'KP'     ; test if signal there
        jz      GoWrite                 ;

NoIdeDrv:

        mov     dx,offset NoDriver      ; error message
mesex:  mov     ah,9                    ;
        int     21H                     ;

        mov     ax,04C01H               ; exit
        int     21H                     ;

        ; driver found
GoWrite:nop                             ;

        ; give message
        mov     ah,9                    ;
        mov     dx,offset DoWrite       ;
        int     21h                     ;

        ; get the boot record's header, BPB and thingies
        ; from the driver.
        mov     ax,word ptr IoBuf+7     ; driver's code segment
        mov     si,word ptr IoBuf+9     ; driver's BootRec
        mov     ds,ax                   ; ds:si -> driver
        mov     di,offset IoBuf         ; es:di -> IoBuf
        cld                             ;
        ; get just the beginning of the boot record
        mov     cx,(offset NoBoot - offset BootRec)
        rep     movsb                   ;

        ; the rest comes from our local segment
        mov     ax,cs                   ;
        mov     ds,ax                   ;

        ; prepare rest of the boot sector
        cld                             ; prepare the rest of
        mov     cx,NoBootSize           ; the boot sector data
        rep     movsb                   ;

        ; fill in the tail with 00 bytes
        mov     cx,(512-BootRecSize)    ; fill the rest with 00
        mov     al,0                    ;
        rep     stosb                   ;

        ; put an end signal in place
        mov     word ptr IoBuf + 510,EndSig     ; put end signal
        mov     byte ptr IoBuf + 512,0          ; partition is irrelevant
        mov     word ptr IoBuf + 513,0          ; sector 0

        ; write to the disk
        mov     ax,04405H               ; IoCtlWrite
        mov     bl,DriveNo              ;
        mov     cx,1                    ; one sector
        mov     dx,offset IoBuf         ;
        int     21H                     ;
        jc      WriteErr                ;

        ; prepare buffer with 0000
        cld                             ;
        mov     cx,256                  ;
        mov     ax,0000H                ;
        mov     di,offset IoBuf         ;
        rep     stosw                   ;

        ; write FAT and root dir with 0
        mov     cx,ZerBlocks-1          ; FAT sectors + Rootdir
FatRLp: push    cx                      ; save cx
        mov     ax,word ptr IoBuf + 513 ; increment sector number
        xchg    ah,al                   ;
        inc     ax                      ;
        xchg    ah,al                   ;
        mov     word ptr IoBuf + 513,ax ;
        mov     ax,04405H               ; IoCtlWrite
        mov     bl,DriveNo              ;
        mov     cx,1                    ;
        mov     dx,offset IoBuf         ;
        int     21H                     ;
        jc      WriteErr1               ;
        pop     cx                      ;
        loop    FatRLp                  ;

        ; give message
        mov     ah,9                    ;
        mov     dx,offset OkWrite       ;
        int     21h                     ;

        ; exit
        mov     ax,04C00h               ;
        int     21h                     ;

WriteErr1:
        pop     cx                      ;
WriteErr:
        mov     dx,offset NoWrite       ;
        jmp     MesEx                   ;

;End----------------------------------------------------------------------

;Buffer-------------------------------------------------------------------
;
; The I/O buffer. This buffer is used to write sector data to the
; disk. I do not store the buffer data on the disk image of the
; program because I will always put something in the buffer
; before writing it to disk.
;
IoBuf           equ     this byte       ; the I/O buffer
IoBufSize       equ     secsize         ;
;
;End----------------------------------------------------------------------

;Tail---------------------------------------------------------------------
;
; Note that I do not do any stack inits at all. The stackpointer
; is just left at the end of the allocated memory segment. It
; should do no harm there.
;
code    ends
        end     Start           ; end of the program
;
;End----------------------------------------------------------------------
