// test.c  I/O Magic Tempo Diagnostic Tests

#include <stdio.h> 
#include <conio.h> 
#include <memory.h> 
#include <string.h> 
#include <ctype.h> 
#include <stdlib.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#include <malloc.h>
#include <signal.h>
#include <dos.h>
#define _DEFINE
#include "test.h" 
#include "cs.h"
#include "midpak.h" 
#include "doscalls.h"
#include "loader.h"

// Uncomment the following line to test MMA FIFO
// This currently doesn't work!

//#define TEST_MMA_FIFO
 
            
    BOOL bCtrlBreak = FALSE;


typedef enum tagTEST_RESULT
    {
    TEST_MIXREG_LINEOUT_L,
    TEST_MIXREG_LINEOUT_R,
    TEST_MIXREG_MODE,
    TEST_MIXREG_FM_L,
    TEST_MIXREG_FM_R,
    TEST_MIXREG_MMA_L,
    TEST_MIXREG_MMA_R,
    TEST_MIXREG_MIC_L,
    TEST_MIXREG_MIC_R,
    TEST_MIXREG_SELECT, 
    TEST_MMAREG_SELT_1,
    TEST_MMAREG_PCM_DATA_1,
    TEST_MMAREG_PCM_DATA_2,
    TEST_FIFO_ADDR,
    TEST_FIFO_MEM,
    TEST_SYNTH_PLAY,
    TEST_MMA_PLAY_8K,
    TEST_MMA_PLAY_11K,
    TEST_MMA_PLAY_22K,
    TEST_AT_LINEOUT_L,
    TEST_AT_LINEOUT_R,
    TEST_AT_FM_L,
    TEST_AT_FM_R,
    TEST_AT_MMA_L,
    TEST_AT_MMA_R,
    TEST_AT_LINEIN_L,
    TEST_AT_LINEIN_R,
    TEST_REC_LINEIN,
    TEST_REC_MIC    
    } TEST_RESULT;

#define NUM_TESTS 29   


    char *TestDesc[NUM_TESTS] = 
        {
        "Mixer LineOut Left Register", 
        "Mixer LineOut Right Register",
        "Mixer Mode Register",
        "Mixer FM Left Register",
        "Mixer FM Right Register",
        "Mixer MMA Left Register",
        "Mixer MMA Right Register",
        "Mixer Mic Left Register",
        "Mixer Mic Right Register",
        "Mixer Select Register",
        "MMA SELT Register",
        "MMA PCM Data Register, Channel 1",
        "MMA PCM Data Register, Channel 2",
        "FIFO Addressing",
        "FIFO Memory",     
        "FM Synth Play",
        "MMA Play 8kHz Mono 8bit",
        "MMA Play 11kHz Mono 8bit",
        "MMA Play 22kHz Mono 8bit",
        "Mixer Attenuator LineOut L",
        "Mixer Attenuator LineOut R",
        "Mixer Attenuator FM L",
        "Mixer Attenuator FM R",
        "Mixer Attenuator MMA L",
        "Mixer Attenuator MMA R",
        "Mixer Attenuator LineIn L",
        "Mixer Attenuator LineIn R",
        "MMA LineIn Record", 
        "MMA Mic Record"
        };    

#define NOT_RUN  -1
#define PASS     0
#define FAIL     1
       
    int TestResult[NUM_TESTS];     
    
            
    BOOL    bReportToDisk = FALSE; 
    
    char    szSerialNumber[81];     // Dumb - should have input buffer
    char    szReportFile[81];        

#define DOSALLOC 0
// Redirect memory allocation to either DOS memory allocate functions located
// in DOSCALLS or to C library far memory allocation functions.
unsigned char far * far memalloc(long int siz)
{
    unsigned char far *mem;

    #if DOSALLOC
        mem = fmalloc(siz);  // DOS far memory allocation functions
    #else
        mem = (unsigned char far *)_fmalloc(siz); // C's far memory allocation functions.
    #endif
    return(mem);
}

void far memfree(char far *memory)
{
    #if DOSALLOC
        ffree(memory);
    #else
        _ffree(memory);
    #endif
}



BOOL CheckBreak(VOID)
    { 
    if (bCtrlBreak)
        {
        printf("\nTerminating at user request!\n"); 
        _outp(PicImr, (_inp(PicImr) | PicMask)); // Re-mask Irq in 8259 IMR
        if (data)
            _hfree(data);
        if (old_ISR) 
            _dos_setvect( IntVect, old_ISR );  // Restore existing Irq handler                
        DeInitMidPak();
        UnLoadMidPak();
        abort(); 
        return TRUE;        // really can't return...
        }
    else
        return FALSE;
    }

VOID SayPassOrFailAll(VOID)
    {
    int i;
    int j=1; 
    BOOL    bFailed = FALSE;
    
    for (i=0; i < NUM_TESTS; i++)
        if (TestResult[i] == FAIL)
            {
            bFailed = TRUE;
            break;
            }
            
    
    CheckBreak();
    printf("\n****** Test Report for card #%s ******\n\n", szSerialNumber);

    if (bFailed) 
        printf("FAILED one or more tests!\n\n");
    else
        printf("PASSED all tests.\n\n");

    
    for (i=0; i < NUM_TESTS; i++) 
        {
        CheckBreak();

        switch (TestResult[i])
            {
            case PASS:      
                break; 
                
            case FAIL:      
                printf("FAILED: Test # %d (%s)\n", i, TestDesc[i]);
                j++;
                break;
                
            case NOT_RUN:   
                printf("NOT RUN: Test # %d (%s)\n", i, TestDesc[i]);
                j++;              
                break; 
                
            default:        
                printf("TEST PROGRAM ERROR: Test # %d (%s)\n", i, TestDesc[i]);
                j++;  
                break;
            }
        if (!(j % 18))
            {  
            printf("Press any key to continue...");
            _getch();
            printf("\n");
            }     
        }
                                      
    }
    
    
//-----------------------------------------------------------------------
// Get Y or N from the user - return PASS for Y, FAIL for N
//-----------------------------------------------------------------------
int AskPass(char *Msg)
    {
    int KeyHit;
    
    printf(Msg); 
    CheckBreak();
    for(;;)         // Loop until we get Y or N
        {
        printf(" (Y or N):"); 
        while (!CheckBreak() && !_kbhit());     
        KeyHit = _getche(); 
        printf("\n");               // Complete line 
        if (KeyHit == 'Y' || KeyHit == 'y')
            return PASS;
        else if (KeyHit == 'N' || KeyHit == 'n')
            return FAIL; 
        }
    }    

//-----------------------------------------------------------------------
// Address test for FIFO RAM 
//
// Write unique values in each two bytes of FIFO, then reads back
// Does test twice, with byte order reversed on the second test
//-----------------------------------------------------------------------
BOOL AddressFifoTest(VOID)  
    {
    WORD    wAddr, wBit;
    BYTE    byIn1, byIn2;
    BOOL    bFailed = FALSE;

    printf("Testing FIFO addressing.\n");
    ResetFifo();
    for (wAddr=0; wAddr <= (WORD)0x3ffb; wAddr++)          // Fill FIFO with marching bits
        {
        _outp(FIFO_REG, wAddr & 0xff);
        _outp(FIFO_REG, (wAddr >> 8 ) & 0xff) ;
        } 
    CheckBreak();    

    for (wAddr=0; wAddr <= (WORD)0x3ffb; wAddr++)          // Test FIFO for marching bits
        {
        byIn1 = _inp(FIFO_REG);
        byIn2 = _inp(FIFO_REG);
        
        wBit = byIn1 + (byIn2  << 8);
        
        if (wBit != wAddr ) 
            {
            printf (" FIFO address error, addr: %04X  got: %04X\n",wAddr, wBit);
            bFailed = TRUE;
            }
        }          
    CheckBreak(); 
    
    ResetFifo();
    for (wAddr=0; wAddr <= (WORD)0x3ffb; wAddr++)          // Fill FIFO with marching bits
        {
        _outp(FIFO_REG, (wAddr >> 8 ) & 0xff) ;
        _outp(FIFO_REG, wAddr & 0xff);        
        } 
    CheckBreak();    

    for (wAddr=0; wAddr <= (WORD)0x3ffb; wAddr++)          // Test FIFO for marching bits
        {
        byIn2 = _inp(FIFO_REG);
        byIn1 = _inp(FIFO_REG);
        
        wBit = byIn1 + (byIn2  << 8);
        
        if (wBit != wAddr ) 
            {
            printf (" FIFO address error (flip), addr: %04X  got: %04X\n",wAddr, wBit);
            bFailed = TRUE;
            }
        }          
    CheckBreak();     
       
    return bFailed; 
    }  

#ifdef TEST_MMA_FIFO
//-----------------------------------------------------------------------
// Marching bits test for MMA FIFO RAM
//-----------------------------------------------------------------------
BOOL MarchingBitsMMAFifoTest   
    ( 
    BYTE wBaseReg,      // Base addr of MMA channel to test
    BYTE bySeed,        // Initial seed, 0x01, 0x02, etc.
    BOOL bOnes          // TRUE = marching ones, FALSE = marching zeros
    )
    
    {
    WORD    wAddr, wBit;
    BYTE    byOut, byIn;
    BOOL    bFailed = FALSE;
        
    wBit = bySeed; 
    _outp(wBaseReg, MMA_PCM_DATA);
    for (wAddr=0; wAddr <= 63; wAddr++)          // Fill FIFO with marching bits
        {
        byOut = bOnes ? (BYTE)wBit : (BYTE)~wBit;
        _outp(wBaseReg+1, byOut);
        if (wBit == 0x80)
            wBit = 1;
        else
            wBit <<= 1;
        } 
    Checkbreak();    
    wBit = bySeed;

    for (wAddr=0; wAddr <= 63; wAddr++)          // Test FIFO for marching bits
        {
        byOut = bOnes ? (BYTE)wBit : (BYTE)~wBit;
        byIn = _inp(wBaseReg+1);
        if (byOut != byIn)
            {
            bFailed = TRUE; 
            printf("FAILED at wAddr=%u ", wAddr);
            break;
            }
        if (wBit == 0x80)
            wBit = 1;
        else
            wBit <<= 1;
        }          
    CheckBreak();    
    return bFailed; 
    }  

#endif

//-----------------------------------------------------------------------
// Marching bits test for FIFO RAM
//-----------------------------------------------------------------------
BOOL MarchingBitsFifoTest   
    (
    BYTE bySeed,        // Initial seed, 0x01, 0x02, etc.
    BOOL bOnes          // TRUE = marching ones, FALSE = marching zeros
    )
    
    {
    WORD    wAddr, wBit;
    BYTE    byOut, byIn;
    BOOL    bFailed = FALSE;
        
    wBit = bySeed; 
    CheckBreak();
    ResetFifo();
    for (wAddr=0; wAddr <= (WORD)32764; wAddr++)          // Fill FIFO with marching bits
        {
        byOut = bOnes ? (BYTE)wBit : (BYTE)~wBit;
        _outp(FIFO_REG, byOut);
        if (wBit == 0x80)
            wBit = 1;
        else
            wBit <<= 1;
        } 
        
    wBit = bySeed;
    //ResetFifo(); 
    CheckBreak();

    for (wAddr=0; wAddr <= (WORD)32764; wAddr++)          // Test FIFO for marching bits
        {
        byOut = bOnes ? (BYTE)wBit : (BYTE)~wBit;
        byIn = _inp(FIFO_REG);
        if (byOut != byIn)
            {
            bFailed = TRUE;
            break;
            }
        if (wBit == 0x80)
            wBit = 1;
        else
            wBit <<= 1;
        }          
    CheckBreak();    
    return bFailed; 
    }  


//-----------------------------------------------------------------------  
// Test a volume register (listening test)
//-----------------------------------------------------------------------
BOOL TestVolume(WORD wVolReg)
    {
    WORD    wRot, wOpposite, wMask;
    char    ch;
    int     i;
    int     Step = -1;
    BOOL    bStepMode = FALSE; 
    BYTE    byValueSent;
    BYTE    byValueRead;


    if (wVolReg == MIX_LINEOUT_L || wVolReg == MIX_LINEOUT_R)
        {
        wRot = 1;
        wMask = 0x3e;
        wOpposite = (wVolReg & 1) ? -1 : 1; 
        }
    else
        {
        wRot = 2;
        wMask = 0x7c;
        wOpposite = (wVolReg & 1) ? 1 : -1; 
        }
    

    
    OutIndirect(MIX_REG, wVolReg+wOpposite, 0x00);      // Turn off the opposite channel
       
    FMKeyOn(0, NOTE_A4, 4);  
    
    i = 31;
    for (;;)
        {
        byValueSent = (BYTE) i << wRot;
        OutIndirect(MIX_REG, wVolReg, byValueSent); 
        byValueRead = InIndirect(MIX_REG, wVolReg);
        if ((byValueRead & wMask) != (byValueSent & wMask))
            {
            printf("FAILED! (read-back out %02x in %02x", byValueSent, byValueRead );
            break;
            }
        if (!CheckBreak() && _kbhit()) 
            {
            ch = _getch(); 
            if (ch == 'Y' || ch == 'y' || ch == 'N' || ch == 'n')
                break; 
            else if (ch == 'S' || ch == 's')
                bStepMode = !bStepMode; 
            else if (bStepMode)
                i += Step;              
            }
        if (!bStepMode)
            {
            Wait(100); 
            CheckBreak();
            i+= Step;
            }

        if (i == 0)             // Reverse
            Step = 1;
        else if (i == 31)
            Step = -1;
            
            
        }    
    FMKeyOff(0); 
    
    OutIndirect(MIX_REG, wVolReg, 0xff); 
    OutIndirect(MIX_REG, wVolReg+wOpposite, 0xff); 
    return (ch == 'N' || ch == 'n');
    }

#if 0
VOID Report(char *szString)
    {
    printf(szString);
    if (bReportToDisk)
        sprintf(ReportFile, szString);
    }
#endif 


VOID CtrlBreakHandler(int Sig)
    {
    bCtrlBreak = TRUE;
    }


//=========================================================================
// main()
//=========================================================================
VOID  main (INT argCount, CHAR* pszargList[])
    {
    BOOL    bItsIBMDammit;
    INT     Count;
    BYTE    bySeed; 
    CS_RETURN_CODE          RC;
    GETCARDSERVICESARGS     CsArgs; 
    WORD                    CSMajorRevision, CSMinorRevision, 
                            CSMajorRelease, CSMinorRelease;
    char            *szClient[] = {
                                  "I/OMagic Tempo MSDOS Card Services Client",
                                  "Media Magic PCMCIA Audio Card MSDOS Card Services Client",
                                  "I/OMagic Tempo Windows Driver",
                                  "Media Magic PCMCIA Audio Card Windows Driver"
                                  "Tempo MSDOS Card Services Client"        /* old */
                                  "MMPCMCIA MSDOS Card Services Client"     /* old */
                                  };
#define NUM_CLIENT_NAMES 6                                

    char            ch;  
    int             i;
    
    // Hook CTL-BREAK interrupt
    if (signal(SIGINT, CtrlBreakHandler) == SIG_ERR)
        {
        printf("Couldn't set SIGINT\n");
        abort();
        }                                           
    
    printf("\nI/O Magic Tempo Production Test, version 1.0.014\n\n");
    CheckBreak();              

    if (argCount != 2)
        {
        printf("\nERROR: You must supply the Tempo interrupt number.\n\n");
        printf("       Example: test 11\n");
        abort();
        }
        
    Irq = (BYTE)atoi(pszargList[1]);     // Sleezy, I know

    
    // Card Services test
    printf("Checking for Card Services driver installed...");
    CheckBreak();  
    
    // Some Card Services (i.e. IBM) may requires cSignature to be zero'd out
    CsArgs.cSignature[0] = CsArgs.cSignature[1] = 0;   
    
    RC = GetCardServicesInfo(sizeof(CsArgs), &CsArgs); 
    if (RC != CSRC_SUCCESS || CsArgs.cSignature[0] != 'C' || CsArgs.cSignature[1] != 'S')
        {
        printf("FAILED!\n");
        printf("--------------------------------------------------------------------\n");
        printf("You MUST have a PCMCIA Card Services driver, version 2.0 or higher\n");
        printf("(2.1 preferred) in order to run this test and to use the Tempo card.\n");
        printf("This driver should be supplied by your computer manufacturer.\n");
        printf("--------------------------------------------------------------------\n");
        abort();
        }
    printf("PASSED.\n");
    CSMajorRelease = HIBYTE(CsArgs.bcdCSLevel);
    CSMinorRelease = LOBYTE(CsArgs.bcdCSLevel);
    CSMajorRevision = HIBYTE(CsArgs.bcdRevision);
    CSMinorRevision = LOBYTE(CsArgs.bcdRevision);

    printf("--------------------------------------------------------------------\n");
    printf("Card Services found. Release: %x.%02x Vendor version: %x.%02x Sockets: %u\n", 
           CSMajorRelease, CSMinorRelease, CSMajorRevision, CSMinorRevision, CsArgs.wCount);  

    // Make a note if this is the infamous screwed-up IBM 2.0 Card Services
    if (CSMajorRelease == 2 && CSMinorRelease == 0 && 
        CSMajorRevision == 1 && CSMinorRevision == 0 &&
        !memcmp(CsArgs.szVendorString, "Copyright 1993 IBM", 18)) 
        {
        printf("Recognized IBM CS 2.0 Rel 1.0 with faulty GetTupleData() - using workaround\n");
        bItsIBMDammit = TRUE; 
        }
           
    if (CsArgs.wVstrLen)
        {
        printf("%s\n", CsArgs.szVendorString);  
        }  
    printf("--------------------------------------------------------------------\n");

    if (CSMajorRelease < 0x02)
        {
        printf("Error: Card Services release obsolete.\n\n");
        printf("       This I/O Magic Tempo PCMCIA Card Services Client requires Card Services\n");
        printf("       Release 2.0 or higher (2.10 perferred). Releases prior to 2.0\n");
        printf("       support memory cards only and cannot support I/O devices.\n\n");
        printf("       Contact the manufacturer of your computer or PCMCIA PC Card\n");
        printf("       socket adaptor to obtain updated drivers.\n\n");
        abort();
        } 

    if (CSMajorRelease == 0x02 && CSMinorRelease < 0x10)
        {
        printf("Warning: Card Services Release out of date.\n\n");
        printf("       This I/O Magic Tempo PCMCIA Card Services Client is designed to work\n");
        printf("       with Card Services Release 2.10. While it will work with the\n");
        printf("       release installed on your computer, you should upgrade your\n");
        printf("       Card Services for maximum performance and compatability.\n\n");
        printf("       Contact the manufacturer of your computer or PCMCIA PC Card\n");
        printf("       socket adaptor to obtain updated drivers.\n");        
        printf("--------------------------------------------------------------------\n");
        } 

        
    if (CSMajorRelease > 0x02 || (CSMajorRelease == 0x02 && CSMinorRelease > 0x10))
        {
        printf("Warning: This I/O Magic Tempo Card Services Client may be out of date.\n\n");
        printf("         This I/O Magic Tempo PCMCIA Card Services Client is designed to work\n");
        printf("         with Card Services Release 2.10. While it MAY work with the release\n");
        printf("         installed on your computer, it is possible that changes have been\n");
        printf("         made in the PCMCIA Card Services specification that would render\n");
        printf("         this Client incompatible with the installed Card Services.\n\n"); 
        printf("         PROCEED WITH EXTREME CAUTION!\n\n");
        printf("         Contact I/O Magic to obtain an updated Tempo Card Services Client\n"); 
        printf("         or to ascertain that this Client is compatible with the installed\n");
        printf("         Card Services driver.\n");
        printf("--------------------------------------------------------------------\n");
        } 
        
    CheckBreak();    

    // Card Services client test
    { 
    GETFIRSTNEXTCLIENTARGS  ClientArgs;
    CLIENTHANDLE            ClientHandle;
    GETCLIENTINFO           ClientInfo;  
    BOOL                    bPassed = FALSE;

    printf("Testing for Tempo Card Services client installed...");
    ClientArgs.wSocket = 0;
    ClientArgs.wAttributes = 0;
    RC = GetFirstClient(&ClientHandle, &ClientArgs);
    if (RC != CSRC_SUCCESS && RC != CSRC_NO_MORE_ITEMS)
        {
        printf("FAILED!\nERROR: Unexpected return code from GetFirstClient: %x\n", RC);
        abort();
        }
    while (RC != CSRC_NO_MORE_ITEMS)
        {
        ClientInfo.wMaxLength = sizeof(GETCLIENTINFO);
        ClientInfo.wAttributes = CLINFO_ATTR_IOCLIENT;
        RC = GetClientInfo(ClientHandle, &ClientInfo); 
        if (RC != CSRC_SUCCESS)
            {
            printf("FAILED!\nERROR: Unexpected return code from GetClientInfo: %x\n", RC);
            abort();            
            } 
            
        for (i=0; i<NUM_CLIENT_NAMES; i++)
            {
            if (!strcmp(ClientInfo.szNames, szClient[i]))
                {
                printf("PASSED\n"); 
                bPassed = TRUE;
                break;
                } 
            }
             
        if (bPassed)
            break;
            
        RC = GetNextClient(&ClientHandle, &ClientArgs);
        } 
    
    if (RC == CSRC_NO_MORE_ITEMS)
        {    
        printf("FAILED.\n");
        abort();
        }
    }
    CheckBreak();

#if 0    
    do
        {
        printf("Do you wish to save reports on disk? (Y/N):");  
        while (!CheckBreak() && !_kbhit());        
        ch = _getch();
        ch = tolower(ch);
        } while (ch != 'y' && ch != 'n');  
        
    printf("\n"); 
    bReportToDisk = (ch == 'y'); 
    if (bReportToDisk)
        for (;;)
            {      
            printf("\nEnter file name for report:");
            if (!CheckBreak() && !gets(szReportFile)) 
                {
                if (strlen(szReportFile) > 8)
                    printf(" ERROR: must be < 8 characters!\n");
                }
            else
                break;      
            }
#endif
            
//=============================================================================
// Card LOOP
//=============================================================================
CardLoop:
    for (i=0; i < NUM_TESTS; i++)
        TestResult[i] = NOT_RUN;

    printf("\n(OK to change cards) Press 'Q' to quit, any other key to start test...");
    while (!CheckBreak() && !_kbhit());     
    ch = _getch();
    if (ch == 'q' || ch == 'Q')
        {
        printf("quitting.");
        goto Exit;
        }
    printf("OK\n");
        
    for (;;)
        {      
        printf("\nEnter card serial number:");
        if (!CheckBreak() && !gets(szSerialNumber)) 
            {
            if (strlen(szSerialNumber) > 8)
                printf(" ERROR: must be < 8 characters!\n");
            }
        else
            break; 
        }
    
    //-------------------------------------------------------------------------                 
    // Test mixer registers for read/write ability
    //------------------------------------------------------------------------- 
    OutTmpx(TMPX_PLAY | TMPX_TSM_RESET | TMPX_MRESET | TMPX_AGEN_RESET);    // Need this though!
    MReset();

    TestResult[TEST_MIXREG_LINEOUT_L]   = TestIndirect(MIX_REG, MIX_LINEOUT_L, MIX_LINEOUT_MASK);
    TestResult[TEST_MIXREG_LINEOUT_R]   = TestIndirect(MIX_REG, MIX_LINEOUT_R, MIX_LINEOUT_MASK);
    TestResult[TEST_MIXREG_MODE]        = TestIndirect(MIX_REG, MIX_MODE, MIX_MODE_MASK);
    TestResult[TEST_MIXREG_FM_L]        = TestIndirect(MIX_REG, MIX_FM_L, MIX_FM_MASK);
    TestResult[TEST_MIXREG_FM_R]        = TestIndirect(MIX_REG, MIX_FM_R, MIX_FM_MASK);
    TestResult[TEST_MIXREG_MMA_L]       = TestIndirect(MIX_REG, MIX_MMA_L, MIX_MMA_MASK);
    TestResult[TEST_MIXREG_MMA_R]       = TestIndirect(MIX_REG, MIX_MMA_R, MIX_MMA_MASK);
    TestResult[TEST_MIXREG_MIC_L]       = TestIndirect(MIX_REG, MIX_MIC_L, MIX_MIC_MASK);
    TestResult[TEST_MIXREG_MIC_R]       = TestIndirect(MIX_REG, MIX_MIC_R, MIX_MIC_MASK);
    TestResult[TEST_MIXREG_SELECT]      = TestIndirect(MIX_REG, MIX_SELECT, MIX_SELECT_MASK);


    //------------------------------------------------------------------------- 
    // Test readable MMA registers for read/write ability
    // (not all MMA registers are readable)
    //
    //      MMA_SELT      (low bit only)
    //      MMA_TIMER2_L
    //      MMA_TIMER2_H
    //      MMA_PCM_DATA
    //      MMA_MIDI_DATA
    //
    // Note that, of these registers, only MMA_PCM_DATA is present on channel 2  
    //
    // We cannot do a read/write test on the MMA_TIMER ports or MMA_MIDI_DATA:
    // MMA_TIMER gives the current value of the timer - to test this, we will
    // have to start the timer and verify that it counts down
    // MMA_MIDI_DATA reflects the values in the MIDI_IN FIFO, and does not
    //  reflect values send to MIDI_OUT
    //-------------------------------------------------------------------------
    TestResult[TEST_MMAREG_SELT_1]      = TestIndirect(MMA_REG, MMA_SELT, MMA_SELT_MASK); // Only on ch 0
    TestResult[TEST_MMAREG_PCM_DATA_1]  = TestIndirect(MMA_REG, MMA_PCM_DATA, 0xff);
    TestResult[TEST_MMAREG_PCM_DATA_2]  = TestIndirect(MMA_REG2, MMA_PCM_DATA, 0xff);


#ifdef TEST_MMA_FIFO        
    //------------------------------------------------------------------------- 
    // Test 128-byte FIFO RAM in each channel of the MMA
    // This is separate from the 32K external FIFO 
    //-------------------------------------------------------------------------     

    for (wChannel=0; wChannel < 2; wChannel++) 
        { 
        CheckBreak();
        bySeed = 1; 
        printf("Testing MMA FIFO memory, channel %u .", wChannel);
        for (Count = 0; Count <8; Count++)
            {
            bFailedMMAFIFO = MarchingBitsMMAFifoTest(MMA_REG+(2*wChannel), bySeed, TRUE);  // Marching ones  
            printf(".");
            if (TRUE == bFailedMMAFIFO) 
                { 
                printf(" Count=%u, marching ones\n",Count);
                break;  
                }
            bFailedMMAFIFO = MarchingBitsMMAFifoTest(MMA_REG+(2*wChannel), bySeed, FALSE); // Marching zeros  
            printf(".");
            if (TRUE == bFailedMMAFIFO) 
                { 
                printf(" Count=%u, marching zeros\n", Count);
                break;
                }
            bySeed <<= 1;
            }    
        printf(" done.\n"); 
        }
        
#endif            
    
    //-------------------------------------------------------------------------
    // Test FIFO RAM
    //-------------------------------------------------------------------------
    
    // We only print the first FIFO failure - otherwise the output could get 
    //  QUITE lengthy!

    TestResult[TEST_FIFO_ADDR] = AddressFifoTest();

    bySeed = 1; 
    printf("Testing FIFO memory .");
    for (Count = 0; Count <8; Count++)
        { 
        CheckBreak();
        TestResult[TEST_FIFO_MEM] = MarchingBitsFifoTest(bySeed, TRUE);  // Marching ones 
        printf(".");
        if (FAIL == TestResult[TEST_FIFO_MEM])
            break; 
        CheckBreak();
        TestResult[TEST_FIFO_MEM] = MarchingBitsFifoTest(bySeed, FALSE); // Marching zeros  
        printf(".");
        if (FAIL == TestResult[TEST_FIFO_MEM])
            break;
        bySeed <<= 1;
        }
    
    printf(" done.\n"); 
                      
//-----------------------------------------------------------------------------
// FM Synth test
//
// Pretty cheesy - we can't read the registers, so we can't test bits
// It's a HUGE pain to play anything - we should exec an external
// AdLib player to play something.
// But we CAN play white noise with the test register 
//
//-----------------------------------------------------------------------------                      
    MReset();                   // Reset after mucking with registers!


    printf("Loading MIDPAK driver...");
    if ( !LoadMidPak("MIDPAK.COM", "MIDPAK.ADV", "MIDPAK.AD" ) ) // Load MIDPAK into memory.
        {
        printf("FAILED!\n"); 
        printf("--------------------------------------------------------------------\n");
        printf("One of the following files was not found:\n\n");
        printf("    midpak.com\n");
        printf("    midpak.adv\n");
        printf("    midpak.ad\n\n");
        printf("These files must be present in the same directory that you ran\n");
        printf("test.exe from.\n");
        printf("--------------------------------------------------------------------\n");
        abort();                            // Cannot continue  
        }        
        
    if ( !InitMidPak() ) // Initialize MIDPAK driver.
        {
        printf("FAILED!\n");        
        printf("--------------------------------------------------------------------\n");
        printf("Initialization of MIDPAK driver failed!\n");
        printf("--------------------------------------------------------------------\n");
        UnLoadMidPak();
        abort();                    // Cannot continue  
        } 
    printf("loaded!\n"); 


    PlayFM("test"); 
      
    TestResult[TEST_SYNTH_PLAY] = AskPass("Did file play correctly?"); 
    DeInitMidPak();
    UnLoadMidPak();
    printf("MIDPAK driver unloaded.\n");    

//-----------------------------------------------------------------------------
// MMA Play Tests
//----------------------------------------------------------------------------- 

    printf("8K playback test:\n");
    PlayWave("8K.wav", 3, FALSE);
    TestResult[TEST_MMA_PLAY_8K] = AskPass("Did file play correctly?"); 
    printf("11K playback test:\n");
    PlayWave("11K.wav", 2, FALSE);
    TestResult[TEST_MMA_PLAY_11K] = AskPass("Did file play correctly?");   
    printf("22K playback test:\n"); 
    PlayWave("22K.wav", 1, FALSE);
    TestResult[TEST_MMA_PLAY_22K] = AskPass("Did file play correctly?");

//-----------------------------------------------------------------------------
// Mixer volume control tests
//-----------------------------------------------------------------------------
    OutIndirect(MIX_REG, MIX_FM_L, 0xff);
    OutIndirect(MIX_REG, MIX_FM_R, 0xff);
    OutIndirect(MIX_REG, MIX_MMA_L, 0);
    OutIndirect(MIX_REG, MIX_MMA_R, 0);

    printf("Volume control tests:\n\n");
    printf("For each test, press Y when you are satistifed that the volume control\n");
    printf("is working properly, or N if it is not working properly.\n\n");
    printf("Pressing S will place the test in 'step mode', allowing you to\n");
    printf("step manually with the space bar - there should be 32 steps\n");
    printf("up and down for each control\n");
    CheckBreak();

    FMReset();
    SetTestVoice();

    // LINEOUT (using FM source)
    printf("Testing LEFT LineOut volume...");
    TestResult[TEST_AT_LINEOUT_L] = TestVolume(MIX_LINEOUT_L); 
    printf("testing RIGHT LineOut volume..."); 
    TestResult[TEST_AT_LINEOUT_R] = TestVolume(MIX_LINEOUT_R);  
    
    // FM
    printf("\nTesting LEFT FM volume...");
    TestResult[TEST_AT_FM_L] = TestVolume(MIX_FM_L);
    printf("testing RIGHT FM volume...");
    TestResult[TEST_AT_FM_R] = TestVolume(MIX_FM_R);

    // MMA
    OutIndirect(MIX_REG, MIX_FM_L, 0x00);
    OutIndirect(MIX_REG, MIX_FM_R, 0x00);
    
    PlayWave("1000hz.wav", 2, TRUE);    // Play endlessly
    printf("\nTesting LEFT MMA volume...");
    TestResult[TEST_AT_MMA_L] = TestVolume(MIX_MMA_L);
    printf("testing RIGHT MMA volume...");
    TestResult[TEST_AT_MMA_R] = TestVolume(MIX_MMA_R);
    EndWave();  
    
    // LineIn/Mic
    OutIndirect(MIX_REG, MIX_MMA_L, 0x00);
    OutIndirect(MIX_REG, MIX_MMA_R, 0x00);
    printf("\nFor the following test, connect a signal (preferably a tone) to\n");
    printf("the LineIn jack. Make sure that the microphone is turned OFF.\n"); 
    printf("Testing LEFT LineIn/Mic volume...");
    TestResult[TEST_AT_LINEIN_L] = TestVolume(MIX_MIC_LINEIN_L);
    printf("testing RIGHT LineIn/Mic volume...");
    TestResult[TEST_AT_LINEIN_R] = TestVolume(MIX_MIC_LINEIN_R);
    
    
    printf("\n");    

//-----------------------------------------------------------------------------
// MMA Record and Play Tests
//-----------------------------------------------------------------------------
    OutIndirect(MIX_REG, MIX_LINEOUT_L, 0xff);
    OutIndirect(MIX_REG, MIX_LINEOUT_R, 0xff);    
    OutIndirect(MIX_REG, MIX_MMA_L, 0xff);
    OutIndirect(MIX_REG, MIX_MMA_R, 0xff);

    //---------------------------------------------------
    // Line in 
    OutIndirect(MIX_REG, MIX_LINEIN_L, 0xff);
    OutIndirect(MIX_REG, MIX_LINEIN_R, 0xff);
    OutIndirect(MIX_REG, MIX_MIC_L, 0x00);
    OutIndirect(MIX_REG, MIX_MIC_R, 0x00);
    
    printf("Please prepare to record from LINEIN.\n");
    RecWave("linein.wav", 1); 
    printf("Press any key to play back...");
    _getch();
    printf("\n");   
    PlayWave("linein.wav", 1, FALSE);
    TestResult[TEST_REC_LINEIN] = AskPass("Did you hear what you recorded?");

    //---------------------------------------------------
    // Mic 
    OutIndirect(MIX_REG, MIX_LINEIN_L, 0x00);
    OutIndirect(MIX_REG, MIX_LINEIN_R, 0x00);
    OutIndirect(MIX_REG, MIX_MIC_L, 0xff);
    OutIndirect(MIX_REG, MIX_MIC_R, 0xff); 
    
    
    printf("Please prepare to record from MIC.\n");
    RecWave("mic.wav", 1); 
    printf("Press any key to play back...");
    _getch();
    printf("\n");
    PlayWave("mic.wav", 1, FALSE);
    TestResult[TEST_REC_MIC] = AskPass("Did you hear what you recorded?");
    

    //--------------------------------------------------- 
    
    SayPassOrFailAll();                                     
        

    goto CardLoop;


Exit:                
        
    DeInitMidPak();
    UnLoadMidPak();                
    }
