        page    60, 132

;******************************************************************************
;  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
;  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
;  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
;  PURPOSE.
;
;  Copyright (c) 1994 - 1995 Microsoft Corporation.	All Rights Reserved.
;******************************************************************************
;
;   Title:    DREAM.INC - MICROSOFT MPU401 Driver Common VxD Interface
;
;   Module:   DREAM.INC - public equates/structure definitions
;
;   Version:  4.00
;******************************************************************************
;
;   NOTES:
;       This common interface is supported by VxDs wishing to use the
;       DREAM.DRV MIDI interface driver.  This include file defines the
;       API interface and structures used by DREAM.DRV.
;
;******************************************************************************

;DREAM_Device_ID              equ 44ch    ; Device ID for DREAM.386

MPX			equ 4			; nb of shift to have MPX 0-1 
DSR           equ 80H       ; data set ready 0 = ready
DRR           equ 40H       ; data receive ready 0 = ready

DREAM_Ver_Major              equ 5       ; version 4.00 of this VxD
DREAM_Ver_Minor              equ 0

;
; PMode and RMode API indexes
;

PIPE_API_Open                   equ 0200h   ; pipeOpen()
PIPE_API_Close                  equ 0201h   ; pipeClose()

DREAML_API_Get_Version       equ 0300h   ; get version info of
                                            ; supporting VxD.

DREAM_API_Get_Info           equ 0301h
DREAM_API_GetInfoF_DevNode   equ 0001h   ; devnode specified in ECX
DREAM_API_GetInfoF_Mask      equ 0001h   ; valid functions

DREAM_API_Acquire            equ 0302h
DREAM_API_Release            equ 0303h

;
; Error returns for DREAM_API_Acquire/Release (returned in Client_AX)
;

DREAM_API_Err_Bad_Base_Port   equ 0001h
DREAM_API_Err_Already_Owned   equ 0002h
DREAM_API_Err_Not_Yours       equ 0003h
DREAM_API_Err_State_Unknown   equ 8000h

;
; MSOPL information structure
;

DREAMINFO struc

        msmi_dwSize             dd  ?   ; size of structure
        msmi_wHardwareOptions   dw  ?   ; hardware support
        msmi_wIOAddressMPU401   dw  ?   ; base I/O
        msmi_bIRQ               db  ?   ; IRQ connected or -1
        msmi_bReserved          db  ?
        msmi_wVersionVxD        dw  ?
        msmi_wFlags             dw  ?
        msmi_wReserved          dw  ?

        msmi_dn                 dd  ?   ; PnP DevNode
        msmi_dwIRQHandle        dd  ?   ; VPICD IRQ handle
        msmi_dwMPU401OwnerCur   dd  0   ; VM handle of current MPU401 owner
		msmi_dwMPU401OwnerCur2   dd  0   ; VM handle of current add. ports owner
        msmi_dwMPU401OwnerLast  dd  ?   ; VM handle of previous MPU401 owner
        msmi_hMPU401Stubs       dd  0   ; trap stubs for MPU-401
		msmi_DreamCard			dw	0	; Is it dream or mpu card?
		msmi_DsRunning			dw 0	; DirectSound running flag
		msmi_pDSDriver			dd  ?   ; ptr to Direct Sound Driver object
DREAMINFO ends

DREAM_HWOPTIONSF_IRQSHARED   equ     0001    ; IRQ is shared, controlling
                                                ; driver will open pipe to
                                                ; grab ISR entry

MSMI_FLAG_DISABLEWARNING        equ 0001h   ; warnings disabled on contention
MSMI_FLAG_IRQWASUNMASKED        equ 8000h   ; irq being used was unmasked
