        page 60, 132
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   commona.asm
;
;   Copyright (c) 1991-1992 Microsoft Corporation.  All rights reserved.
;
;   General Description:
;      Contains wave and midi support routines that don't need to be fixed.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        .286

        .xlist
		include mpu401.inc
        include cmacros.inc                   
        include windows.inc
        include mmsystem.inc
        include mmddk.inc
        include dream94.inc
        .list

        ?PLM=1                          ; Pascal calling convention
        ?WIN=0                          ; NO! Windows prolog/epilog code

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   extrn declarations
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 

        externW  <gwPort>		; use in asm
		externW <_gwPort>		; use in C
        externFP <ReadP16>              ; sndblst.asm

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   segmentation
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

IFNDEF SEGNAME
        SEGNAME equ <_TEXT>
ENDIF

createSeg %SEGNAME, CodeSeg, word, public, CODE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   data segment
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sBegin Data
    globalW gwAcquireCount,     0   ; acquire count for sound blaster
sEnd Data

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   code segment
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sBegin CodeSeg

        assumes cs, CodeSeg
        assumes ds, DATA

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; CritEnter
;
;   Saves the current state of the interrupt flag on the stack and
;   then disables interrupts.
;
; Registers Destroyed:
;       BX, FLAGS
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        assumes ds, nothing
        assumes es, nothing

cProc CritEnter <FAR, PASCAL, PUBLIC>, <>
cBegin nogen
        pop     dx                      ; get return address
        pop     ax
        pushf
        pushf
        pop     bx
        test    bh, 2                   ; if interrupts are already off, don't
        jz      no_cli                  ; ... blow ~300 clocks doing the cli
        cli
no_cli:
        push    ax
        push    dx
        ret
cEnd nogen

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; CritLeave
;
;   Restores the interrupt state saved by CritEnter
;
; Registers Destroyed:
;       BX, FLAGS
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        assumes ds, nothing
        assumes es, nothing

cProc CritLeave <FAR, PASCAL, PUBLIC>, <>
cBegin nogen
        pop     dx                      ; get return address
        pop     ax

        pop     bx
        test    bh, 2
        jz      no_sti
        sti
no_sti:
        push    ax
        push    dx
        ret
cEnd nogen

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; @doc INTERNAL
;
; @asm CReset ex dspReset | Reset the DSP.
;
; @rdesc If the reset is completed successfully then the carry
;     flag is cleared and 0 is returned in AX.  If an error
;     occurs, carry is set and an error code is returned in AX.   
;
;14-12-95
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        assumes ds, Data
        assumes es, nothing

        public CReset
CReset proc far

        D2 <*****************CReset*******************>

        AssertF byte ptr [gwAcquireCount]   ; better have acquired it already!

        mov     dx, [gwPort]                ; get the base port address
        add     dx, MPU401_REG_COMMAND          ; point to reset port
        mov     al, MPU401_CMD_UART_MODE
        out     dx, al                      ; reset active

        ; read the data port to confirm 0feH is there

        mov     cx, 60000                      ; lots of tries
        mov		ax, 0							; clear it
reset1:
        call    ReadP16
        cmp		al, 0feh 
        loopne	reset1

        cmp     al, 0FEH                    ; correct return value ?
        jz      reset3                      ; jump if it is
        
        mov     ax, -1                      ; bad reset!
        jmp     reset4

reset3:

        xor     ax, ax

reset4:
        ret

CReset endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; @doc INTERNAL 
;
; @asm  void | MemCopy | memory copy
;
; @parm LPVOID | lpDst | destiation
; @parm LPVOID | lpSrc | source
; @parm WORD   | wCount | number of bytes to copy
;
; @rdesc nothing
;
; @comm This function does not handle segment crossings
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        assumes ds, nothing
        assumes es, nothing

cProc MemCopy <FAR, PASCAL, PUBLIC> <ds, si, di>
        ParmD   lpDst
        ParmD   lpSrc
        ParmW   wCount
cBegin

        cld                             ; let's not assume this
        lds     si, lpSrc               ; get source pointer
        les     di, lpDst               ; get dest pointer
        mov     cx, wCount              ; cx is count of bytes

        shr     cx, 1                   ; copy the memory
        rep     movsw
        adc     cl, cl
        rep     movsb

cEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 
; @asm  void |SetwPort
;
; realize the equlity : gwPort=_gwPort
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        assumes ds, nothing
        assumes es, nothing

cProc SetwPort <FAR, PASCAL, PUBLIC> <>
        
cBegin
	mov	ax, _gwPort			; previously set in init.c
	mov	[gwPort], ax
cEnd

sEnd CodeSeg

        end
